/* WORDS.C */

/* (c) 1994, Matt McLeod */
/* This program is "postcardware".  You can use it as you like, but */
/* please send me a postcard if you continue using WORDS.           */

/* This is the main program for WORDS.  It parses the command-line, */
/* and calls word_count() as needed.                                */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "wcount.h"

int main(int argc, char *argv[])
{
	FILE *filein;
	int n = 1, totalwords = 0, words = 0;
	
	_wildcard(&argc, &argv);
	if (argc == 1)
	{
		printf("WORDS 0.1  - (c) 1994 by Matt McLeod\n");
		printf("This program is 'postcardware'.  See WORDS.DOC for info.\n");
		printf("\n");
		printf("Syntax:  words <filename1> <filename2> .. <filenamen>\n");
		return 1;
	};
	while (argv[n]!=NULL)
	{
		filein = fopen(argv[n],"r");
		words = count_words(filein);
		totalwords = totalwords + words;
		printf("%s: %i\n", argv[n], words);
		fclose(filein);
		n++;
	};
	printf("Total wordage: %i", totalwords);
	return 0;
};
