@echo off
rem ****************************************************************************
rem *             UM-Editor installation program (version 1.01)
rem ****************************************************************************

rem Initialisations
rem ---------------
set UMEDPE=

rem Installation interactive en l'absence des parametres
rem ----------------------------------------------------
if "%1"=="" goto inter
if "%2"=="" goto inter

rem Entete installation non interactive et prise en compte des parametres
rem ---------------------------------------------------------------------

set UMEDII=0

echo.
echo Starting UM-Editor installation program
echo.

set UMEDD=%1
if "%UMEDD%"=="" goto enverr
set UMEDPA=%2\UMEDITOR
if "%UMEDPA%"=="" goto enverr

goto verdisk

rem Entete installation interactive
rem -------------------------------
:inter

set UMEDII=1
cls
echo.
echo.
echo UM-Editor - Installation program
echo --------------------------------
echo.
echo.

rem Verification du disque courant
rem ------------------------------
:verdisk
if not exist INSTALL.BAT goto baddir

rem Verification de l'existence des utilitaires
rem -------------------------------------------
if not exist GETVAR.EXE goto noutil

rem Tentative de copie de GETVAR.EXE sur disque
rem -------------------------------------------
if "%temp%"=="" goto tryc
xcopy GETVAR.EXE %temp%\ >nul
if errorlevel 1 goto tryc
set UMEDT=%temp%
goto drivok

:tryc
xcopy GETVAR.EXE C:\ >nul
if errorlevel 1 goto tryd
set UMEDT=C:
goto drivok

:tryd
xcopy GETVAR.EXE D:\ >nul
if errorlevel 1 goto notmp
set UMEDT=D:

:drivok
if "%UMEDII%"=="1" goto dialint

rem Verifications installation non interactive
rem ==========================================

rem Verifie l'existence d'une precedente installation
rem pour la mettre a jour
rem -------------------------------------------------
if not exist %UMEDD%\ETC\UMEDPATH goto copyfiles

%UMEDT%\getvar.exe UMEDPE %UMEDT% <%UMEDD%\ETC\UMEDPATH
call %UMEDT%\setenv.bat
if "%UMEDPE" == "" goto copyfiles

if not exist %UMEDD%%UMEDPE%\UMED.EXE goto copyfiles

set UMEDPA=%UMEDPE%
goto copyfiles

rem Dialogue Installation interactive
rem =================================
:dialint
rem Demande le nom du disque d'installation
rem ---------------------------------------
echo Enter disk where UM-Editor is to be loaded [ C: ] :
%UMEDT%\getvar.exe UMEDD %UMEDT%
call %UMEDT%\setenv.bat
if "%UMEDD%"=="" set UMEDD=C:
if "%UMEDD%"=="" goto enverr

rem Verifie l'existence d'une precedente installation
rem -------------------------------------------------
if not exist %UMEDD%\ETC\UMEDPATH goto askdir
%UMEDT%\getvar.exe UMEDPE %UMEDT% <%UMEDD%\ETC\UMEDPATH
call %UMEDT%\setenv.bat
if "%UMEDPE%" == "" goto askdir
if not exist %UMEDD%%UMEDPE%\UMED.EXE goto askdir

echo UM-Editor is already installed in directory %UMEDD%%UMEDPE%.
echo Continue and update currently installed UM-Editor (Y/N) ?
%UMEDT%\getvar.exe REPONS %UMEDT%
call %UMEDT%\setenv.bat
if not "%REPONS%" == "Y" if not "%REPONS%" == "y" goto abort

set UMEDPA=%UMEDPE%
goto copyfiles

rem Demande le repertoire d'installation
rem ------------------------------------
:askdir
echo Enter path where UM-Editor is to be loaded [ \UPSMAN ] :
%UMEDT%\getvar.exe UMEDP %UMEDT%
call %UMEDT%\setenv.bat
if "%UMEDP%"=="" set UMEDP=\UPSMAN
if "%UMEDP%"=="" goto enverr

set UMEDPA=%UMEDP%\UMEDITOR

rem Demande confirmation
rem --------------------
echo UM-Editor will be loaded from distribution disk to %UMEDD%%UMEDP%.
echo Continue (Y/N) ?
%UMEDT%\getvar.exe REPONS %UMEDT%
call %UMEDT%\setenv.bat
if not "%REPONS%" == "Y" if not "%REPONS%" == "y" goto abort

rem Copie des fichiers
rem ==================
:copyfiles

rem Creation du fichier ETC\UMEDPATH avec creation du repertoire ETC si besoin
rem --------------------------------------------------------------------------
echo Writing to file %UMEDD%\ETC\UMEDPATH ...
echo.
if not exist %UMEDD%\ETC\*.* md %UMEDD%\ETC >nul
echo %UMEDPA%>%UMEDD%\ETC\UMEDPATH
if not exist %UMEDD%\ETC\UMEDPATH goto coperr

rem Copie des fichiers
rem ------------------
echo Copying files to directory %UMEDD%%UMEDPA%\ ...
echo.
xcopy GETVAR.EXE %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr
xcopy XWM*.DLL %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr
xcopy DESINST.BAT %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr
xcopy DESINST1.BAT %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr
xcopy UMED.HLP %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr
xcopy UMED.EXE %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr

if exist DESINST.PIF xcopy DESINST.PIF %UMEDD%%UMEDPA%\
if errorlevel 1 goto coperr


rem Installation terminee
rem =====================
:complete
echo.
if not "%UMEDPE%" == "" echo UM-Editor has been updated in directory %UMEDD%%UMEDPA%.
echo UM-Editor installation procedure completed.
echo.
goto fin

rem Mauvais repertoire de lancement
rem -------------------------------
:baddir
  echo.
  echo 
  echo Error : current directory must be directory where INSTALL.BAT is located.
  goto abort

rem Utilitaires manquants
rem ---------------------
:noutil
echo.
echo 
echo Error : utilities are missing on the distribution disk.
goto abort

rem Pas de repertoire temporaire
rem ----------------------------
:notmp
echo.
echo 
echo Error : no temporary directory was found.
echo Set TEMP environment variable with the name of a
echo temporary working directory (ex : SET TEMP=C:\TMP).
goto abort

rem Erreur d'environnement DOS
rem --------------------------
:enverr
echo.
echo 
echo Environment error,
goto abort

rem Erreur de copie
rem ---------------
:coperr
echo.
echo 
echo Copy error,

:abort
echo Installation procedure aborted.
goto fin

rem Fin des traitements
rem -------------------
:fin

if not "%UMEDT%"=="" if exist %UMEDT%\getvar.exe erase %UMEDT%\getvar.exe >nul
if not "%UMEDT%"=="" if exist %UMEDT%\setenv.bat erase %UMEDT%\setenv.bat >nul

set UMEDT=
set UMEDD=
set UMEDP=
set UMEDPA=
set UMEDPE=
set REPONS=

echo.

if "%UMEDII%"=="1" pause

set UMEDII=
