@echo off
rem ****************************************************************************
rem * Programme d'installation de UM-Agent pour OS/2 2
rem ****************************************************************************
SET NULFILE=
cls
echo UM-Agent OS/2 Installation Program
echo ----------------------------------
echo.
echo.

rem verifying if the current drive and directory is Ok
rem --------------------------------------------------
set BFNAME=INSTALL
set BFEXT=.BAT
if exist %BFNAME%%BFEXT% goto rightdr
echo *************************  W A R N I N G  ******************************
echo The current drive and directory must be that where %BFNAME%%BFEXT% is located.
echo The command you typed is :
echo %0
echo To set the right current drive, type :
echo X:
echo where X is the drive letter of the drive where %BFNAME%%BFEXT% is located
echo (most of the times, floppy drives are A: or B:, and CD-ROM drive is E:).
echo After changing to the right drive, you must set the current directory :
echo CD dirname
echo where dirname is the entire path to the directory where %BFNAME%%BFEXT% is
echo located, begining with the character \.
echo You can then re-run %BFNAME% by typing :
echo %BFNAME%
echo ************************************************************************
echo 
goto abort

rem the current drive & directory is Ok
rem -----------------------------------
:rightdr

rem * Vrifie l'existence des utilitaires
if exist GETVAR.EXE if exist RECH_LIG.EXE goto copytmp
echo.
echo 
echo Installation program cannot be run from this drive,
echo set distribution disk as current disk.
goto abort

rem * Tentative de copie de getvar.exe et rech_lig.exe sur disque
:copytmp
if "%temp%"=="" goto tryc
xcopy GETVAR.EXE %temp%\ >nul
if errorlevel 1 goto tryc
set UMAT=%temp%
goto drivok

:tryc
xcopy GETVAR.EXE C:\ >nul
if errorlevel 1 goto tryd
set UMAT=C:
goto drivok

:tryd
xcopy GETVAR.EXE D:\ >nul
if errorlevel 1 goto notmp
set UMAT=D:

rem * Nom du disque d'installation
:drivok
if "%UMAT%"=="" goto enverr
echo Enter OS/2 system disk drive [ C: ] :
%UMAT%\getvar.exe DRIVE %UMAT%
call %UMAT%\setenv.bat
if "%DRIVE%"=="" set DRIVE=C:

rem * Nom du rpertoire d'installation
echo Enter path where UM-Agent is to be loaded [ \UPSMAN ] :
%UMAT%\getvar.exe UMPATH %UMAT%
call %UMAT%\setenv.bat
if "%UMPATH%"=="" set UMPATH=\UPSMAN

rem * Confirmation avant installation
echo UM-Agent will be loaded to %DRIVE%%UMPATH%. Continue (Y/N) ?
%UMAT%\getvar.exe REPONS %UMAT%
call %UMAT%\setenv.bat
if not "%REPONS%" == "Y" if not "%REPONS%" == "y" goto abort

rem * Dfinition des sous-rpertoires
rem * et test si les variables ont t correctement crees.
set DEST=%DRIVE%%UMPATH%
if not "%DEST%" == "%DRIVE%%UMPATH%" goto erreur

set REPUMA=%DEST%\UMAGENT
if not "%REPUMA%" == "%DEST%\UMAGENT" goto erreur

set REPDEF=%REPUMA%\DEFAULT
if not "%REPDEF%" == "%REPUMA%\DEFAULT" goto erreur

set REPSAV=%REPUMA%\SAVE
if not "%REPSAV%" == "%REPUMA%\SAVE" goto erreur

rem * Cration du rpertoire ETC s'il n'existe pas.
if exist %DRIVE%\ETC\*.* goto suite2
  echo Creating %DRIVE%\ETC directory.
  md %DRIVE%\ETC %NULFILE%
:suite2

rem * sauvegarde des fichiers *.INI, UMAPARAM et MIB.TBL, s'ils existent,
rem * dans le rpertoire UPSMAN\SAVE.
if not exist %REPUMA%\*.* goto suite7
  echo Saving existing initialization files to directory %REPSAV% ...
  if exist %REPUMA%\*.ini xcopy %REPUMA%\*.ini %REPSAV%\ %NULFILE%
  if errorlevel 1 goto erreur
  if exist %REPUMA%\umaparam.* xcopy %REPUMA%\umaparam.* %REPSAV%\ %NULFILE%
  if errorlevel 1 goto erreur
  if exist %REPUMA%\user.cmd xcopy %REPUMA%\user.cmd %REPSAV%\ %NULFILE%
  if errorlevel 1 goto erreur
:suite7

rem * Copie les fichiers dans le rpertoire UMAGENT.
echo Copying files to directory %REPUMA% ...

xcopy *.EXE    %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy *.CMD     %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy *.INI   %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy DESINST*.BAT   %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy UMA_REF      %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy UMAPARAM   %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy UMAPARAM.TXT   %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy MIB.TBL      %REPUMA%\ %NULFILE%
if errorlevel 1 goto erreur

rem * Deplacement de DPI32DLL.DLL si necessaire
if not exist %DRIVE%\SVCA\DPI\DPI_1.1\DPI32DLL.DLL goto sReadme2
echo Copying file DPI32DLL.DLL
if exist %DRIVE%\SVCA\DLL\AGENT\DPI32DLL.DLL goto erreur
xcopy %DRIVE%\SVCA\DPI\DPI_1.1\DPI32DLL.DLL %DRIVE%\SVCA\DLL\AGENT\ %NULFILE%
if errorlevel 1 goto erreur

:sReadme2
rem * Copie les fichiers dans le rpertoire DEFAULT.
echo Copying files to directory %REPDEF% ...
xcopy *.INI   %REPDEF%\ %NULFILE%
if errorlevel 1 goto erreur
xcopy *.CFG  %REPDEF%\ %NULFILE%
if errorlevel 1 goto erreur
copy PROTMAX.CFG  %REPDEF%\DEFAULT.CFG %NULFILE%
if errorlevel 1 goto erreur


rem * Cration du fichier ETC\UMA_PATH
echo %UMPATH%\UMAGENT>%DRIVE%\ETC\UMA_PATH

rem * Cration du fichier UMA.CMD
rem * ---------------------------
echo @echo off > %REPUMA%\UMA.CMD
echo set UMA_RST= >> %REPUMA%\UMA.CMD
echo if exist %UMPATH%\UMAGENT\INIT.CFG del %UMPATH%\UMAGENT\INIT.CFG >> %REPUMA%\UMA.CMD
echo if exist %UMPATH%\UMAGENT\UMAEX.EXE goto debut >> %REPUMA%\UMA.CMD
echo echo  >> %REPUMA%\UMA.CMD
echo echo Error : cannot run from this disk. >> %REPUMA%\UMA.CMD
echo echo Set UM-Agent disk as current disk. >> %REPUMA%\UMA.CMD
echo goto fin >> %REPUMA%\UMA.CMD
echo :restart >> %REPUMA%\UMA.CMD
echo set UMA_RST=-i >> %REPUMA%\UMA.CMD
echo :debut >> %REPUMA%\UMA.CMD
echo cls >> %REPUMA%\UMA.CMD
echo echo. >> %REPUMA%\UMA.CMD
echo echo. >> %REPUMA%\UMA.CMD
echo %UMPATH%\UMAGENT\UMAEX %%1 %%2 %%3 %%UMA_RST%%>> %REPUMA%\UMA.CMD
echo if errorlevel 99 goto fin >> %REPUMA%\UMA.CMD
echo if errorlevel 9 goto fin >> %REPUMA%\UMA.CMD
echo if errorlevel 8 goto restart >> %REPUMA%\UMA.CMD
echo if errorlevel 7 goto restart >> %REPUMA%\UMA.CMD
echo :fin >> %REPUMA%\UMA.CMD
echo if exist %UMPATH%\UMAGENT\PID.TMP del %UMPATH%\UMAGENT\PID.TMP >> %REPUMA%\UMA.CMD
echo set UMA_RST= >> %REPUMA%\UMA.CMD

rem * Installation du dmarrage automatique de UM-Agent
rem * -------------------------------------------------
echo Modifying %DRIVE%\STARTUP.CMD for automatic startup...
if exist %DRIVE%\STARTUP.CMD goto modify
echo File could not be found, automatic startup not installed.
goto complete

:modify
copy %DRIVE%\STARTUP.CMD %DRIVE%\STARTUP.UMA >nul
copy %DRIVE%\STARTUP.CMD %DRIVE%\STARTUP.$UM >nul
if not exist %DRIVE%\STARTUP.UMA goto coperr
if not exist %DRIVE%\STARTUP.$UM goto coperr
echo (Original STARTUP.CMD as been saved to STARTUP.UMA)
rech_lig.exe %DRIVE%\STARTUP.$UM \UMA.CMD %UMAT%

echo START /B /MIN %UMPATH%\UMAGENT\UMA.CMD -s>%DRIVE%\STARTUP.CMD
copy %DRIVE%\STARTUP.CMD+%DRIVE%\STARTUP.$UM %DRIVE%\STARTUP.CMD >nul
erase %DRIVE%\STARTUP.$UM

rem  * Fin de l'installation
:complete
rem  * Installation de l'UM-Editor
if not exist ..\..\WIN\EDITOR\INSTALL.BAT goto fin
cd ..\..\WIN\EDITOR
call INSTALL.BAT %DRIVE% %UMPATH%
cd ..\..\OS2\AGENT
echo.
echo.
echo UM-AGENT installation procedure completed.
echo Please make sure that the SNMP Agent is correctly configured.
echo You must now run the UM-Agent configuration utility.
echo.
goto fin

rem * Pas de repertoire temporaire
:notmp
  echo.
  echo 
  echo No temporary directory was found.
  echo Set TEMP environment variable with the name of a
  echo temporary working directory (ex : SET TEMP=C:\TMP).
  goto abort

rem * Erreur ou abandon
:erreur
  echo.
  echo 
  echo Installation error,

:abort
  echo Installation procedure aborted.
  goto fin

rem * Fin des traitements
:fin
  if not "%UMAT%"=="" if exist %UMAT%\getvar.exe erase %UMAT%\getvar.exe >nul
  if not "%UMAT%"=="" if exist %UMAT%\setenv.bat erase %UMAT%\setenv.bat >nul
  set UMAT=
  set DEST=
  set REPUMA=
  set REPDEF=
  set REPSAV=
  set DRIVE=
  set UMPATH=
  set NULFILE=
  set REPONS=
  set BFNAME=
  set BFEXT=

  echo.
  echo.
  pause


