/*
 *      README.CMD
 */

 SIGNAL ON HALT;

 /* load utils */
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;

 /* setup default values */
 ValidLanguages       = 'ENG GER';
 DefaultLanguage      = 'ENG';
 Ini.FileName         = GetCallDir()'\sendyes.ini';
 Ini.AppName          = "SendYes!";
 Ini.KeyName_Language = "Language";

 ARG ParmLanguage .
 IF (ParmLanguage \= '') THEN
 DO
    /* is laguage valid */
    IF (WORDPOS(ParmLanguage, ValidLanguages) = 0) THEN
    DO
       SAY ParmLanguage': 'SysGetMessage(87, );
       EXIT(87);
    END;
    ELSE
       SelectedLanguage = ParmLanguage;
 END
 ELSE
 DO
    /* read selected language */
    SelectedLanguage = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_Language);
    IF (SelectedLanguage = 'ERROR:') THEN
       SelectedLanguage = DefaultLanguage;
    ELSE
       SelectedLanguage =  LEFT(SelectedLanguage, 3);
 END;

 /* is inf file there ? */
 InfFile = 'SNDYS'SelectedLanguage'.INF';
 SAY InfFile;
 IF (\FileExist(InfFile)) THEN
 DO
    SAY SysGetMessage(2, );
    EXIT(2);
 END;

 /* now start up the inf file */
 '@START VIEW' InfFile '"'Ini.AppName '*"'

 EXIT(rc);

HALT:
 SAY 'Ctrl-Break';
 EXIT(99);
/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');
  
