/*
 *      INSTALL.CMD SendYes V2.0 - C.Langanke 1996 - Installation
 *
 *      Syntax: INSTALL.CMD [/TARGETDIR:...]
 *                          [/LOCATION:"<...>"] [/BATCH]
 *                          [/?]
 *
 *      Creates a WPS folder and program objects for the SendYes! package. 
 *      Optionally copies files of SendYes! package to a target directory before.
 *
 *      /TARGETDIR:...     -  name of target directory where files are to be
 *                            copied to before installation of WPS objects
 *                            All files must be unzipped before invoking INSTALL !!!
 *                            If /TARGETDIR is not specified, no copy is performed!
 *      /LOCATION:"<...>"  -  WPS-ID: Location for the SendYes! folder 
 *                            [Default: "<WP_DESKTOP>"]
 *      /BATCH             -  don't use menus and prompts: just install with defaults
 *      /?                 -  display this help text
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info
 NewLine   = D2C(13)||D2C(10);
 env       = 'OS2ENVIRONMENT';
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
 Redirection = '1>NUL 2>&1';
 '@ECHO OFF'
  
 /* some OS/2 Error codes */
 ERROR.NO_ERROR          =  0;
 ERROR.ACCESS_DENIED     =  5;
 ERROR.NOT_ENOUGH_MEMORY =  8;
 ERROR.INVALID_DATA      = 13;
 ERROR.NO_MORE_FILES     = 18;
 ERROR.GEN_FAILURE       = 31;
 ERROR.INVALID_PARAMETER = 87;

 /* some default values */
 NlsMsg.HaltMsg      = 'Interrupted by user.';
 NlsMsg.AbortProgram = 'Program aborted.';
 NlsMsg.Error        =  'error';
 NlsMsg.Keys         = 'YN';
 Overview            = 'SendYes! *';
 Choice = 0;

 /* defaults */
 Default.PromptLen   = 60;
 Default.Location     = "<WP_DESKTOP>";
 Default.Language     = "english";
 Default.LanguageAbrv = 'ENG';

 /* flags */
 Flag.Batch        = FALSE;
 Flag.InvalidParm  = FALSE;
 Value.InvalidParm = '';
 Flag.ReadonlyMode = FALSE;

 /* defaults for selection by parms */
 Selected.TargetDir = '';
 Selected.Location  = Default.Location;
 Selected.Language  = '';

 /* determine directories */
 InstallDir       = GetCallDir();
 LastSlash        = LASTPOS( '\', InstallDir);
 ProgDir          = TRANSLATE(LEFT(InstallDir, LastSlash - 1));

 /* NLS file name definitions */
 NLSFileBaseName       = 'SNDYS';

 /* INI file definitions */
 Ini.Error             = 'ERROR:';
 Ini.Delete            = 'DELETE:';
 Ini.FileName          = ProgDir'\SENDYES.INI';
 Ini.AppName           = 'SendYes!';
 Ini.KeyName_Language  = 'Language';
 Ini.KeyName_TestWrite = 'TestWrite';
 Ini.KeyName_CallDir   = 'CallDir';

 SyslevelFile         = ProgDir'\SYSLEVEL.SNY';

 /* load RexxUtil */ 
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;
  
 /* show help */
 ARG Parms
 IF (POS('?', Parms) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.NO_ERROR)
 END;


 /* look for all messagefiles in directory */
 /* to determine the languages available   */
 rc = GetLanguages(InstallDir'\'NLSFileBaseName'*.MSG', ProgDir'\'NLSFileBaseName);
 IF (rc \= ERROR.NO_ERROR) THEN
 DO
    SAY;
    SAY CmdName':' NlsMsg.Error': No valid SendYes! language install message file found.'; 
    SAY NlsMsg.AbortProgram;
    EXIT(ERROR.GEN_FAILURE);
 END;

 IF (Language.0 = 0) THEN
 DO
    SAY;
    SAY CmdName':' NlsMsg.Error': No complete SendYes! NLS component available.';
    SAY NlsMsg.AbortProgram;
    EXIT(ERROR.GEN_FAILURE);
 END;

 /* read commandline parms */ 
 PARSE ARG Parms

 DO i = 1 TO WORDS(Parms);
    ThisParm = WORD(Parms, i);
    PARSE VAR ThisParm ThisTag':'ThisValue
    ThisTag = TRANSLATE(ThisTag);

    SELECT
       WHEN (POS(ThisTag, '/TARGETDIR') = 1) THEN
       DO
          /* ### longnames with embedded blanks      */
          /* and/or in quotes are not supported here */
          Selected.TargetDir = ThisValue;
       END;

       WHEN (POS(ThisTag, '/LOCATION') = 1) THEN
       DO
          ThisValue = STRIP(ThisValue);
          IF (LEFT(ThisValue, 1) = '"') THEN
             PARSE VAR ThisValue '"'ThisValue'"'
          Selected.Location = ThisValue;
       END;

       WHEN (POS(ThisTag, '/BATCH') = 1) THEN
       DO
          Flag.Batch = TRUE;
       END;

       OTHERWISE
       DO
          Flag.InvalidParm = TRUE;
          Value.InvalidParm = ThisParm;
       END;

    END; /* SELECT */
 END; /* DO */

 /* use language specified in INI file if not specified within parameters */ 
 Selected.Language = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_Language);
 IF (Selected.Language \= Ini.Error) THEN
 DO
    Selected.Language = LEFT(Selected.Language, 3);
    Choice = WORDPOS(Selected.Language, Language.ListAbrv);
    Selected.Language = Language.Choice;
 END;
 ELSE
    Choice = 0;

 /* preselect language */
 IF (Choice = 0) THEN
    Choice = 'UNSELECTED'; 

 /* test if ini can be written */
 rc = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_Testwrite, Ini.KeyName_Testwrite||'00'x);
 IF (rc = Ini.Error) THEN
 DO
    /* use global ini file in OS2 directory instead */
    UserIni      = VALUE('USER_INI',,env);
    LastSlash    = LASTPOS('\',UserIni);
    Ini.FileName = LEFT( UserIni, LastSlash - 1)'\SENDYES.INI';

    /* give warning message */
    'CLS'
    SAY;
    SAY CmdName': Warning:';
    SAY;
    SAY 'SENDYES.INI in directory' ProgDir 'cannot be written.';
    SAY;
    SAY 'Settings will be written to' Ini.FileName;
    SAY 'when SendYes! is called from directory' ProgDir'.';
    SAY;
    SAY 'Press any key to continue ...';
    'PAUSE' Redirection

    /* save program dir */
    rc = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_CallDir, ProgDir||'00'x);
 END;
 ELSE
    /* delete test enry */
    rc = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_Testwrite, Ini.Delete);


SelectLanguage:
 Language.MenuKeys = LEFT('123456789ABCDEF', Language.0);

 IF (Choice = 'UNSELECTED') THEN
 DO
    DROP(Menu.);
    Menu.ValidMenuKeys = Language.MenuKeys;
    Menu.Line.0 = 4 + Language.0;
    Menu.Line.1 = '';
    Menu.Line.2 = Title
    Menu.Line.3 = '';
    Menu.Line.4 = '';
    DO i = 1 TO Language.0
       ThisLine = 4 + i;
       Menu.Line.ThisLine = '   'SUBSTR(Menu.ValidMenuKeys, i, 1)'.  'Language.i;
    END;
    Choice = Menu(WORDPOS(Default.Language, Language.List));
 END;
 Choice = POS(Choice, Language.MenuKeys);

 /* select NLS settings */
 MessageFile           = InstallDir'\'NLSFileBaseName''Language.Choice.Abrv'.MSG';
 InfFileName           = NLSFileBaseName''Language.Choice.Abrv'.INF'; 
 InfFile               = ProgDir'\'InfFileName;
 HlpFileName           = NLSFileBaseName''Language.Choice.Abrv'.HLP'; 
 HlpFile               = ProgDir'\'HlpFileName;
 Selected.LabguageAbrv = Language.Choice.Abrv;

 /* load messages and object strings */
 rc = LoadMessageFile(MessageFile, FALSE);
 ExitKey = RIGHT(NlsMsg.Keys, 1);

/*
 *      validate parms
 */

 IF (Flag.InvalidParm) THEN
 DO
    SAY;
    SAY Title
    SAY;
    SAY CmdName':' NlsMsg.Error':' NlsMsg.InvalidParm ''Value.InvalidParm'.';
    SAY NlsMsg.AbortProgram;
    EXIT(ERROR.INVALID_PARAMAMETER);
 END;
 
 IF (\ObjectExist(Selected.Location)) THEN
 DO
    SAY;
    SAY Title
    SAY;
    SAY CmdName':' NlsMsg.Error':' NlsMsg.NotExist':' Selected.Location
    SAY NlsMsg.AbortProgram;
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* if target directory is specified, do a xcopy and call       */
 /*  this batch again within the target directory structure     */
 IF (Selected.TargetDir \= '' ) THEN
 DO
    IF (\Flag.Batch) THEN
       IF (\ProceedWith(NlsMsg.InstallPrompt Selected.TargetDir)) THEN
          SIGNAL HALT;
    SAY NlsMsg.TargetDirInstall Selected.TargetDir
    IF (FileExist(Selected.TargetDir)) THEN
    DO
       IF (Flag.Batch) THEN
       DO
          SAY;
          SAY Title
          SAY;
       END;
       SAY; 
       SAY NlsMsg.TargetDirExists
       SAY NlsMsg.AbortProgram
       EXIT(ERROR.ACCESS_DENIED);
    END;
    'XCOPY "'ProgDir'\*.*"  "'Selected.TargetDir'\" /S /E /T /H' Redirection
    IF (rc \= ERROR.NO_ERROR) THEN
    DO
       IF (Flag.Batch) THEN
       DO
          SAY;
          SAY Title
          SAY;
       END;
       SAY; 
       SAY NlsMsg.XcopyFailed
       SAY NlsMsg.AbortProgram
       EXIT(ERROR.ACCESS_DENIED);
    END;
    rc = DIRECTORY(Selected.TargetDir);
    
    CallParms = '/LOCATION:"'Selected.Location'"'
    IF (Flag.Batch) THEN CallParms = CallParms '/BATCH';
    'CALL "'Selected.TargetDir'\INSTALL\INSTALL.CMD"' CallParms 
    EXIT(ERROR.NO_ERROR);
 END;

 /* select installation, readme or language select */
 DROP(Menu.);
 Menu.ValidMenuKeys = '123'ExitKey;
 Menu.Line.0  = 9;
 Menu.Line.1  = '';
 Menu.Line.2  = Title;
 Menu.Line.3  = '';
 Menu.Line.4  = '';
 Menu.Line.5  = '   ' NlsMsg.Readme
 Menu.Line.6  = '   ' NlsMsg.Install
 Menu.Line.7  = '   ' NlsMsg.NLSSelect
 Menu.Line.8  = '';
 Menu.Line.9  = '   ' NlsMsg.Exit

 DO WHILE (TRUE)

    /* just install within batch mode */
    IF (Flag.Batch) THEN
    DO
       DO i = 1 TO 3
          Say Menu.Line.i;
       END;
       LEAVE;
    END;

    Choice = Menu(1);
    SELECT
       WHEN (Choice = '1') THEN 
       DO
          'START VIEW' InfFile Overview
          rc = SysSleep(3);
       END;

       WHEN (Choice = '2') THEN LEAVE;

       WHEN (Choice = '3') THEN 
       DO
          Choice = 'UNSELECTED';
          SIGNAL SelectLanguage;
       END;

       WHEN (Choice = ExitKey) THEN SIGNAL HALT;
       OTHERWISE NOP;
    END /* SELECT */
 END; /* WHILE (TRUE) */

 /* store selected language in INI and syslevel file */
 rc = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_Language, Selected.LabguageAbrv||'00'x);
 rc = SetSyslevelLanguage(SyslevelFile, Selected.LabguageAbrv);

 /* Now create all objects defined */
 DO i = 1 TO Objects.0
    /* parse object details */
    PARSE VAR Objects.i,
           '"'ObjectClass'"',
           '"'ObjectLocation'"',
           '"'ObjectId'"',
           '"'ObjectTitle'"',
           '"'ObjectOption'"',
           '"'ObjectExeName'"',
           '"'ObjectParameters'"',
           '"'ObjectSetup'"'

    /* use selected location */
    IF (ObjectLocation = Default.Location) THEN
       ObjectLocation = Selected.Location;

    /* make insertions to setup string */
    IF ((ObjectExeName \= '') | (ObjectParameters \= '')) THEN
    DO
       /* add path to Exename, if neccessary */
       IF ((ObjectExename \= '*') & (FileExist(ProgDir'\'ObjectExename))) THEN
          ObjectExeName = ProgDir'\'ObjectExeName;

       /* append rest of setup */
       ObjectSetup =,
                   'EXENAME='ObjectExeName';'||,
                   'PARAMETERS='ObjectParameters';'||,
                   ObjectSetup;
    END;

    /* SetupString: replace '@1' with program directory */
    ObjectSetup = TranslateString(ObjectSetup, ProgDir, '@1');

    /* SetupString: replace '@2' with inf filename */
    ObjectSetup = TranslateString(ObjectSetup, InfFile, '@2');

    /* SetupString: replace '@3' with hlp filename */
    ObjectSetup = TranslateString(ObjectSetup, HlpFile, '@3');

    /* create object */
    rc = CreateObject(ObjectTitle, ObjectClass, ObjectLocation,,
                      'OBJECTID='ObjectId';'||,
                      ObjectSetup, ObjectOption);
 END;

 /* show the folder (open twice is ok, ccview=no is set !) */
 rc = SysSetObjectData('<SENDYES_FOLDER>', 'OPEN=DEFAULT;');
 rc = SysSetObjectData('<SENDYES_FOLDER>', 'OPEN=DEFAULT;');

 /* success message */
 SAY;
 SAY NlsMsg.InstallEnded;

 EXIT(ERROR.NO_ERROR);

/* ------------------------------------------------------------------------- */

HALT:
  SAY NlsMsg.HaltMsg;
  EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE ExitMessage Title

 SAY;
 SAY Title
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 DO WHILE (ThisLine \= ' */')
    ThisLine = LINEIN(Thisfile);
    SAY SUBSTR(ThisLine, 7);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
CreateObject: PROCEDURE EXPOSE NlsMsg. Default. ExitMessage
 PARSE ARG Title, Class, Location, Setup, Option

 CALL CHAROUT, LEFT(NlsMsg.Create Title '...', Default.PromptLen)

 rc = SysCreateObject(Class, Title, Location, Setup, Option);

 IF (rc) THEN
    SAY NlsMsg.Ok
 ELSE
    SAY NlsMsg.Error '!'

 RETURN(rc);

/* ------------------------------------------------------------------------- */
PullVariable: PROCEDURE EXPOSE ExitMessage
 PARSE ARG Default, Message

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE EXPOSE ExitMessage
 ARG MsgId, MessageFile

 Message = SysGetMessage(MsgId, MessageFile);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE EXPOSE ExitMessage
 ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');
   
/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE EXPOSE ExitMessage
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE EXPOSE ExitMessage
 ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');

/* ------------------------------------------------------------------------- */
PullVariable: PROCEDURE EXPOSE ExitMessage
 PARSE ARG Default, Message

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 PARSE PULL PullVar;
 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
TranslateString: PROCEDURE EXPOSE ExitMessage
 PARSE ARG String, ReplaceString, SearchString

 TagPos   = POS(SearchString, String);
 TagLen   = LENGTH(SearchString);
 
 IF (TagPos > 0) THEN
 DO
    NewString  = '';
    LastTagPos = 1 - TagLen;
    DO WHILE (TagPos > 0)
       NewString  = NewString''SUBSTR(String, LastTagPos + TagLen, TagPos - LastTagPos - TagLen, )''ReplaceString;
       LastTagPos = TagPos;
       TagPos     = POS(SearchString, String, TagPos + TagLen);
    END;
    NewString     = NewString''SUBSTR(String, LastTagPos + TagLen);
    RETURN(NewString);
 END;
 ELSE
    RETURN(String);
 
/* ========================================================================= */
ObjectExist: PROCEDURE EXPOSE ExitMessage
 ARG ObjectId

 RETURN(SysSetObjectData(ObjectId, ';'));
   
/* ========================================================================= */
ProceedWith: PROCEDURE EXPOSE NlsMsg. ExitMessage
 PARSE ARG Prompt

 ch            = ' ';
 ValidResponse = LEFT(NlsMsg.Keys, 2);
 YesKey        = LEFT(ValidResponse, 1);
 NoKey         = RIGHT(ValidResponse, 1);

 SAY;
 CALL CHAROUT ,Prompt '('YesKey'/'NoKey') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    PULL ch
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY;
 SAY;
 RETURN(ch = YesKey);
   
/* ========================================================================= */
Menu: PROCEDURE EXPOSE Menu. TRUE FALSE ExitMessage
ARG Default

 IF (Default = '') THEN
    Default = LEFT(Menu.ValidMenuKeys, 1);

 Choice = '';
 ChoiceOk = FALSE;
 DO WHILE (\ChoiceOk)
    rc = SysCls();
    DO i = 1 TO Menu.Line.0
       SAY Menu.Line.i
    END;

    Choice   = TRANSLATE(PullVariable(Default , '   ?  '));
    ChoiceOk = (POS(Choice, Menu.ValidMenuKeys) > 0);
    IF (\ChoiceOk) THEN
       CALL CHAROUT, '';
 END;
 SAY;

 RETURN(Choice);

/* ========================================================================= */
LoadMessageFile: PROCEDURE EXPOSE ERROR. NlsMsg. Objects. ExitMessage,
                                  InstLanguage InstLanguageAbrv 

 ARG MessageFile, ReadInfoOnly

 /* default values */
 MessageFileIdText = 'SENDYES_MESSAGEFILE';
 DROP(Objects.);
 Objects.  = '';
 Objects.0 = 0;

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId InstMsgStart InstObjectsStart InstObjectsEnd NlsMsg.Keys InstLanguage InstLanguageAbrv
 IF (MessageFileIdText \= MessageFileId) THEN
    RETURN(ERROR.INVALID_DATA);

 IF (\ReadInfoOnly) THEN
 DO
    /* load message strings */
    NlsMsg.AbortProgram     = LoadMsgString(InstMsgStart +  0, MessageFile);
    NlsMsg.AlreadyActive    = LoadMsgString(InstMsgStart +  1, MessageFile); /**/
    NlsMsg.HaltMsg          = LoadMsgString(InstMsgStart +  2, MessageFile);
    NlsMsg.Readme           = LoadMsgString(InstMsgStart +  3, MessageFile);
    NlsMsg.Install          = LoadMsgString(InstMsgStart +  4, MessageFile);
    NlsMsg.NLSSelect        = LoadMsgString(InstMsgStart +  5, MessageFile);
    NlsMsg.Exit             = LoadMsgString(InstMsgStart +  6, MessageFile);
    NlsMsg.Ok               = LoadMsgString(InstMsgStart +  7, MessageFile);
    NlsMsg.Error            = LoadMsgString(InstMsgStart +  8, MessageFile);
    NlsMsg.InstallPrompt    = LoadMsgString(InstMsgStart +  9, MessageFile)
    NlsMsg.TargetDirInstall = LoadMsgString(InstMsgStart + 10, MessageFile);
    NlsMsg.TargetDirExists  = LoadMsgString(InstMsgStart + 11, MessageFile);
    NlsMsg.InvalidParm      = LoadMsgString(InstMsgStart + 12, MessageFile);
    NlsMsg.NotExist         = LoadMsgString(InstMsgStart + 13, MessageFile);
    NlsMsg.XcopyFailed      = LoadMsgString(InstMsgStart + 14, MessageFile);
    NlsMsg.DeactivatePrompt = LoadMsgString(InstMsgStart + 15, MessageFile); /**/
    NlsMsg.Deactivated      = LoadMsgString(InstMsgStart + 16, MessageFile); /**/
    NlsMsg.Create           = LoadMsgString(InstMsgStart + 17, MessageFile);
    NlsMsg.Delete           = LoadMsgString(InstMsgStart + 18, MessageFile);
    NlsMsg.Deinstall        = LoadMsgString(InstMsgStart + 19, MessageFile);
    NlsMsg.NotInstalled     = LoadMsgString(InstMsgStart + 20, MessageFile);
    NlsMsg.InstallEnded     = LoadMsgString(InstMsgStart + 21, MessageFile);
    NlsMsg.DeInstallEnded   = LoadMsgString(InstMsgStart + 22, MessageFile);
   
    /* load object strings */
    DO i = InstObjectsStart TO InstObjectsEnd
       n         = Objects.0 + 1;
       Objects.n = LoadMsgString(i, MessageFile);
       Objects.0 = n;
    END;

 END; /* IF (\ReadInfoOnly) */

 RETURN(ERROR.NO_ERROR);

/* ========================================================================= */
GetLanguages: PROCEDURE EXPOSE ERROR. TRUE FALSE Language.
 ARG FileName, NlsBaseName
 
 /* initialize output stem */
 Language.  = '';
 Language.0 = 0;


 Options  = 'OFS';
 rc = SysFileTree(FileName, 'File.', Options);
 IF (rc \= ERROR.NO_ERROR) THEN
    RETURN(ERROR.NOT_ENOUGH_MEMORY);

 IF (File.0 = 0) THEN
    RETURN(ERROR.NO_MORE_FILES);

 DO i = 1 TO File.0
    /* load only first message out of the file*/
    rc = LoadMessageFile(File.i, TRUE);
    IF (rc = ERROR.NO_ERROR) THEN
    DO
       /* check if resource dll, hlp and inf file exist*/
       LanguageBaseName = NlsBaseName''InstLanguageAbrv;
       InfFile          = LanguageBaseName'.INF';
       HlpFile          = LanguageBaseName'.HLP';
       ResFile          = LanguageBaseName'.DLL';
       IF ((FileExist(InfFile)) &,
           (FileExist(HlpFile)) &,
           (FileExist(ResFile))) THEN
       DO
          /* load language identifier and abbreviation into language stem  */
          n                 = Language.0 + 1;
          Language.n        = InstLanguage 
          Language.n.Abrv   = InstLanguageAbrv;
          Language.0        = n;
          Language.List     = Language.List InstLanguage;
          Language.ListAbrv = Language.ListAbrv InstLanguageAbrv;
       END;
    END;
 END;

 RETURN(ERROR.NO_ERROR);

/* ========================================================================= */
SetSyslevelLanguage: PROCEDURE EXPOSE ERROR. TRUE FALSE CmdName Language.
 ARG SyslevelFile, LanguageAbrv
 
 /* patch SendYes! SYSLEVEL file */
 IF (\FileExist(Syslevelfile)) THEN
    RETURN('');
 ELSE
 DO

    /* read in CSD level tags */
    CurrLevel = CHARIN(Syslevelfile, 45, 8);
    PrevLevel = CHARIN(Syslevelfile, 53, 8);

    Id1 = SUBSTR(CurrLevel, 1, 3);
    Id2 = SUBSTR(PrevLevel, 1, 3);
    CurrId = RIGHT(Id1, 1);

    IF ((Id1 \= Id2) | (POS(CurrId, '0CDFGHIJLNPSUW') = 0)) THEN
       RETURN('');
    ELSE
    DO
       /* select new language ID */
       SELECT
          WHEN (LanguageAbrv = 'GER') THEN NewId = 'G';
          WHEN (LanguageAbrv = 'ENG') THEN NewId = '0';

          OTHERWISE                    NewId = '0';
       END;
       /* patch in new id and cose file */
       CurrId  = CHAROUT(Syslevelfile, NewId, 47);
       CurrId  = CHAROUT(Syslevelfile, NewId, 55);
       rc = LINEOUT(Syslevelfile);
    END;
 END;
 RETURN('');

