#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int patchINF(char *fn)
{
    int fh;
    long nlsstart;		/* 32 bit file offset of NLS table */
    long nlslen;		/* size of NLS table */
    long pos;			/* position in file */
    
    struct			/* subset of FONTMETRICS */
    {
	char fontname[31];	/* szFacename[31] */
	int foo1;		/* unknown - probably registry identifier */
	int height;		/* lXHeight */
	int width;		/* lAveCharWidth */
	int cPage;		/* code Page */
    } fontinfo;
        
    fh=open(fn,O_RDWR | O_BINARY);
    lseek(fh, 0x53, SEEK_SET);	/* offset of nlsstart in .INF header */
    read(fh, &nlsstart, 4);
    read(fh, &nlslen, 4);
    pos = nlsstart+nlslen;
    lseek(fh, pos, SEEK_SET);   /* seeking to end of NLS table */
    read(fh, &fontinfo, sizeof(fontinfo));
    /* sometimes links to other .INF files come after the NLS-table */
    /* format is: 1-byte lenght of Filename to be linked            */
    /*            filename (_not_ null-terminated                   */
    /* so if we meet an unprintable character here we expect this   */
    while (fontinfo.fontname[0]<=0x1a)/* read over one link-filename */
    {
	pos += fontinfo.fontname[0];
	lseek(fh, pos, SEEK_SET);
	read(fh, &fontinfo, fontinfo.fontname[0]);
    }
    /* now we should have the first real fontinfo - usually System Proportional (default size) */
    while (1)
    {
	lseek(fh, pos, SEEK_SET);
	read(fh, &fontinfo, sizeof(fontinfo));
	if ((!(strcmp(fontinfo.fontname, "System Proportional")) ||
	     !(strcmp(fontinfo.fontname, "Helv")) ||
	     !(strcmp(fontinfo.fontname, "System VIO")) ||
	     !(strcmp(fontinfo.fontname, "System Monospaced")) ||
	     !(strcmp(fontinfo.fontname, "Tms Rmn"))))
	    printf("found font: %s (%ux%u) - no change\n", fontinfo.fontname, fontinfo.height, fontinfo.width);
	else
	    if (!(strcmp(fontinfo.fontname, "Courier")))
	    {
        printf("found font: %s (%ux%u) - changing to System Vio 9x6 (4pt)\n", fontinfo.fontname,
		       fontinfo.height, fontinfo.width);
		strcpy(fontinfo.fontname, "System VIO");
        fontinfo.height=0x09;	/*  */
        fontinfo.width=0x06;
		lseek(fh, pos, SEEK_SET);
		write(fh, &fontinfo, sizeof(fontinfo));
	    }
	    else
	    {
		printf("no more fontinfos found - exiting\n");
		close(fh);
		return (0);
	    }
	pos += sizeof(fontinfo);
    }
}
    

int main (int argc, char *argv[], char *envp[])
{
    printf("SmallInf v.0.5 - 1994 by albe.\n");
    if (argc==2)
	PatchINF(argv[1]);
    else
    {
	printf("usage: SmallInf Filename\n");
	printf("changes every Courier Font in an INF-File to System VIO 9x6\n");
    }
    return(0);
}
