/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : CTYINF.C
**  Author   : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**  Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 13 Jul 1992 
**  Updated  : 21 Sep 1993
**  Version  : 3.22
**  Content  : Sample program for FMZNLFUN.DLL functions
**
*/
 #define EXTERN

 #include <ctyinf.h>
 #include <zzzlogo.h>

/* ------------------------------------------------------------------------ */

/*
**  Presentation Manager Program Main Body
**
**  The following routine is the Presentation Manager program Main Body.
**  The Main Body of a PM program is concerned with associating the
**  application with the Presentation Manager system, creating its
**  message queue, registering and displaying its main window, servicing
**  its message queue during the time that the application is active,
**  and disassociating the application from PM when the user is finished
**  with the application. The remaining parts of this source module that
**  are concerned with the Presentation Manager are the application's
**  window procedures (main window procedure, child window procedures,
**  and dialog window procedures) that process the messages associated
**  with the application's various windows.
**
*/
 int main(int argc, char *argv[])
{
   QMSG qmsg ; // MSG structure to store your messages
   PID  pid ; // Process identifier for adding name to switch list
   TID  tid ; // Thread identifier

   static CHAR szTitle[20] ;

   argc = argc ; // Suppress compiler warning - can remove if argc and argv
   argv = argv ; // are referenced by user-supplied code.

  /*
  **  The WinInitialize routine initializes the Presentation Manager
  **  facilities for use by this application and returns a handle to the
  **  anchor block assigned to the application by PM.
  */
   if ((hAB = WinInitialize(0)) == 0) return(FALSE) ;

  /*
  **  The WinCreateMsgQueue call creates a message queue for this application
  */
   if ((hMQ = WinCreateMsgQueue(hAB, 0)) == 0) return(FALSE) ;

  /*
  **  The following function registers the classes of all application windows
  */
   if (!cwRegisterClass()) return(FALSE) ;

  /*
  **  Content : Initialize country
  */
   if (!znlInitCtryInfo(&Country)) return(FALSE) ;

  /*
  **  The CreateWindow function creates a frame window for this application's
  **  top window, and set the window's size and location as appropriate.
  */
   WinLoadString(hAB, 0, IDS_TITLE, 20, szTitle) ;
   hWndFrame = cwCreateWindow((HWND)HWND_DESKTOP,
                              FCF_TITLEBAR     |
                              FCF_SYSMENU      |
                              FCF_MINBUTTON    | 
                              FCF_MAXBUTTON    | 
                              FCF_SIZEBORDER   | 
                              FCF_MENU         |
                              FCF_ACCELTABLE   |
                              FCF_SHELLPOSITION,
                              szAppName,
                              szTitle,
                              ID_CTYINF, 
                              122, 117,  
                              162, 38,   
                              &hWndClient,
                              0L, SWP_SHOW) ;

   if (hWndFrame == 0) return(FALSE) ;

  /*
  **  The following inline routine fills out the application's switch control
  **  structure with the appropriate information to add the application's
  **  name to the OS/2 Task Manager List, a list of the jobs currently
  **  running on the computer.
  */
   WinQueryWindowProcess(hWndFrame, &pid, &tid) ;

   Swctl.hwnd = hWndFrame ;                         // Frame window handle
   Swctl.idProcess = pid ;                          // Process identifier
   Swctl.uchVisibility = SWL_VISIBLE ;              // visibility
   Swctl.fbJump = SWL_JUMPABLE ;                    // Jump indicator
   strcpy(Swctl.szSwtitle, szTitle) ;               // Frame window title
   hSwitch = WinAddSwitchEntry(&Swctl) ;

  /*
  **  The following is the message loop for the application.
  */
   while (WinGetMsg(hAB, (PQMSG)&qmsg, 0, 0, 0))
   {
     WinDispatchMsg(hAB,(PQMSG)&qmsg) ;
   }

  /*
  **  Perform clean up before exiting application.
  **  The following routine destroys the application's frame window (which
  **  also destroys its child windows), destroys its message queue, and
  **  disassociates the application from the Presentation Manager system.
  */
   WinDestroyWindow(hWndFrame) ; // Destroy the frame window
   WinDestroyMsgQueue(hMQ) ;     // Destroy this application's message queue
   WinTerminate(hAB) ;           // Terminate this application's use of the
                                 // Presentation Manager resources
   return (0) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Main Window Procedure
**
**  This procedure provides service routines for the general PM events
**  (messages) that PM sends to the window, as well as the user
**  initiated events (messages) that are generated when the user selects
**  the action bar and pulldown menu controls or the corresponding
**  keyboard accelerators.
**
**  The SWITCH statement shown below distributes the window messages to
**  the respective message service routines, which are set apart by the
**  CASE statements. The window procedures must provide an appropriate
**  service routine for its end user initiated messages, as well as the
**  general PM messages (like the WM_CLOSE message). If a message is
**  sent to this procedure for which there is no programmed CASE clause
**  (i.e., no service routine), the message is defaulted to the
**  WinDefWindowProc function, where it is disposed of by PM.
**
*/
 MRESULT EXPENTRY WndProc
 (
   HWND   hWnd    ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   HPS   hPS    ;   // Handle for the Presentation Space
   RECTL rClient ;   // Handle to rectangle formed by client area

   switch(message)
   {
     case WM_INITMENU :
          break ;

     case WM_MENUEND :
          break ;

    /*
    **  The PM messages for action bar and pulldown menu items are
    **  processed in this routine.
    */
     case WM_COMMAND :
     {
       switch(SHORT1FROMMP(mp1))
       {
         case IDM_S_GENERAL :
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "NTLINF". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)NTLINFMsgProc,
                          0, IDLG_NTLINF, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_S_DATE :
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "DTEFMT". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)DTEFMTMsgProc,
                          0, IDLG_DTEFMT, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_S_TIME :
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "TMEFMT". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)TMEFMTMsgProc,
                          0, IDLG_TMEFMT, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_S_NUMBERS :
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "NUMFMT". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)NUMFMTMsgProc,
                          0, IDLG_NUMFMT, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_S_CURRENCY :
         {
          /*
          **  The code below makes a call to the dialog box named
          **  "CURFMT". Variable rc will receive the
          **  return code sent when the dialog box is closed.
          */
           APIRET rc ;

           rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)CURFMTMsgProc,
                          0, IDLG_CURFMT, (PVOID)&hWnd) ;
         }
         break ;

         case IDM_S_ABOUT:
              #include "TSTABOUT.INC"
              break ;

         case IDM_S_EXIT:
              #include "TSTEXITW.INC"
              break ;

         default:
              break ; // End of default case for switch(mp1)
       }
     }
     break ; // End of WM_COMMAND

     case WM_CREATE :
     {
      /*
      ** The WM_CREATE message is sent to a window when an application
      ** requests that the window be created.  The window procedure
      ** for the new window receives this message after the window is
      ** created, but before the window becomes visible.
      **
      */
       cwSetInitDlgStatus(hWnd) ;
     }
     break ;

     case WM_MOUSEMOVE :
     {
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;

     case WM_SIZE :
     {
     }
     break ;

     case WM_PAINT:    // Code for the window's client area
     {
      /*
      **  Obtain a handle to a cache presentation space
      */
       hPS = WinBeginPaint(hWnd, 0, 0) ;

      /*
      **  Determine the size of the client area
      */
       WinQueryWindowRect(hWnd, &rClient) ;

      /*
      **  Fill the background with the default background color
      */
       WinFillRect(hPS, &rClient, CLR_BACKGROUND) ;

      /*
      **  Return presentation space to state before WinBeginPaint
      */
       WinEndPaint(hPS) ;
     }
     break ;

     case WM_CLOSE :
     {
       #include "TSTCLOSE.INC"

       if (hWnd != hWndClient) break ;
       cwFreeDlgMemory(hWnd) ;
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;

     case WM_TRANSLATEACCEL:
     {
       return(WinDefWindowProc(hWndClient, message, mp1, mp2)) ;
     }
     break ;

     default :
     {
      /*
      **  For any message for which you don't specifically provide a
      **  service routine, you should return the message to PM using
      **  the WinDefWindowProc function.
      */
       return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
     }
     break ;
   }
   return(0L) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY NTLINFMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   NTLINFStruct *Ntlinf ;
  
   switch(message)
   {
     case WM_INITDLG:
     {
       Ntlinf = (NTLINFStruct *)WinQueryWindowULong(hWndClient, OFFSET_NTLINF) ;

       hWndParent = *((HWND *)mp2) ;
       cwCenter(hWndDlg, (HWND)hWndParent) ;
  
      /* 
      **  Initialize entry field control: NtlInfCountry 
      **  It must be filled with the country name                        
      */
       WinSendDlgItemMsg(hWndDlg, NTLINFCTYFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
       if (Ntlinf->NtlInfCountry[0])
         WinSetDlgItemText(hWndDlg, NTLINFCTYFLD, Ntlinf->NtlInfCountry) ;
  
      /* 
      **  Initialize entry field control: NtlInfMeasurements             
      **  It must be filled with the measurement name                    
      */
       WinSendDlgItemMsg(hWndDlg, NTLINFMSRFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
       if (Ntlinf->NtlInfMeasurements[0])
         WinSetDlgItemText(hWndDlg, NTLINFMSRFLD, Ntlinf->NtlInfMeasurements) ;
  
      /* 
      **  Initialize entry field control: NtlInfListSeparator            
      **  It must be filled with the data separator symbol               
      */
       WinSendDlgItemMsg(hWndDlg, NTLINFSEPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(2), 0L) ;
       if (Ntlinf->NtlInfListSeparator[0])
         WinSetDlgItemText(hWndDlg, NTLINFSEPFLD, Ntlinf->NtlInfListSeparator) ;
  
       #include "TSTNTNL.INC"
     }
     break ; // End of WM_INITDLG
  
     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case NTLINFCTYFLD : // Entry field variable: "NtlInfCountry"   
         case NTLINFMSRFLD : // Entry field variable: "NtlInfMeasurements"
         case NTLINFSEPFLD : // Entry field variable: "NtlInfListSeparator" 
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code 
           {
             case EN_SETFOCUS :  // Entry field is receiving the focus 
                  break ;
  
             case EN_KILLFOCUS : // Entry field is losing the focus  
                 break ;
  
             default :           // Default other messages                     
                 return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                 break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL
     
     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"                                
         {
           Ntlinf = (NTLINFStruct *)WinQueryWindowULong(hWndClient, OFFSET_NTLINF) ;
           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;
       }
     } 
     break ; // End of WM_COMMAND   
  
     case WM_CLOSE:
     {
       WinDismissDlg(hWndDlg, FALSE) ;
     } 
     break ; // End of WM_CLOSE   
  
     case WM_FAILEDVALIDATE:
     {
       return((MRESULT)TRUE) ;
     } 
     break ; // End of WM_FAILEDVALIDATE   
  
     default:
     {
       return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
     } 
     break ;
   }

   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY DTEFMTMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   DTEFMTStruct *Dtefmt ;

   switch(message)
   {
     case WM_INITDLG:
     {
       Dtefmt = (DTEFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_DTEFMT) ;

       hWndParent = *((HWND *)mp2) ;
       cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      **  Initialize radio button control: DteFmtFormat                    
      */
       WinPostMsg(hWndDlg, WM_CONTROL,
                  MPFROMSHORT(Dtefmt->DteFmtFormat), 0L) ;

      /*
      **  Initialize entry field control: DteFmtSeparator                  
      */
       WinSendDlgItemMsg(hWndDlg, DTEFMTSEPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(2), 0L) ;
       if (Dtefmt->DteFmtSeparator[0])
          WinSetDlgItemText(hWndDlg, DTEFMTSEPFLD, Dtefmt->DteFmtSeparator) ;

       #include "TSTDATE.INC"
     }
     break ; // End of WM_INITDLG   

     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DTEFMTDMYRDB: // Radiobutton text: "Day Month Year"         
         case DTEFMTMDYRDB: // Radiobutton text: "Month Day Year"         
         case DTEFMTYMDRDB: // Radiobutton text: "Year Month Day"         
         {
           // Read only   
         }
         break ;

         case DTEFMTSEPFLD: // Entry field variable: "DteFmtSeparator"    
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code    
           {
             case EN_SETFOCUS :  // Entry field is receiving the focus   
                  break ;

             case EN_KILLFOCUS : // Entry field is losing the focus    
                  break ;

             default :           // Default other messages                       
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL   

     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"                                
         {
           Dtefmt = (DTEFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_DTEFMT) ;

          /*
          ** Query radio buttons for current state, if set then        
          ** set the dialog structure variable to the control ID      
          */
           if (WinSendDlgItemMsg(hWndDlg, DTEFMTDMYRDB, BM_QUERYCHECK, 0L, 0L ))
             Dtefmt->DteFmtFormat = DTEFMTDMYRDB ;

           if (WinSendDlgItemMsg(hWndDlg, DTEFMTMDYRDB, BM_QUERYCHECK, 0L, 0L ))
             Dtefmt->DteFmtFormat = DTEFMTMDYRDB ;

           if (WinSendDlgItemMsg(hWndDlg, DTEFMTYMDRDB, BM_QUERYCHECK, 0L, 0L ))
             Dtefmt->DteFmtFormat = DTEFMTYMDRDB ;

           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;
       }
     }
     break ; // End of WM_COMMAND   

     case WM_CLOSE:
     {
       WinDismissDlg(hWndDlg, FALSE) ;
     }
     break ; // End of WM_CLOSE   

     case WM_FAILEDVALIDATE:
     {
       return((MRESULT)TRUE) ;
     }
     break ; // End of WM_FAILEDVALIDATE   

     default:
     {
       return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
     }
     break ;
   }

   return FALSE ;
 } 

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY TMEFMTMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   TMEFMTStruct *Tmefmt ;

   switch(message)
   {
     case WM_INITDLG :
     {
       Tmefmt = (TMEFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEFMT) ;

       hWndParent = *((HWND *)mp2) ;
       cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      **  Initialize radio button control: TmeFmtFormat                    
      */
       WinPostMsg(hWndDlg, WM_CONTROL,
                  MPFROMSHORT(Tmefmt->TmeFmtFormat), 0L) ;

      /*
      **  Initialize entry field control: TmeFmtSeparator                  
      */
       WinSendDlgItemMsg(hWndDlg, TMEFMTSEPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(2), 0L) ;
       if (Tmefmt->TmeFmtSeparator[0])
         WinSetDlgItemText(hWndDlg, TMEFMTSEPFLD, Tmefmt->TmeFmtSeparator) ;

       #include "TSTTIME.INC"
     }
     break ; // End of WM_INITDLG   

     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case TMEFMT12HRDB: // Radiobutton text: "12h (AM/PM)"            
         case TMEFMT24HRDB: // Radiobutton text: "24h"                    
         {
           // Read only   
         }
         break ;

         case TMEFMTSEPFLD: // Entry field variable: "TmeFmtSeparator"    
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code    
           {
             case EN_SETFOCUS :  // Entry field is receiving the focus   
                  break ;

             case EN_KILLFOCUS : // Entry field is losing the focus    
                  break ;

             default :           // Default other messages                       
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL   
     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"                                
         {
           Tmefmt = (TMEFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEFMT) ;

          /*
          ** Query radio buttons for current state, if set then        
          ** set the dialog structure variable to the control ID      
          */
           if (WinSendDlgItemMsg(hWndDlg, TMEFMT12HRDB, BM_QUERYCHECK, 0L, 0L ))
             Tmefmt->TmeFmtFormat = TMEFMT12HRDB ;

           if (WinSendDlgItemMsg(hWndDlg, TMEFMT24HRDB, BM_QUERYCHECK, 0L, 0L ))
             Tmefmt->TmeFmtFormat = TMEFMT24HRDB ;

           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;
       }
     }
     break ; // End of WM_COMMAND   

     case WM_CLOSE:
     {
       WinDismissDlg(hWndDlg, FALSE) ;
     }
     break ; // End of WM_CLOSE   

     case WM_FAILEDVALIDATE:
     {
       return((MRESULT)TRUE) ;
     }
     break ; // End of WM_FAILEDVALIDATE   

     default:
     {
       return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
     }
     break ;
   }

   return FALSE ;
 } 

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY NUMFMTMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   NUMFMTStruct *Numfmt ;

   switch(message)
   {
     case WM_INITDLG:
     {
       Numfmt = (NUMFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_NUMFMT) ;

       hWndParent = *((HWND *)mp2) ;
       cwCenter(hWndDlg, (HWND)hWndParent) ;

       /*
       ** Initialize entry field control: NumFmtDec                        
       */
        WinSendDlgItemMsg(hWndDlg, NUMFMTDECFLD, EM_SETTEXTLIMIT, MPFROMSHORT(1), 0L) ;
        if (Numfmt->NumFmtDec)
          WinSetDlgItemText(hWndDlg, NUMFMTDECFLD, &Numfmt->NumFmtDec) ;

       /*
       ** Initialize entry field control: NumFmtThs                        
       */
        WinSendDlgItemMsg(hWndDlg, NUMFMTTHSFLD, EM_SETTEXTLIMIT, MPFROMSHORT(1), 0L) ;
        if (Numfmt->NumFmtThs)
          WinSetDlgItemText(hWndDlg, NUMFMTTHSFLD, &Numfmt->NumFmtThs) ;

       /*
       ** Initialize entry field control: NumFmtSample                     
       */
        WinSendDlgItemMsg(hWndDlg, NUMFMTSMPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(16), 0L) ;
        if (Numfmt->NumFmtSample[0])
          WinSetDlgItemText(hWndDlg, NUMFMTSMPFLD, Numfmt->NumFmtSample) ;

       #include "TSTNUM.INC"
     }
     break ; // End of WM_INITDLG   

     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case NUMFMTDECFLD: // Entry field variable: "NumFmtDec"          
         case NUMFMTTHSFLD: // Entry field variable: "NumFmtThs"          
         case NUMFMTSMPFLD: // Entry field variable: "NumFmtSample"       
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code    
           {
             case EN_SETFOCUS :  // Entry field is receiving the focus   
                  break ;

             case EN_KILLFOCUS : // Entry field is losing the focus    
                  break ;

             default :           // Default other messages                       
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL   

     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"                                
         {
           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;
       }
     }
     break ; // End of WM_COMMAND   

     case WM_CLOSE:
     {
       WinDismissDlg(hWndDlg, FALSE) ;
     }
     break ; // End of WM_CLOSE   

     case WM_FAILEDVALIDATE:
     {
       return((MRESULT)TRUE) ;
     }
     break ; // End of WM_FAILEDVALIDATE   

     default:
     {
       return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
     }
     break ;
   }

   return FALSE ;
 } 

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY CURFMTMsgProc
 (
   HWND   hWndDlg ,  // Handle
   ULONG  message ,  // Message received from PM
   MPARAM mp1     ,  // First parameter of message
   MPARAM mp2        // Second parameter of message
 )
 {
   static HWND   hWndParent ;
   CURFMTStruct *Curfmt ;

   switch(message)
   {
     case WM_INITDLG:
     {
       Curfmt = (CURFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_CURFMT) ;

       hWndParent = *((HWND *)mp2) ;
       cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      **  Initialize radio button control: CurFmtPosition                  
      */
       WinPostMsg(hWndDlg, WM_CONTROL,
                  MPFROMSHORT(Curfmt->CurFmtPosition), 0L) ;

      /*
      **  Initialize entry field control: CurFmtSymbol                     
      */
       WinSendDlgItemMsg(hWndDlg, CURFMTSYMFLD, EM_SETTEXTLIMIT, MPFROMSHORT(8), 0L) ;
       if (Curfmt->CurFmtSymbol[0])
         WinSetDlgItemText(hWndDlg, CURFMTSYMFLD, Curfmt->CurFmtSymbol) ;

      /*
      **  Initialize check box control: CurFmtInterSpace                   
      */
       WinSendDlgItemMsg(hWndDlg, CURFMTISPCHK, BM_SETCHECK,
           MPFROMSHORT(Curfmt->CurFmtInterSpace), 0L) ;

      /*
      **  Initialize check box control: CurFmtLeadZeros                    
      */
       WinSendDlgItemMsg(hWndDlg, CURFMTLZRCHK, BM_SETCHECK,
           MPFROMSHORT(Curfmt->CurFmtLeadZeros), 0L) ;

      /*
      **  Initialize entry field control: CurFmtDecDigits                  
      */
       {
         CHAR szWorkBuf[50] ; // local scratch memory   

         if (Curfmt->CurFmtDecDigits != 0)
         {
           _itoa(Curfmt->CurFmtDecDigits, szWorkBuf, 10) ;
           WinSetDlgItemText(hWndDlg, CURFMTDGTFLD, szWorkBuf) ;
         }
       }

      /*
      ** Initialize entry field control: CurFmtSample                     
      */
       WinSendDlgItemMsg(hWndDlg, CURFMTSMPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(16), 0L) ;
       if (Curfmt->CurFmtSample[0])
         WinSetDlgItemText(hWndDlg, CURFMTSMPFLD, Curfmt->CurFmtSample) ;

       #include "TSTCUR.INC"
     }
     break ; // End of WM_INITDLG   

     case WM_CONTROL:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case CURFMTPFXRDB: // Radiobutton text: "Prefix"                 
         case CURFMTSFXRDB: // Radiobutton text: "Suffix"                 
         case CURFMTISPCHK: // Checkbox text: "Intervening space"         
         case CURFMTLZRCHK: // Checkbox text: "Leading zeros"             
         {
           // Read only   
         }
         break ;

         case CURFMTSYMFLD: // Entry field variable: "CurFmtSymbol"       
         case CURFMTDGTFLD: // Entry field variable: "CurFmtDecDigits"    
         case CURFMTSMPFLD: // Entry field variable: "CurFmtSample"       
         {
           switch(SHORT2FROMMP(mp1)) // Switch on Notification Code    
           {
             case EN_SETFOCUS :  // Entry field is receiving the focus   
                  break ;

             case EN_KILLFOCUS : // Entry field is losing the focus    
                  break ;

             default :           // Default other messages                       
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL   

     case WM_COMMAND:
     {
       switch(SHORT1FROMMP(mp1))
       {
         case DID_OK: // Button text: "OK"                                
         {
           Curfmt = (CURFMTStruct *)WinQueryWindowULong(hWndClient, OFFSET_CURFMT) ;

          /*
          ** Query radio buttons for current state, if set then        
          ** set the dialog structure variable to the control ID      
          */
           if (WinSendDlgItemMsg(hWndDlg, CURFMTPFXRDB, BM_QUERYCHECK, 0L, 0L ))
             Curfmt->CurFmtPosition = CURFMTPFXRDB ;

           if (WinSendDlgItemMsg(hWndDlg, CURFMTSFXRDB, BM_QUERYCHECK, 0L, 0L ))
             Curfmt->CurFmtPosition = CURFMTSFXRDB ;

           Curfmt->CurFmtInterSpace = (ULONG)(WinSendDlgItemMsg(hWndDlg, 
                                      CURFMTISPCHK, BM_QUERYCHECK, 0L, 0L)) ;
           Curfmt->CurFmtLeadZeros  = (ULONG)(WinSendDlgItemMsg(hWndDlg, 
                                      CURFMTLZRCHK, BM_QUERYCHECK, 0L, 0L)) ;

           WinDismissDlg(hWndDlg, TRUE) ;
         }
         break ;
       }
     }
     break ; // End of WM_COMMAND   

     case WM_CLOSE:
     {
       WinDismissDlg(hWndDlg, FALSE) ;
     }
     break ; // End of WM_CLOSE   

     case WM_FAILEDVALIDATE:
     {
       return((MRESULT)TRUE) ;
     }
     break ; // End of WM_FAILEDVALIDATE   

     default:
     {
       return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
     }
     break ;
   }

   return FALSE ;
 } 

/* ------------------------------------------------------------------------ */

/*
**  cwRegisterClass Function
**
**  The following function registers all the classes of all the windows
**  associated with this application. The function returns TRUE if it is
**  successful, otherwise it returns FALSE.
**
*/
 INT cwRegisterClass(VOID)
 {
   APIRET rc ;

   WinLoadString(hAB, 0, IDS_APP_NAME, 80, szAppName) ; // Program name

   rc = WinRegisterClass (hAB,              // Anchor block handle
                          (PCH)szAppName,   // Name of class being registered
                          (PFNWP)WndProc,   // Window procedure for class
                          CS_SIZEREDRAW ,
                          5*sizeof(char*)) ;
   if (rc == FALSE) return(FALSE) ;

   return(TRUE) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCreateWindow Function
**
**  The following function is used to create a window (the main window,
**  a child window, an icon window, etc.) and set it's initial size and
**  position. It returns the handle to the frame window.
**
*/
 HWND cwCreateWindow
 (
   HWND   hWndParent,  // Handle to the parent of the window to be created
   ULONG  ctldata,     // Frame control flags for the window
   PCH    appname,     // Class name of the window
   PCH    title,       // Title of the window
   ULONG  ResID,       // Resource id value
   INT    x,           // Initial horizontal and vertical location
   INT    y,           //
   INT    cx,          // Initial width and height of the window
   INT    cy,          //
   PHWND  hWndClient,  // Handle to the client area of the window
   ULONG  lfStyle,     // Frame window style
   USHORT uSizeStyle   // User defined size and location flags
 )
 {
   ULONG  rc ;            // Accepts return codes from function calls
   HWND   hWndFrame ;     // Local handle to created window frame
   ULONG  SizeStyle ;     // Local window positioning options
   CHAR   MsgBuffer[80] ; // Buffer for error messages
   HPS    hPS ;           // Handle to a presentation space
   int    xmod, ymod ;    // Modifiers for sizing
   #define DLGXMOD  4     // Dialog units X modulo
   #define DLGYMOD  8     // Dialog units Y modulo
   FONTMETRICS fm ;       // Structure for determing modifiers

  /*
  **  Create the frame window
  */
   hWndFrame = WinCreateStdWindow(hWndParent,  // Parent of window
                                  lfStyle,     // Frame window style
                                  &ctldata,    // Frame flags
                                  appname,     // Class name
                                  title,       // Window title
                                  0L,          // Client window style
                                  0,           // Module for resources
                                  ResID,       // Resource id
                                  (HWND *)hWndClient) ; // Client handle

  /*
  **  If hWndFrame is NULL, an error occured when opening the window,
  **  notify the user and exit this function
  */
   if(hWndFrame == 0)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_CREATE, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return ((HWND)0) ;
   }

  /*
  **  Set up size options
  */
   SizeStyle = SWP_ACTIVATE | SWP_ZORDER | uSizeStyle ;

  /*
  **  If the height, width, intial x or initial y values are non-zero,
  **  then we will need to set up the modifiers for size and location
  */
   if((cx > 0) || (cy > 0) || (x != 0)  || (y != 0))
   {
     hPS = WinGetPS(HWND_DESKTOP) ;
     GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm) ;
     xmod = (INT)fm.lAveCharWidth ;
     ymod = (INT)fm.lMaxBaselineExt ;
     WinReleasePS(hPS) ;
   }

  /*
  **  If either the width or the height are non-zero, then the size of the
  **  created window will be changed, set SizeStyle accordingly
  */
   if((cx > 0) || (cy > 0) || (x != 0) || (y != 0))
   {
     SizeStyle |= SWP_SIZE ;
     SizeStyle |= SWP_MOVE ;
   }

  /*
  **  Set the size and position of the window and activate it
  */
   rc = WinSetWindowPos(hWndFrame, HWND_TOP,
                        ((x * xmod)/DLGXMOD),
                        ((y * ymod)/DLGYMOD),
                        ((cx * xmod)/DLGXMOD),
                        ((cy * ymod)/DLGYMOD), SizeStyle) ;

  /*
  **  If rc is not set to TRUE then WinSetWindowPos failed, notify the user
  **  and exit this function
  */
   if(!rc)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_POS, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return((HWND)0) ;
   }

  /*
  **  Return the handle to the frame window
  */
   return(hWndFrame) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCenter Function
**
**  Centers a dialog box on the client area of the caller
**
**  hWnd       - handle of the window to be centered
**  hWndParent - handle of the window on which to center
**
*/
 INT cwCenter
 (
   HWND hWnd       ,
   HWND hWndParent
 )
 {
   LONG   SrcX, SrcY ;                // Center of parent
   LONG   x, y ;                      // Destination points
   SWP    DlgSwp, ParentSwp ;         // Set window position structures
   LONG   ScreenWidth, ScreenHeight ; // Dimensions of the DESKTOP
   POINTL pt ;                        // Point

  /*
  **  Determine the width and height of the DESKTOP so the dialog box
  **  will not be positioned to a point off of the screen.
  */
   ScreenWidth  = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) ;
   ScreenHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) ;

  /*
  **  Query width and depth of dialog box
  */
   WinQueryWindowPos(hWnd, (PSWP)&DlgSwp) ;

  /*
  **  Query width and depth of caller
  */
   WinQueryWindowPos(hWndParent, (PSWP)&ParentSwp) ;

  /*
  **  Map the point parent points to the Desktop
  */
   pt.x = ParentSwp.x ;
   pt.y = ParentSwp.y ;

  /*
  **  Convert the point from having our window as the origin to having
  **  the DESKTOP as the origin
  */
   WinMapWindowPoints(hWndParent, HWND_DESKTOP, &pt, 1) ;

   SrcX = pt.x + (ParentSwp.cx / 2) ;
   SrcY = pt.y + (ParentSwp.cy / 2) ;

  /*
  **  Determine the point to move the dialog box to
  */
   x = (SrcX - (DlgSwp.cx / 2)) ;
   y = (SrcY - (DlgSwp.cy / 2)) ;

  /*
  **  If either point is less than zero, then set that point to zero
  **  so the dialog box will not be positoned off of the window
  */
   x = (x < 0L) ? 0L : x ;
   y = (y < 0L) ? 0L : y ;

  /*
  **  If either point plus the height or width of the dialog box is
  **  greater than the height or width of the screen adjust point
  */
   if ((x + DlgSwp.cx) > ScreenWidth)  x = ScreenWidth - DlgSwp.cx ;
   if ((y + DlgSwp.cy) > ScreenHeight) y = ScreenHeight - DlgSwp.cy ;

  /*
  **  Move the dialog box
  */
   return(WinSetWindowPos(hWnd, HWND_TOP, x, y, 0, 0, SWP_MOVE)) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  This function allocates memory for dialog box variables and initializes
**  the state of any initially selected radio buttons and check boxes.
*/
 INT cwSetInitDlgStatus(HWND hWnd)
 {
   NTLINFStruct *Ntlinf ;
   DTEFMTStruct *Dtefmt ;
   TMEFMTStruct *Tmefmt ;
   NUMFMTStruct *Numfmt ;
   CURFMTStruct *Curfmt ;

   OFFSETOF(Ntlinf) = 0 ;
   DosAllocMem(((PPVOID)&Ntlinf), sizeof(NTLINFStruct), fALLOC) ;
   memset(Ntlinf, 0x00, sizeof(NTLINFStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_NTLINF, (ULONG)Ntlinf) ;

   OFFSETOF(Dtefmt) = 0 ;
   DosAllocMem(((PPVOID)&Dtefmt), sizeof(DTEFMTStruct), fALLOC) ;
   memset(Dtefmt, 0x00, sizeof(DTEFMTStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_DTEFMT, (ULONG)Dtefmt) ;

   OFFSETOF(Tmefmt) = 0 ;
   DosAllocMem(((PPVOID)&Tmefmt), sizeof(TMEFMTStruct), fALLOC) ;
   memset(Tmefmt, 0x00, sizeof(TMEFMTStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_TMEFMT, (ULONG)Tmefmt) ;

   OFFSETOF(Numfmt) = 0 ;
   DosAllocMem(((PPVOID)&Numfmt), sizeof(NUMFMTStruct), fALLOC) ;
   memset(Numfmt, 0x00, sizeof(NUMFMTStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_NUMFMT, (ULONG)Numfmt) ;

   OFFSETOF(Curfmt) = 0 ;
   DosAllocMem(((PPVOID)&Curfmt), sizeof(CURFMTStruct), fALLOC) ;
   memset(Curfmt, 0x00, sizeof(CURFMTStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_CURFMT, (ULONG)Curfmt) ;
   Curfmt->CurFmtPosition = CURFMTPFXRDB ;
   Curfmt->CurFmtInterSpace = FALSE ;
   Curfmt->CurFmtLeadZeros = FALSE ;

   return(0) ;
 }

/* ------------------------------------------------------------------------ */

 INT cwFreeDlgMemory(HWND hWnd)
 {
   NTLINFStruct *Ntlinf ;
   DTEFMTStruct *Dtefmt ;
   TMEFMTStruct *Tmefmt ;
   NUMFMTStruct *Numfmt ;
   CURFMTStruct *Curfmt ;

   Ntlinf = (NTLINFStruct *)WinQueryWindowULong(hWnd, OFFSET_NTLINF) ;
   DosFreeMem((PVOID)(Ntlinf)) ;
   Dtefmt = (DTEFMTStruct *)WinQueryWindowULong(hWnd, OFFSET_DTEFMT) ;
   DosFreeMem((PVOID)(Dtefmt)) ;
   Tmefmt = (TMEFMTStruct *)WinQueryWindowULong(hWnd, OFFSET_TMEFMT) ;
   DosFreeMem((PVOID)(Tmefmt)) ;
   Numfmt = (NUMFMTStruct *)WinQueryWindowULong(hWnd, OFFSET_NUMFMT) ;
   DosFreeMem((PVOID)(Numfmt)) ;
   Curfmt = (CURFMTStruct *)WinQueryWindowULong(hWnd, OFFSET_CURFMT) ;
   DosFreeMem((PVOID)(Curfmt)) ;
  return(0) ;
 }

/* ------------------------------------------------------------------------ */

 void lmemset(void FAR *memptr, CHAR value, INT size)
 {
   char FAR *chrptr = memptr ;

   while (size--) *chrptr++ = value ;
 }

/* ------------------------------------------------------------------------ */

 int cwCheckDlgItem(HWND hWndDlg, INT id, INT state)
 {
   return((ULONG)WinSendDlgItemMsg(hWndDlg, id, BM_SETCHECK, MPFROMSHORT(state), 0L)) ;
 }

/* ------------------------------------------------------------------------ */

