/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** \----------------------------------------------------------------------/
**
**  Module    : ZNLDEFS.H
**  Author    : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**  Reviewer  : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created   : 09 Jul 1992
**  Updated   : 21 Sep 1993
**  Version   : 3.22
**  Content   : Public definitions and macros
**
*/
 #ifndef  znlDEFINITIONS
 #define  znlDEFINITIONS  0

 #define  INCL_DOSNLS

 #define  znlZPREFIX           "ZNL"
 #define  znlDLLNAME           "FMZNLFUN"

/*
**  Buffer sizes
*/
 #define  znlLONGBUFFER        40     // Max size of long strings
 #define  znlSHORTBUFFER       5      // Max size of short strings
 #define  znlDOUBLEBUFFER      80     // Max size of "double" strings

/*
**  Currency formats
*/
 #define  znlCUR_SUFF          0x01   // Suffix
 #define  znlCUR_SEP           0x02   // Separator
 #define  znlCUR_PREF_NOSEP    0x00   // Prefix, no separator
 #define  znlCUR_SUFF_NOSEP    0x01   // Suffix, no separator
 #define  znlCUR_PREF_SEP      0x02   // Prefix, separator
 #define  znlCUR_SUFF_SEP      0x03   // Suffix, separator

/*
**  Date and time formats
*/
 #define  znlDATE_MMDDYY       0x00   // Month, Day, Year
 #define  znlDATE_DDMMYY       0x01   // Day, Month, Year
 #define  znlDATE_YYMMDD       0x02   // Year, Month, Day
 #define  znlTIME_12           0x00   // 12h (AM/PM)
 #define  znlTIME_24           0x01   // 24h

/*
**  Type of information
*/
 #define  znlCOUNTRY           0x0000 // Base country structure
 #define  znlISO               0x0001 // Country structure ISO modified

/*
**  ISO settings
*/
 #define  znlISO_NAME          "ISO"
 #define  znlISO_DATEFMT       znlDATE_YYMMDD
 #define  znlISO_TIMEFMT       znlTIME_24
 #define  znlISO_DATESEP       '-'
 #define  znlISO_TIMESEP       '.'

/*
**  Defaults
*/
 #define  znlDEFAULTCOUNTRY    0
 #define  znlDEFAULTCODEPAGE   0

/*
**  Note that, since certain flags are used in the same operations, they
**  must be MUTUAL EXCLUSIVE, that is they can't use the same bits.
**  Flags not used at the same time may have the same value.
*/
 #define  znlNOTDEFINED      0x00000000  // For check on flags
 #define  znlUSEDEFAULTS     0x00000000  // Passed by the caller

/*
**  Used by znlMakeCtryDouble()
*/
 #define  znlTHS_DEFAULTS    0x00000001 // Defaults for parsing options
 #define  znlTHS_CURRENT     0x00000001 // Add if specified in current settings
 #define  znlTHS_NONE        0x00000002 // Never add thousand separators
 #define  znlTHS_INTONLY     0x00000004 // Add only in integer part

/*
**  Macros
*/
 #include <znlmacro.h>

 #endif
