/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Module  : ZZZLOGO.C
**  Author  : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 30 Aug 1993
**  Updated : 30 Aug 1993
**  Version : 1.00
**  Content : Logo Data Dialog Procedure
**
*/
 #define INCL_PM
 #define INCL_DOSPROCESS

 #include <os2.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <ctype.h>

 #include <zzzlogo.h>

/*------------------------------------------------------------------------*/

 MRESULT EXPENTRY zzzLogoDlgProc
 (
   HWND   hwnd ,
   ULONG  msg  ,
   MPARAM mp1  ,
   MPARAM mp2
 )
 {
   switch (msg)
   {
     case WM_INITDLG :
     {
       zzzPLOGODATA pLogoData = (zzzPLOGODATA)mp2 ;

       WinSetDlgItemText ( hwnd, ZZZLOGOLIBTX2, pLogoData->Library   ) ;
       WinSetDlgItemText ( hwnd, ZZZLOGOVERTX2, pLogoData->Version   ) ;
       WinSetDlgItemText ( hwnd, ZZZLOGOAUTTX2, pLogoData->Author    ) ;
       WinSetDlgItemText ( hwnd, ZZZLOGOCPYTXT, pLogoData->Copyright ) ;

       (VOID)zzzCenterDialog (hwnd, HWND_DESKTOP) ;
     }
     break ;

     case WM_COMMAND:
     {
       switch (SHORT1FROMMP(mp1))
       {
         case DID_OK:
         {
           WinDismissDlg(hwnd, TRUE) ;
           WinDestroyWindow(hwnd) ;
           return ((MRESULT)FALSE) ;
         }
       }
     }
     break ;

     case WM_CLOSE:
     {
       return (WinDefDlgProc (hwnd, msg, mp1, mp2)) ;
     }

     case WM_DESTROY:
     {
       return (WinDefDlgProc (hwnd, msg, mp1, mp2)) ;
     }

     default:
     {
       return (WinDefDlgProc (hwnd, msg, mp1, mp2)) ;
     }
   }

   return ((MRESULT)FALSE) ;
 }

/*------------------------------------------------------------------------*/

/*
**  Function : zzzCenterDialog
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 09 Aug 1993
**  Updated  : 09 Aug 1993
**  Version  : 1.00
**  Content  : Centers a dialog box on the client area of the caller
**
*/
 LONG EXPENTRY zzzCenterDialog
 (
   HWND hWnd       ,  // Handle of the window to be centered
   HWND hWndCenter    // Handle of the window to center on
 )
 {
   LONG   X, Y ;                         // Destination points
   SWP    DlgSwp, CenterSwp ;            // Set window position structures
   LONG   lScreenWidth, lScreenHeight ;  // Dimensions of the DESKTOP

  /*
  **  Query width and depth of dialog box
  */
   WinQueryWindowPos (hWnd, (PSWP) &DlgSwp) ;

  /*
  **  Query width and depth of caller
  */
   WinQueryWindowPos (hWndCenter, (PSWP) &CenterSwp) ;

  /*
  **  Determine the difference in center points from owner to child
  */
   X = (CenterSwp.x + (CenterSwp.cx / 2)) - (DlgSwp.x + (DlgSwp.cx / 2)) ;
   Y = (CenterSwp.y + (CenterSwp.cy / 2)) - (DlgSwp.y + (DlgSwp.cy / 2)) ;

  /*
  **  Ajust x,y origin coordinates to new position of child
  */
   X = DlgSwp.x + X ;
   Y = DlgSwp.y + Y ;

  /*
  **  If either x,y origin point is less than zero, then set that point to
  **  zero so that the entire dialog box will be positioned on the desktop.
  **  First check the bottom and left sides.
  */
   X = (X < 0) ? 0 : X ;
   Y = (Y < 0) ? 0 : Y ;

  /*
  **  Query dimensions of the DESKTOP screen.
  */
   lScreenWidth  = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN) ;
   lScreenHeight = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN) ;

  /*
  **  Second check the top and right sides against the desktop
  **  screen width and height.
  */
   if ((X + DlgSwp.cx) > lScreenWidth ) X = lScreenWidth  - DlgSwp.cx ;
   if ((Y + DlgSwp.cy) > lScreenHeight) Y = lScreenHeight - DlgSwp.cy ;

  /*
  **  Move the dialog box to the center
  */
   return (WinSetWindowPos (hWnd, HWND_TOP, X, Y, 0, 0, SWP_MOVE)) ;
 }

/*------------------------------------------------------------------------*/

