/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header  : TSTTYPE.INC
**  Author  : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Pino Venturella (VENTUREL at ROMEPPC)
**  Created : 06 Jul 1992
**  Updated : 31 Aug 1993
**  Version : 3.12
**  Content : Called by TSTFUNMsgProc in WM_CONTROL and TSTFUNTYPDDL case
**            statement. Display the different notation in the corresponding
**            list box
**
*/
 {
   GLBL   gbl ;
   FIELD  fld ;
   char   szWorkBuf[33] ;
   USHORT typeID ;
   LIST   lst ;
   int    i ; // counter

   Tstfun = (TSTFUNStruct *)WinQueryWindowULong(hWndClient, OFFSET_TSTFUN) ;

  /*
  ** Reset radio button value
  */
   cwCheckDlgItem(hWndDlg, TSTFUNFALRDB, FALSE) ;
   cwCheckDlgItem(hWndDlg, TSTFUNTRURDB, FALSE) ;

   WinQueryDlgItemText(hWndDlg, TSTFUNTYPDDL, sizeof(szWorkBuf), szWorkBuf) ;
   strcpy(Tstfun->TstFunType, szWorkBuf) ;

   lst.size = 16 ;
   lst.dim = 32 ;
   lst.psz = (PSZ)Tstfun->TstFunNotationTbl ;

   gbl.data = &(hAB) ;
   fld.dim = 32 ;
   fld.psz = (PSZ)Tstfun->TstFunType ;

   typeID = tstGetTypeID (&gbl, &fld) ;

  /*
  ** Load table of notation
  */
   tstLoadTbl (TST_NOTATION, typeID, &gbl, &lst) ;

  /*
  **  Delete all item in the DDL notation
  */
   WinSendDlgItemMsg (hWndDlg, TSTFUNNOTDDL, LM_DELETEALL, 0, 0) ;

  /*
  ** Initialize Notation List with Table
  */
   for (i=0; i < 16; i++)
     if (Tstfun->TstFunNotationTbl[i][0])
       WinSendDlgItemMsg(hWndDlg, TSTFUNNOTDDL, LM_INSERTITEM,
                         MPFROM2SHORT(LIT_END, 0),
                         MPFROMP(Tstfun->TstFunNotationTbl[i])) ;

  /*
  **  Set default notation value. Note that such action sends a CBN_EFCHANGE
  **  message to TSTFUNNOTDLL, which is handled by the code in TSTNOTAT.INC
  */
   WinLoadString(hAB, 0, TST_ID_NTN_FLAT, 32, Tstfun->TstFunNotation) ;
   WinSetDlgItemText (hWndDlg, TSTFUNNOTDDL, Tstfun->TstFunNotation) ;
 }
