/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header  : TSTINIT.INC
**  Authors : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Pino Venturella (VENTUREL at ROMEPPC)
**  Reviewer: Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 06 Jul 1992
**  Updated : 31 Aug 1993
**  Version : 3.12
**  Content : Called by TSTFUNMsgProc in the WM_INITDLG case statement.
**            Fill the list tables and display the content.
**
*/
 {
    GLBL  gbl ;
    LIST  lst ;
    FIELD fld ;
    int   i   ; // Loop counter

  /*
  **  Initialize field lengths
  */
    WinSendDlgItemMsg (hWndDlg, TSTFUNNOTDDL, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
    WinSendDlgItemMsg (hWndDlg, TSTFUNTYPDDL, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
    WinSendDlgItemMsg (hWndDlg, TSTFUNSMPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ; 

  /*
  **  Define size, dim and pointer to the table of types
  */
    lst.size = 16 ;
    lst.dim  = 32 ;
    lst.psz = (PSZ)Tstfun->TstFunTypeTbl ;

    gbl.data = &(hAB) ;

  /*
  **  Load the list of types
  */
   tstLoadTbl(TST_TYPE, 0, &gbl, &lst) ;

  /*
  ** Initialize Type List with Table
  */
   for (i=0; i < 16; i++)
     if (Tstfun->TstFunTypeTbl[i][0])
       WinSendDlgItemMsg(hWndDlg, TSTFUNTYPDDL, LM_INSERTITEM,
                         MPFROM2SHORT(LIT_END, 0),
                         MPFROMP(Tstfun->TstFunTypeTbl[i])) ;

  /*
  **  Set default type value. Note that such action sends a CBN_EFCHANGE
  **  message to TSTFUNTYPDLL, which is handled by the code in TSTTYPE.INC
  */
   WinLoadString(hAB, 0, TST_ID_TYPE_NAT, 32, Tstfun->TstFunType) ;
   WinSetDlgItemText(hWndDlg, TSTFUNTYPDDL, Tstfun->TstFunType);

  /*
  **  Initialize radio button control: TstFunResult
  */
   cwCheckDlgItem(hWndDlg, TSTFUNFALRDB, FALSE) ;
   cwCheckDlgItem(hWndDlg, TSTFUNTRURDB, FALSE) ;
 }
