/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header  : TSTFUNCS.C
**  Authors : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Pino Venturella (VENTUREL at ROMEPPC)
**  Reviewer: Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 06 Jul 1992
**  Updated : 31 Aug 1993
**  Version : 3.12
**  Content : Utility functions
**
*/
 #define INCL_PM
 #define INCL_DOS

 #include <os2.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>

 #include "tstall.h"

/* ------------------------------------------------------------------------ */

/*
**  Load strings in the specified table
**
**  Input: tblID  : ID of table (Type or Notation)
**         typeID : ID of type selected
**         gbl    : Address of global data
**         tbl    : Address of the table to be filled
*/
 void  tstLoadTbl
 (
   USHORT   tblID,
   USHORT   typeID,
   PGLBL    gbl,
   PLIST    tbl
 )
 {
   int i = 0 ;

   switch (tblID)
   {
     case TST_TYPE:
     {
      /*
      **  Load strings from resource file
      */
       WinLoadString(*(gbl->data), 0,
                     TST_ID_TYPE_NAT, tbl->dim, tbl->psz) ;
       WinLoadString(*(gbl->data), 0,
                     TST_ID_TYPE_INT, tbl->dim, tbl->psz+tbl->dim) ;
       WinLoadString(*(gbl->data), 0,
                     TST_ID_TYPE_REAL, tbl->dim,tbl->psz+2*tbl->dim) ;

      /*
      **  Set to null all the other fields
      */
       for (i = 3; i < 16; i++)
         memset(tbl->psz+i*tbl->dim, 0x00, tbl->dim) ;
     }
     break ;

     case TST_NOTATION:
     {
       switch (typeID)
       {
         case TST_ID_TYPE_NAT:
         case TST_ID_TYPE_INT:
         {
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_FLAT, tbl->dim, tbl->psz) ;
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_THS, tbl->dim, tbl->psz+tbl->dim) ;
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_ANY, tbl->dim, tbl->psz+2*tbl->dim) ;

        /*
        **  Set to null all the other fields
        */
         for (i = 3; i < 16; i++)
           memset(tbl->psz+i*tbl->dim, 0x00, tbl->dim) ;
         }
         break ;

         case TST_ID_TYPE_REAL:
         {
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_FLAT, tbl->dim, tbl->psz) ;
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_THS, tbl->dim, tbl->psz+tbl->dim) ;
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_SCI, tbl->dim, tbl->psz+2*tbl->dim) ;
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_EXP, tbl->dim, tbl->psz+3*tbl->dim) ;
           WinLoadString(*(gbl->data), 0,
                         TST_ID_NTN_ANY, tbl->dim, tbl->psz+4*tbl->dim) ;

        /*
        **  Set to null all the other fields
        */
         for (i = 5; i < 16; i++)
           memset(tbl->psz+i*tbl->dim, 0x00, tbl->dim) ;
         }
         break ;

         default:
         {
        /*
        **  Set to null all the other fields
        */
         for (i = 0; i < 16; i++)
           memset(tbl->psz+i*tbl->dim, 0x00, tbl->dim) ;
         }
         break ;
       }
     }
     break ;

     default:
     {
      /*
      **  Set to null all the other fields
      */
       for (i = 0; i < 16; i++)
         memset(tbl->psz+i*tbl->dim, 0x00, tbl->dim) ;
     }
     break ;
   }
 }

/* ------------------------------------------------------------------------ */

/*
**  Returns the ID of the selected function
**
**  Input:
**         gbl     : Address of global data
**         type    : Address of the field containing the selected type
**         notation: Address of the field containing the selected notation
**  Output:
**         funcID  : ID of the function corresponding to the selected type
**                   and notation
*/
 USHORT tstGetFunctionID
 (
   PGLBL   gbl ,
   PFIELD  type,
   PFIELD  notation
 )
 {
   USHORT funcID ;
   USHORT typeID ;
   USHORT notationID ;
   char   psz[tstMAX_STR_LEN] ;

  /*
  ** Get type and notation ID
  */
   typeID = tstGetTypeID (gbl,type) ;
   notationID = tstGetNotationID (gbl,notation) ;

  /*
  ** Set function ID according to the selected type and notation ID
  */
   switch (typeID)
   {
     case TST_ID_TYPE_NAT:
     {
       switch (notationID)
       {
         case TST_ID_NTN_FLAT:
              funcID = TST_FLAT_NAT ;
              break ;

         case TST_ID_NTN_THS:
              funcID = TST_THS_NAT ;
              break ;

         case TST_ID_NTN_ANY:
              funcID = TST_ANY_NAT ;
              break ;

         default :
              break ;
       }
     }
     break ;

     case TST_ID_TYPE_INT:
     {
       switch (notationID )
       {
         case TST_ID_NTN_FLAT:
              funcID = TST_FLAT_INT ;
              break ;

         case TST_ID_NTN_THS:
              funcID = TST_THS_INT ;
              break ;

         case TST_ID_NTN_ANY:
              funcID = TST_ANY_INT ;
              break ;

         default :
              break ;
       }
     }
     break ;

     case TST_ID_TYPE_REAL:
     {
       switch (notationID )
       {
         case TST_ID_NTN_FLAT:
              funcID = TST_FLAT_REAL ;
              break ;

         case TST_ID_NTN_THS:
              funcID = TST_THS_REAL ;
              break ;

         case TST_ID_NTN_ANY:
              funcID = TST_ANY_REAL ;
              break ;

         case TST_ID_NTN_SCI:
              funcID = TST_SCI_REAL ;
              break ;

         case TST_ID_NTN_EXP:
              funcID = TST_EXP_REAL ;
              break ;

         default :
              break ;
       }
     }
     break ;

     default :
          break ;
   }
   return(funcID) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Get type ID from an input string
**
**  Input :
**         gbl     : Address of global data
**         type    : Address of the field containing the selected type
**  Output:
**         ID of the selected type, or 0 if doesn't match
*/
 USHORT tstGetTypeID
 (
   PGLBL   gbl ,
   PFIELD  type
 )
 {
   char   psz[tstMAX_STR_LEN] ;

   WinLoadString(*(gbl->data), 0, TST_ID_TYPE_NAT, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,type->psz)) return (TST_ID_TYPE_NAT) ;

   WinLoadString(*(gbl->data), 0, TST_ID_TYPE_INT, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,type->psz)) return (TST_ID_TYPE_INT) ;

   WinLoadString(*(gbl->data), 0, TST_ID_TYPE_REAL, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,type->psz)) return (TST_ID_TYPE_REAL) ;

   return (0) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Get notation ID from an input string
**
**  Input :
**         gbl     : Address of global data
**         notation: Address of the field containing the selected notation
**  Output:
**         ID of the selected notation, or 0 if doesn't match
*/
 USHORT tstGetNotationID
 (
   PGLBL   gbl ,
   PFIELD  notation
 )
 {
   char   psz[tstMAX_STR_LEN] ;

   WinLoadString(*(gbl->data), 0, TST_ID_NTN_FLAT, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,notation->psz)) return (TST_ID_NTN_FLAT) ;

   WinLoadString(*(gbl->data), 0, TST_ID_NTN_THS, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,notation->psz)) return (TST_ID_NTN_THS) ;

   WinLoadString(*(gbl->data), 0, TST_ID_NTN_ANY, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,notation->psz)) return (TST_ID_NTN_ANY) ;

   WinLoadString(*(gbl->data), 0, TST_ID_NTN_EXP, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,notation->psz)) return (TST_ID_NTN_EXP) ;

   WinLoadString(*(gbl->data), 0, TST_ID_NTN_SCI, tstMAX_STR_LEN, psz) ;
   if (!strcmp(psz,notation->psz)) return (TST_ID_NTN_SCI) ;

   return (0) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Build and Display sample for any selected function
**
**  Input:
**        funcID : ID of the function
**        fld    : Address of the entry field to be filled with the sample
*/
void tstDisplSample
(
  USHORT  funcID ,
  PFIELD  fld
)
{
  COUNTRYCODE  CtryCode ;  // Country
  COUNTRYINFO  CtryInfo ;  // Country Information
  ULONG        ulLen    ;
  APIRET       apirc ;     // Return code from DosQueryCtryInfo
  char         thsSep[2] ; // thousand separator
  char         decSep[2] ; // decimal separator
  char         tmp[tstMAX_STR_LEN] ;  // temporary string

 /*
 **  Get country information from COUNTRY.SYS file
 */
  CtryCode.country = 0 ;
  CtryCode.codepage = 0 ;

  apirc = DosQueryCtryInfo(sizeof(COUNTRYINFO), &(CtryCode), &(CtryInfo), &ulLen) ;
  strcpy(thsSep, CtryInfo.szThousandsSeparator) ;
  strcpy(decSep, CtryInfo.szDecimal) ;

 /*
 **  Create sample according to function id
 */
  switch (funcID)
  {
    case TST_FLAT_NAT:
         strcpy(tmp,"+123456789") ;
         break ;

    case TST_THS_NAT:
         strcpy(tmp,"+123") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"456") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"789") ;
         break ;

    case TST_ANY_NAT:
         strcpy(tmp,"+1234 or +1") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"234") ;
         break ;

    case TST_FLAT_INT:
         strcpy(tmp,"-123456789") ;
         break ;

    case TST_THS_INT:
         strcpy(tmp,"-123") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"456") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"789") ;
         break ;

    case TST_ANY_INT:
         strcpy(tmp,"-1234 or +1") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"234") ;
         break ;

    case TST_FLAT_REAL:
        strcpy(tmp,"-1234") ;
        strcat(tmp,decSep) ;
        strcat(tmp,"4567") ;
        break ;

    case TST_THS_REAL:
         strcpy(tmp,"-1") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"234") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"456") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"7") ;
         break ;

    case TST_SCI_REAL:
         strcpy(tmp,"-0") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"123E+32") ;
         break ;

    case TST_EXP_REAL:
         strcpy(tmp,"-1234") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"567E+32") ;
         break ;

    case TST_ANY_REAL:
         strcpy(tmp,"1") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"2 or 1") ;
         strcat(tmp,thsSep) ;
         strcat(tmp,"234") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"5 or 0") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"1e2 or 1") ;
         strcat(tmp,decSep) ;
         strcat(tmp,"2E3") ;
         break ;

    default :
         break ;
  }

  strncpy (fld->psz, tmp, fld->dim)  ;
}

/* ------------------------------------------------------------------------ */

