/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header  : TSTCHECK.INC
**  Authors : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Pino Venturella (VENTUREL at ROMEPPC)
**  Reviewer: Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 06 Jul 1992
**  Updated : 31 Aug 1993
**  Version : 3.12
**  Content : Called by TSTFUNMsgProc in WM_COMMAND and TSTFUNCHKBUT case
**            statement. Call the appropriate zis* functions
**
*/
{
  char   szWorkBuf[33] ;
  BOOL   Res = FALSE   ,
         Err = FALSE   ;

  GLBL   gbl      ;     // Global data
  FIELD  type     ,     // Type field
         notation ;     // Notation field
  USHORT funcID   ;     // Selected function ID

 /*
 ** Get the address of the variable connected to the Dialog
 */
  Tstfun = (TSTFUNStruct *)WinQueryWindowULong(hWndClient, OFFSET_TSTFUN) ;

 /*
 ** Get the selected type
 */
  WinQueryDlgItemText(hWndDlg, TSTFUNTYPDDL, sizeof(szWorkBuf), szWorkBuf) ;
  strcpy(Tstfun->TstFunType, szWorkBuf) ;

 /*
 ** Get the selected notation
 */
  WinQueryDlgItemText(hWndDlg, TSTFUNNOTDDL, sizeof(szWorkBuf), szWorkBuf) ;
  strcpy(Tstfun->TstFunNotation, szWorkBuf) ;

 /*
 ** Get the function ID
 */
  gbl.data = &hAB  ;
  type.dim = 32  ;
  type.psz = (PSZ)Tstfun->TstFunType ;

  notation.dim = 32 ;
  notation.psz = (PSZ)Tstfun->TstFunNotation ;

  funcID = tstGetFunctionID(&gbl, &type, &notation) ;

 /*
 ** Get the input field
 */
  WinQueryDlgItemText(hWndDlg, TSTFUNINPFLD, sizeof(szWorkBuf), szWorkBuf) ;
  strcpy(Tstfun->TstFunInput, szWorkBuf) ;

 /*
 ** Call the appropriate function
 */
  switch (funcID)
  {
    case TST_FLAT_NAT :
       Res = zisNatString (Tstfun->TstFunInput) ;
       break ;

    case TST_THS_NAT :
       Res = zisThsNatString (Tstfun->TstFunInput) ;
       break ;

    case TST_ANY_NAT :
       Res = zisAnyNatString (Tstfun->TstFunInput) ;
       break ;

    case TST_FLAT_INT :
       Res = zisIntString (Tstfun->TstFunInput) ;
       break ;

    case TST_THS_INT :
       Res = zisThsIntString (Tstfun->TstFunInput) ;
       break ;

    case TST_ANY_INT :
       Res = zisAnyIntString (Tstfun->TstFunInput) ;
       break ;

    case TST_FLAT_REAL :
       Res = zisRealString (Tstfun->TstFunInput) ;
       break ;

    case TST_THS_REAL :
       Res = zisThsRealString (Tstfun->TstFunInput) ;
       break ;

    case TST_SCI_REAL :
       Res = zisSciRealString (Tstfun->TstFunInput) ;
       break ;

    case TST_EXP_REAL :
       Res = zisExpRealString (Tstfun->TstFunInput) ;
       break ;

    case TST_ANY_REAL :
       Res = zisAnyRealString (Tstfun->TstFunInput) ;
       break ;

    default:
       Err = TRUE ;
       WinAlarm(HWND_DESKTOP, WA_ERROR) ;
       break ;
  }

  if (!Err)
  {
    if (Res)
    {
      WinAlarm(HWND_DESKTOP, WA_NOTE) ;
      cwCheckDlgItem(hWndDlg, TSTFUNTRURDB, TRUE) ;
      cwCheckDlgItem(hWndDlg, TSTFUNFALRDB, FALSE) ;
    }
    else
    {
      WinAlarm(HWND_DESKTOP, WA_WARNING) ;
      cwCheckDlgItem(hWndDlg, TSTFUNFALRDB, TRUE) ;
      cwCheckDlgItem(hWndDlg, TSTFUNTRURDB, FALSE) ;
    }
  }
}

