/*     
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Header   : CHKFUN.C
**  Authors  : Alessandro Cavallini (CAVALLI at ROMEPPC)
**             Pino Venturella (VENTUREL at ROMEPPC)
**  Reviewer : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 08 Jul 1992
**  Updated  : 31 Aug 1993
**  Version  : 3.12
**  Content  : Sample program for FMZISFUN.DLL
**
*/
 #define EXTERN
 #include <chkfun.h>
 #include <zzzlogo.h>

/* ------------------------------------------------------------------------ */

/*
**  Presentation Manager Program Main Body
**
**  The following routine is the Presentation Manager program Main Body.
**  The Main Body of a PM program is concerned with associating the
**  application with the Presentation Manager system, creating its
**  message queue, registering and displaying its main window, servicing
**  its message queue during the time that the application is active,
**  and disassociating the application from PM when the user is finished
**  with the application. The remaining parts of this source module that
**  are concerned with the Presentation Manager are the application's
**  window procedures (main window procedure, child window procedures,
**  and dialog window procedures) that process the messages associated
**  with the application's various windows.
**
*/
 int main(int argc, char *argv[])
 {
   QMSG qmsg ;  // MSG structure to store your messages
   PID  pid ;   // Process identifier for adding name to switch list
   TID  tid ;   // Thread identifier

   static CHAR szTitle[22] ;

   argc = argc ; // Suppress compiler warning - can remove if argc and argv
   argv = argv ; // are referenced by user-supplied code.

   /*
   **  The WinInitialize routine initializes the Presentation Manager
   **  facilities for use by this application and returns a handle to the
   **  anchor block assigned to the application by PM.
   */
    if ((hAB = WinInitialize(0)) == 0) return(FALSE) ;

   /*
   **  The WinCreateMsgQueue call creates a message queue for this application
   */
    if ((hMQ = WinCreateMsgQueue(hAB, 0)) == 0) return(FALSE) ;

   /*
   **  The following function registers the classes of all application windows
   */
    if (!cwRegisterClass()) return(FALSE) ;

   /*
   **  The CreateWindow function creates a frame window for this application's
   **  top window, and set the window's size and location as appropriate.
   */
    WinLoadString(hAB, 0, IDS_TITLE, 22, szTitle) ;
    hWndFrame = cwCreateWindow( (HWND)HWND_DESKTOP,
                                FCF_TITLEBAR     |
                                FCF_SYSMENU      |
                                FCF_MINBUTTON    |
                                FCF_MAXBUTTON    |
                                FCF_SIZEBORDER   |
                                FCF_MENU         |
                                FCF_ACCELTABLE   |
                                FCF_SHELLPOSITION,
                                szAppName,
                                szTitle,
                                ID_CHKFUN,
                                130, 124,
                                144, 34,
                                &hWndClient,
                                0L, SWP_SHOW) ;

    if (hWndFrame == 0) return(FALSE) ;

   /*
   **  The following inline routine fills out the application's switch control
   **  structure with the appropriate information to add the application's
   **  name to the OS/2 Task Manager List, a list of the jobs currently
   **  running on the computer.
   */
    WinQueryWindowProcess(hWndFrame, &pid, &tid) ;

    Swctl.hwnd = hWndFrame ;                         // Frame window handle
    Swctl.idProcess = pid ;                          // Process identifier
    Swctl.uchVisibility = SWL_VISIBLE ;              // visibility
    Swctl.fbJump = SWL_JUMPABLE ;                    // Jump indicator
    strcpy(Swctl.szSwtitle, szTitle) ;               // Frame window title

    hSwitch = WinAddSwitchEntry(&Swctl) ;

   /*
   ** The following is the message loop for the application.
   */
    while(WinGetMsg(hAB, (PQMSG)&qmsg, 0, 0, 0))
    {
      WinDispatchMsg(hAB,(PQMSG)&qmsg) ;
    }

   /*
   **  Perform clean up before exiting application.
   **  The following routine destroys the application's frame window (which
   **  also destroys its child windows), destroys its message queue, and
   **  disassociates the application from the Presentation Manager system.
   */
    WinDestroyWindow(hWndFrame) ; // Destroy the frame window
    WinDestroyMsgQueue(hMQ) ;     // Destroy this application's message queue
    WinTerminate(hAB) ;           // Terminate this application's use of the
                                  // Presentation Manager resources
 }

/* ------------------------------------------------------------------------ */

/*
**  Main Window Procedure
**
**  This procedure provides service routines for the general PM events
**  (messages) that PM sends to the window, as well as the user
**  initiated events (messages) that are generated when the user selects
**  the action bar and pulldown menu controls or the corresponding
**  keyboard accelerators.
**
**  The SWITCH statement shown below distributes the window messages to
**  the respective message service routines, which are set apart by the
**  CASE statements. The window procedures must provide an appropriate
**  service routine for its end user initiated messages, as well as the
**  general PM messages (like the WM_CLOSE message). If a message is
**  sent to this procedure for which there is no programmed CASE clause
**  (i.e., no service routine), the message is defaulted to the
**  WinDefWindowProc function, where it is disposed of by PM.
**
*/
 MRESULT EXPENTRY WndProc
 (
   HWND   hWnd    , // Window handle
   ULONG  message , // Message
   MPARAM mp1     , // First parameter of message
   MPARAM mp2       // Second parameter of message
 )
 {
   HPS hPS ;        // Handle for the Presentation Space
   RECTL rClient ;  // Handle to rectangle formed by client area

   switch (message)
   {
     case WM_INITMENU :
          break ;

     case WM_MENUEND :
          break ;

     case WM_COMMAND :
          {
           /*
           **  The PM messages for action bar and pulldown menu items are
           **  processed in this routine.
           */
            switch (SHORT1FROMMP(mp1))
            {
              case IDM_T_START :
                   {
                    /*
                    **  The code below makes a call to the dialog box named
                    **  "TSTFUN". Variable rc will receive the
                    **  return code sent when the dialog box is closed.
                    */
                     APIRET rc ;

                     rc = WinDlgBox(HWND_DESKTOP, hWnd, (PFNWP)TSTFUNMsgProc,
                                    0, IDLG_TSTFUN, (PVOID)&hWnd) ;
                    }
                    break ;

              case IDM_T_ABOUT :
                   {
                     /*
                     **  Place User Code to respond to the
                     **  Menu Item Named "~About" here.
                     */
                      #include "TSTABOUT.INC"
                    }
                    break ;

              case IDM_T_EXIT :
                   {
                     /*
                     ** Place User Code to respond to the
                     ** Menu Item Named "E~xit" here.
                     */
                      #include "TSTEXITW.INC"
                    }
                    break ;

             default:
                    break ; // End of default case for switch (mp1)
            } // End of switch mp1
          }
          break ; // End of WM_COMMAND

     case WM_CREATE :
          {
           /*
           **  The WM_CREATE message is sent to a window when an application
           **  requests that the window be created.  The window procedure
           **  for the new window receives this message after the window is
           **  created, but before the window becomes visible.
           */
            cwSetInitDlgStatus(hWnd) ;
          }
          break ;

     case WM_MOUSEMOVE :
          {
            return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
          }
          break ;

     case WM_SIZE :     // Code for sizing client area
          break ;

     case WM_PAINT :    // Code for the window's client area
          {
           /*
           **  Obtain a handle to a cache presentation space
           */
            hPS = WinBeginPaint(hWnd, 0, 0) ;

           /*
           **  Determine the size of the client area
           */
            WinQueryWindowRect(hWnd, &rClient) ;

           /*
           **  Fill the background with the default background color
           */
            WinFillRect(hPS, &rClient, CLR_BACKGROUND) ;

           /*
           **  Return presentation space to state before WinBeginPaint
           */
            WinEndPaint(hPS) ;
          }
          break ;

     case WM_CLOSE :  // Close the window
          {
            if(hWnd != hWndClient) break ;

            #include "TSTCLOSE.INC"

            cwFreeDlgMemory(hWnd) ;
            return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
          }
          break ;

     case WM_TRANSLATEACCEL :
          {
            return(WinDefWindowProc(hWndClient, message, mp1, mp2)) ;
          }
          break ;

     default:
          {
           /*
           **  For any message for which you don't specifically provide a
           **  service routine, you should return the message to PM using
           **  the WinDefWindowProc function.
           */
            return(WinDefWindowProc(hWnd, message, mp1, mp2)) ;
          }
          break ;
   } // End of switch

   return(0L) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  Dialog Window Procedure
**
**  This procedure is associated with the dialog box that is included in
**  the function name of the procedure. It provides the service routines
**  for the events (messages) that occur because the end user operates
**  one of the dialog box's buttons, entry fields, or controls.
**
**  The SWITCH statement in the function distributes the dialog box
**  messages to the respective service routines, which are set apart by
**  the CASE clauses. Like any other PM window, the Dialog Window
**  procedures must provide an appropriate service routine for their end
**  user initiated messages as well as for the general PM messages (like
**  the WM_CLOSE message). If a message is sent to this procedure for
**  which there is no programmed CASE condition (no service routine),
**  the message is defaulted to the WinDefDlgProc function, where it is
**  disposed of by PM.
**
*/
 MRESULT EXPENTRY TSTFUNMsgProc
 (
   HWND   hWndDlg , // Dialog handle
   ULONG  message , // Message
   MPARAM mp1     , // First parameter of message
   MPARAM mp2       // Second parameter of message
 )
 {
   static HWND  hWndParent ;
   TSTFUNStruct *Tstfun ;

   switch (message)
   {
     case WM_INITDLG :
     {
       int i ; // loop counter

       Tstfun = (TSTFUNStruct *)WinQueryWindowULong(hWndClient, OFFSET_TSTFUN) ;
       hWndParent = *((HWND *)mp2) ;

       cwCenter(hWndDlg, (HWND)hWndParent) ;

      /*
      ** Initialize entry field control: TstFunInput
      */
       WinSendDlgItemMsg (hWndDlg, TSTFUNINPFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
       Tstfun->TstFunInput[0] = 0 ;

      /*
      **  Initialize all the other controls
      */
       #include "TSTINIT.INC"
     }
     break ; // End of WM_INITDLG

     case WM_CONTROL :
     {
       switch (SHORT1FROMMP(mp1))
       {
         case TSTFUNTRURDB: // Radiobutton text: "True"
         {
           cwCheckDlgItem(hWndDlg, TSTFUNFALRDB, FALSE) ;
         }
         break ;

         case TSTFUNFALRDB: // Radiobutton text: "False"
         {
           cwCheckDlgItem(hWndDlg, TSTFUNTRURDB, FALSE) ;
         }
         break ;

         case TSTFUNTYPDDL: // Entry field and combo box list: "TstFunType"
         {
           switch (SHORT2FROMMP(mp1)) // Switch on Notification Code
           {
             case CBN_EFCHANGE:
                  {
                    #include "TSTTYPE.INC"
                  }
                  break ;

             default: // Default other messages
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;

         case TSTFUNNOTDDL: // Entry field and combo box: "TstFunNotation"
         {
           switch (SHORT2FROMMP(mp1)) // Switch on Notification Code
           {
             case CBN_EFCHANGE:
                  {
                    #include "TSTNOTAT.INC"
                  }
                  break ;


             default: // Default other messages
                  return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
                  break ;
           }
         }
         break ;

         case TSTFUNINPFLD: // Entry field variable: "TstFunInput"
         {
           switch (SHORT2FROMMP(mp1)) // Switch on Notification Code
           {
             case EN_SETFOCUS:  // Entry field is receiving the focus
                  #include "TSTINPUT.INC"
                  break ;

             case EN_KILLFOCUS: // Entry field is losing the focus
                  break ;
           }
         }
         break ;

         case TSTFUNSMPFLD: // Entry field variable: "TstFunSample"
         {
           switch (SHORT2FROMMP(mp1)) // Sswitch on Notification Code
           {
             case EN_SETFOCUS:  // Entry field is receiving the focus
                  break ;

             case EN_KILLFOCUS: // Entry field is losing the focus
                  break ;
           }
         }
         break ;
       }
     }
     break ; // End of WM_CONTROL

     case WM_COMMAND:
     {
       switch (SHORT1FROMMP(mp1))
       {
         case TSTFUNCHKBUT: // Button text: "~Check value "
              #include "TSTCHECK.INC"
              break ;

         case TSTFUNEXIBUT: // Button text: "E~xit"
              #include "TSTEXIT.INC"
              break ;
       }
     }
     break ; // End of WM_COMMAND

     case WM_CLOSE:
          WinDismissDlg(hWndDlg, FALSE) ;
          break ; // End of WM_CLOSE

     case WM_FAILEDVALIDATE:
          return((MRESULT)TRUE) ;
          break ;

     default:
          return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
          break ;
   }
   return FALSE ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwRegisterClass Function
**
**  The following function registers all the classes of all the windows
**  associated with this application. The function returns TRUE if it is
**  successful, otherwise it returns FALSE.
**
*/
 INT cwRegisterClass(VOID)
 {
   APIRET rc ;

   WinLoadString(hAB, 0, IDS_APP_NAME, 80, szAppName) ; // Program name

   rc = WinRegisterClass (hAB,              // Anchor block handle
                          (PCH)szAppName,   // Name of class being registered
                          (PFNWP)WndProc,   // Window procedure for class
                          CS_SIZEREDRAW ,
                          1*sizeof(char*)) ;
   if (rc == FALSE) return(FALSE) ;

   return(TRUE) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCreateWindow Function
**
**  The following function is used to create a window (the main window,
**  a child window, an icon window, etc.) and set it's initial size and
**  position. It returns the handle to the frame window.
**
*/
 HWND cwCreateWindow
 (
   HWND   hWndParent,  // Handle to the parent of the window to be created
   ULONG  ctldata,     // Frame control flags for the window
   PCH    appname,     // Class name of the window
   PCH    title,       // Title of the window
   ULONG  ResID,       // Resource id value
   INT    x,           // Initial horizontal and vertical location
   INT    y,           //
   INT    cx,          // Initial width and height of the window
   INT    cy,          //
   PHWND  hWndClient,  // Handle to the client area of the window
   ULONG  lfStyle,     // Frame window style
   USHORT uSizeStyle   // User defined size and location flags
 )
 {
   ULONG  rc ;            // Accepts return codes from function calls
   HWND   hWndFrame ;     // Local handle to created window frame
   ULONG  SizeStyle ;     // Local window positioning options
   CHAR   MsgBuffer[80] ; // Buffer for error messages
   HPS    hPS ;           // Handle to a presentation space
   int    xmod, ymod ;    // Modifiers for sizing
   #define DLGXMOD  4     // Dialog units X modulo
   #define DLGYMOD  8     // Dialog units Y modulo
   FONTMETRICS fm ;       // Structure for determing modifiers

  /*
  **  Create the frame window
  */
   hWndFrame = WinCreateStdWindow(hWndParent,  // Parent of window
                                  lfStyle,     // Frame window style
                                  &ctldata,    // Frame flags
                                  appname,     // Class name
                                  title,       // Window title
                                  0L,          // Client window style
                                  0,           // Module for resources
                                  ResID,       // Resource id
                                  (HWND *)hWndClient) ; // Client handle

  /*
  **  If hWndFrame is NULL, an error occured when opening the window,
  **  notify the user and exit this function
  */
   if(hWndFrame == 0)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_CREATE, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return ((HWND)0) ;
   }

  /*
  **  Set up size options
  */
   SizeStyle = SWP_ACTIVATE | SWP_ZORDER | uSizeStyle ;

  /*
  **  If the height, width, intial x or initial y values are non-zero,
  **  then we will need to set up the modifiers for size and location
  */
   if((cx > 0) || (cy > 0) || (x != 0)  || (y != 0))
   {
     hPS = WinGetPS(HWND_DESKTOP) ;
     GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm) ;
     xmod = (INT)fm.lAveCharWidth ;
     ymod = (INT)fm.lMaxBaselineExt ;
     WinReleasePS(hPS) ;
   }

  /*
  **  If either the width or the height are non-zero, then the size of the
  **  created window will be changed, set SizeStyle accordingly
  */
   if((cx > 0) || (cy > 0) || (x != 0) || (y != 0))
   {
     SizeStyle |= SWP_SIZE ;
     SizeStyle |= SWP_MOVE ;
   }

  /*
  **  Set the size and position of the window and activate it
  */
   rc = WinSetWindowPos(hWndFrame, HWND_TOP,
                        ((x * xmod)/DLGXMOD),
                        ((y * ymod)/DLGYMOD),
                        ((cx * xmod)/DLGXMOD),
                        ((cy * ymod)/DLGYMOD), SizeStyle) ;

  /*
  **  If rc is not set to TRUE then WinSetWindowPos failed, notify the user
  **  and exit this function
  */
   if(!rc)
   {
     WinLoadString(hAB, 0, IDS_ERR_WINDOW_POS, 80, MsgBuffer) ;
     WinMessageBox(HWND_DESKTOP, hWndParent, MsgBuffer,
                   0, 0, MB_OK|MB_ICONEXCLAMATION) ;
     return((HWND)0) ;
   }

  /*
  **  Return the handle to the frame window
  */
   return(hWndFrame) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  cwCenter Function
**
**  Centers a dialog box on the client area of the caller
**
**  hWnd       - handle of the window to be centered
**  hWndParent - handle of the window on which to center
**
*/
 INT cwCenter
 (
   HWND hWnd       ,
   HWND hWndParent
 )
 {
   LONG   SrcX, SrcY ;                // Center of parent
   LONG   x, y ;                      // Destination points
   SWP    DlgSwp, ParentSwp ;         // Set window position structures
   LONG   ScreenWidth, ScreenHeight ; // Dimensions of the DESKTOP
   POINTL pt ;                        // Point

  /*
  **  Determine the width and height of the DESKTOP so the dialog box
  **  will not be positioned to a point off of the screen.
  */
   ScreenWidth  = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) ;
   ScreenHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) ;

  /*
  **  Query width and depth of dialog box
  */
   WinQueryWindowPos(hWnd, (PSWP)&DlgSwp) ;

  /*
  **  Query width and depth of caller
  */
   WinQueryWindowPos(hWndParent, (PSWP)&ParentSwp) ;

  /*
  **  Map the point parent points to the Desktop
  */
   pt.x = ParentSwp.x ;
   pt.y = ParentSwp.y ;

  /*
  **  Convert the point from having our window as the origin to having
  **  the DESKTOP as the origin
  */
   WinMapWindowPoints(hWndParent, HWND_DESKTOP, &pt, 1) ;

   SrcX = pt.x + (ParentSwp.cx / 2) ;
   SrcY = pt.y + (ParentSwp.cy / 2) ;

  /*
  **  Determine the point to move the dialog box to
  */
   x = (SrcX - (DlgSwp.cx / 2)) ;
   y = (SrcY - (DlgSwp.cy / 2)) ;

  /*
  **  If either point is less than zero, then set that point to zero
  **  so the dialog box will not be positoned off of the window
  */
   x = (x < 0L) ? 0L : x ;
   y = (y < 0L) ? 0L : y ;

  /*
  **  If either point plus the height or width of the dialog box is
  **  greater than the height or width of the screen adjust point
  */
   if ((x + DlgSwp.cx) > ScreenWidth)  x = ScreenWidth - DlgSwp.cx ;
   if ((y + DlgSwp.cy) > ScreenHeight) y = ScreenHeight - DlgSwp.cy ;

  /*
  **  Move the dialog box
  */
   return(WinSetWindowPos(hWnd, HWND_TOP, x, y, 0, 0, SWP_MOVE)) ;
 }

/* ------------------------------------------------------------------------ */

/*
**  This function allocates memory for dialog box variables and initializes
**  the state of any initially selected radio buttons and check boxes.
*/
 INT cwSetInitDlgStatus(HWND hWnd)
 {
   TSTFUNStruct *Tstfun ;

   OFFSETOF(Tstfun) = 0 ;
   DosAllocMem(((PPVOID)&Tstfun), sizeof(TSTFUNStruct), fALLOC) ;
   memset(Tstfun, 0x00, sizeof(TSTFUNStruct)) ;
   WinSetWindowULong(hWnd, OFFSET_TSTFUN, (ULONG)Tstfun) ;

  return(0) ;
 }

/* ------------------------------------------------------------------------ */

 INT cwFreeDlgMemory(HWND hWnd)
 {
   TSTFUNStruct *Tstfun ;

   Tstfun = (TSTFUNStruct *)WinQueryWindowULong(hWnd, OFFSET_TSTFUN) ;
   DosFreeMem((PVOID)(Tstfun)) ;

   return(0) ;
 }

/* ------------------------------------------------------------------------ */

 void lmemset(void FAR *memptr, CHAR value, INT size)
 {
   char FAR *chrptr = memptr ;

   while (size--) *chrptr++ = value ;
 }

/* ------------------------------------------------------------------------ */

 LONG cwCheckDlgItem(HWND hWndDlg, LONG id, LONG state)
 {
  return((INT)(ULONG)WinSendDlgItemMsg (hWndDlg, id, BM_SETCHECK,
                                        MPFROMLONG(state), 0L)) ;
 }

/* ------------------------------------------------------------------------ */

