/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Include : TSTSLIDR.INC
**  Author  : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 21 Sep 1992
**  Updated : 20 Sep 1993
**  Version : 4.12
**  Content : Called in WM_CONTROL (case TMEZONOFFSLD)
**
*/
 {
   CHAR szWorkBuf[12] ; // Local scratch memory

   switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
   {
     case SLN_CHANGE :       // Changed position (cursor)
     case SLN_SLIDERTRACK :  // Continuos dragging
          {
            MPARAM mp  ;

            Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEZON) ;

           /*
           **  Avoid looping between slider TMEZONOFFSLD and field TMEZONOFFFLD
           */
            if (! Tmezon->fromField)
            {
              mp = WinSendDlgItemMsg(hWndDlg, TMEZONOFFSLD,
                                     SLM_QUERYSLIDERINFO,
                                     MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                                     SMA_INCREMENTVALUE),
                                     0L) ;

              Tmezon->TmeZonOffset = (ULONG)(SHORT1FROMMP(mp) - 12) ;

              _ltoa(Tmezon->TmeZonOffset, szWorkBuf, 10) ;

              Tmezon->fromSlider = TRUE ;  // Message to FIELD from SLIDER
              WinSetDlgItemText(hWndDlg, TMEZONOFFFLD, szWorkBuf) ;
              Tmezon->fromSlider = FALSE ; // Reset flag                   
            }
            else
            {
              return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
            }
          }
          break ;

     default :                // Default other messages
          return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
          break ;
   }
 }
