/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Include : TSTFIELD.INC
**  Author  : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 21 Sep 1992
**  Updated : 20 Sep 1993
**  Version : 4.12
**  Content : Called in WM_CONTROL (case TMEZONOFFFLD)
**
*/
 {
   switch(SHORT2FROMMP(mp1)) // Switch on Notification Code
   {
    case EN_CHANGE :    // Entry field is changed
         {
           CHAR   *cursor       ; // Cursor for field validation
           USHORT  result       ; // Result from number validation
           LONG    offset       ;
           CHAR    szWorkBuf[5] ; // Local scratch memory

           Tmezon = (TMEZONStruct *)WinQueryWindowULong(hWndClient, OFFSET_TMEZON) ;

          /*
          **  Avoid looping between slider TMEZONOFFSLD and field TMEZONOFFFLD
          */
           if (! Tmezon->fromSlider)
           {
             WinQueryDlgItemText(hWndDlg, TMEZONOFFFLD, 5, szWorkBuf) ;

            /*
            **  Check field. There are three possible results:
            **
            **  tstVALID       Valid number
            **  tstPARTIAL     Partial number (space, sign only)
            **  tstOUTOFRANGE  Number is out of range
            **  tstNOTANUMBER  String is not a number
            */
             result = tstCheckNumber(szWorkBuf, &offset, -12, 12) ;

             switch (result)
             {
               case tstVALID:
               {
                 Tmezon->TmeZonOffset = offset ;

                 Tmezon->fromField = TRUE ;  // Message to SLIDER from FIELD

                 WinSendDlgItemMsg(hWndDlg, TMEZONOFFSLD,
                                   SLM_SETSLIDERINFO,
                                   MPFROM2SHORT(SMA_SLIDERARMPOSITION,
                                   SMA_INCREMENTVALUE),
                                   MPFROMSHORT(Tmezon->TmeZonOffset+12)) ;

                 Tmezon->fromField = FALSE ; // Reset flag
               }
               break;

               case tstOUTOFRANGE:
               {
                 char szMsgBuffer[80] ;

                 WinLoadString(hAB, 0, tstERR_INVALIDZONE, 80, szMsgBuffer) ;
                 WinMessageBox(HWND_DESKTOP, hWndParent, szMsgBuffer,
                               0, 0, MB_OK|MB_ICONEXCLAMATION) ;
               }
               break;

               case tstNOTANUMBER:
               {
                 char szMsgBuffer[80] ;

                 WinLoadString(hAB, 0, tstERR_NOTANUMBER, 80, szMsgBuffer) ;
                 WinMessageBox(HWND_DESKTOP, hWndParent, szMsgBuffer,
                               0, 0, MB_OK|MB_ICONEXCLAMATION) ;
               }
               break;

               default: // tstPARTIAL
               {
                 return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
               }
               break;
             }
           }
           else
           {
             return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
           }
         }
         break ;

    default :           // Default other messages
         return(WinDefDlgProc(hWndDlg, message, mp1, mp2)) ;
         break ;
   }
 }
