/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Include : TSTCHECK.INC
**  Authors : Alessandro Cavallini (CAVALLI at ROMEPPC)
**            Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 21 Jul 1992
**  Updated : 01 Sep 1993
**  Version : 4.12
**  Content : Called in WM_COMMAND (case CHKDTECHKBUT)
**
*/
{
  CHAR szDay[3]   ; // Input day of month
  CHAR szMonth[3] ; // Input month of year
  CHAR szYear[5]  ; // Input year (long format)
  CHAR *any ;       // Scratch pointer

  CHAR szTemp[tstMAXSTRLEN] ; // Local scratch memory

  zdtDATE date ;    // Input date

 /*
 **  Get the address of the variable connected to the Dialog
 */
  Chkdte = (CHKDTEStruct *)WinQueryWindowULong(hWndClient, OFFSET_CHKDTE) ;

 /*
 **  Query the string value in the entry field controls and
 **  move the string value to the dialog structure variables
 */
  WinQueryDlgItemText(hWndDlg, CHKDTEDAYFLD, sizeof(szDay), szDay ) ;
  Chkdte->ChkDteDay = atol(szDay) ;

  WinQueryDlgItemText(hWndDlg, CHKDTEMTHFLD, sizeof(szMonth), szMonth ) ;
  Chkdte->ChkDteMonth = atol(szMonth) ;

  WinQueryDlgItemText(hWndDlg, CHKDTEYEAFLD, sizeof(szYear), szYear ) ;
  Chkdte->ChkDteYear = atol(szYear) ;

 /*
 **  Compute output values
 */
  date = zdtNewDate ( (zdtYEAR) (Chkdte->ChkDteYear ) ,
                      (zdtMONTH)(Chkdte->ChkDteMonth) ,
                      (zdtDAY)  (Chkdte->ChkDteDay  )) ;

  if (date == zdtINVALID)
  {
    WinLoadString(hAB, 0, tstERR_INVALIDDATE, tstMAXSTRLEN, szTemp) ;
    WinMessageBox(HWND_DESKTOP,
                  HWND_DESKTOP,
                  szTemp, 0, 0,
                  MB_OK|MB_ERROR) ;

   /*
   **  Let's clear all output fields
   */
    #include "TSTCLEAR.INC"
  }
  else
  {
    any = zdtWeekdayName(date, Chkdte->ChkDteWeekday) ;
    any = zdtMonthName(date, Chkdte->ChkDteMonthName) ;
    Chkdte->ChkDteDayInYear  = (long)zdtDayOfYear(date) ;
    Chkdte->ChkDteJulianDate = (long)zdtAsJulian(date) ;
    Chkdte->ChkDteWeekOfYear = (long)zdtWeekOfYear(date) ;

    if (zdtIsLeapYear(zdtYear(date)))
    {
      Chkdte->ChkDteLeapYear = 1 ;
    }
    else
    {
      Chkdte->ChkDteLeapYear = 0 ;
    }

   /*
   **  Display output values
   */
    WinSendDlgItemMsg(hWndDlg, CHKDTEWKDFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
    if (Chkdte->ChkDteWeekday[0])
      WinSetDlgItemText(hWndDlg, CHKDTEWKDFLD, Chkdte->ChkDteWeekday) ;

    WinSendDlgItemMsg(hWndDlg, CHKDTEMTNFLD, EM_SETTEXTLIMIT, MPFROMSHORT(32), 0L) ;
    if (Chkdte->ChkDteMonthName[0])
      WinSetDlgItemText(hWndDlg, CHKDTEMTNFLD, Chkdte->ChkDteMonthName) ;

    if (Chkdte->ChkDteDayInYear != 0)
    {
      _ltoa(Chkdte->ChkDteDayInYear, szTemp, 10) ;
      WinSetDlgItemText(hWndDlg, CHKDTEDIYFLD, szTemp) ;
    }

    if (Chkdte->ChkDteJulianDate != 0)
    {
      sprintf(szTemp,"%05ld",Chkdte->ChkDteJulianDate) ;
      WinSetDlgItemText(hWndDlg, CHKDTEJULFLD, szTemp) ;
    }

    if (Chkdte->ChkDteWeekOfYear != 0)
    {
      _ltoa(Chkdte->ChkDteWeekOfYear, szTemp, 10) ;
      WinSetDlgItemText(hWndDlg, CHKDTEWEKFLD, szTemp) ;
    }

    WinSendDlgItemMsg(hWndDlg, CHKDTELPYCHK, BM_SETCHECK,
      MPFROMSHORT(Chkdte->ChkDteLeapYear), 0L);
  }
}
