/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** \----------------------------------------------------------------------/
**
**  Header   : ZDTTYPES.H
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 03 Jul 1992
**  Updated  : 01 Sep 1993 
**  Version  : 4.12        
**  Content  : Date & Time Services types
**
*/
 #ifndef zdtTYPES
 #define zdtTYPES 0

/*
**  Types
*/
 typedef USHORT zdtSTRID   ; // String identifier

 typedef LONG   zdtDATE    ; // Number of days since Jan 1st, 1970
 typedef LONG   zdtDAYS    ; // Any number of days

 typedef LONG   zdtDAY     ; // Day of month
 typedef LONG   zdtYEAR    ; // Year belonging to zdtBASEYEAR..zdtLASTYEAR
 typedef LONG   zdtMONTH   ; // Month
 typedef LONG   zdtWEEK    ; // Week of the year
 typedef LONG   zdtWEEKDAY ; // Day of week

 typedef LONG   zdtTIME    ; // Number of seconds since midnight
 typedef LONG   zdtHOURS   ; // Hours of time
 typedef LONG   zdtMINUTES ; // Minutes of time
 typedef LONG   zdtSECONDS ; // Seconds of time
 typedef SHORT  zdtZONE    ; // Offset with respect GMT (in minutes)

/*
**  Types (structures)
*/
 typedef struct zdtLocalDateTime
 {
   zdtDATE date ;  // Date
   zdtTIME time ;  // Time
   zdtZONE zone ;  // Timezone (with respect GMT)
 }
 zdtLOCALDT ;

/*
**  Supported languages
*/
 typedef LONG zdtLANGUAGE ;  // languages

 #endif
