/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
** Header      : TSTFUNCS.C
** Author      : Dario de Judicibus (DEJUDICI at ROMEPPC)
** Created     : 1 Oct 1992
** Reviewed    : 2 Oct 1992
** Version     : 1.00
** Content     : Sample program functions (select file)
** Environment : OS/2 Version 2.X
*/
 #define EXTERN
 #define INCL_PM
 #define INCL_DOSPROCESS
 #define INCL_WINSTDFILE
 
 #include <os2.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <ctype.h>
 #include <process.h>

 #include <tstall.h>

/*------------------------------------------------------------------------*/

/*
**  Function : SelectFileFromDlg
**  Author   : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**             Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 24 Sep 1992
**  Updated  : 02 Oct 1992
**  Version  : 1.00
**  Content  : Select file from dialog box
**
*/
 BOOL EXPENTRY SelectFileFromDlg
 (
   HWND * phwndParent      ,    // Pointer to parent window
   PSZ    pszSelectedFile  ,    // Path and name of selected file
   PSZ    pszTemplate           // Selection template (filter)
 )
 {
  FILEDLG pfdFiledlg ;            // File dialog info structure

  CHAR szTitle[tstMAXSTRLEN] ;    // Title of dialog
  CHAR szButton[tstMAXSTRLEN] ;   // Text of SELECT button

  SHORT i ;

  HAB hAB ;
  HWND hwndParent, hwndDlg ;

 /*
 ** Set fields to 0
 */
  memset(&pfdFiledlg, 0, sizeof(FILEDLG)) ;

  hwndParent = *phwndParent ;

 /*
 ** Load title and button strings
 */
  hAB = WinQueryAnchorBlock(hwndParent) ;
  WinLoadString(hAB, 0, tstSTR_SELFILTITLE , tstMAXSTRLEN, szTitle ) ;
  WinLoadString(hAB, 0, tstSTR_SELFILBUTTON, tstMAXSTRLEN, szButton) ;

 /*
 ** Initialize structure fields
 */

  pfdFiledlg.cbSize = sizeof(FILEDLG) ;
  pfdFiledlg.fl = FDS_HELPBUTTON | FDS_CENTER | FDS_OPEN_DIALOG ;
  pfdFiledlg.pfnDlgProc = (PFNWP)OpenSaveFilterDlgProc ;
  pfdFiledlg.pszOKButton = szButton ;
  pfdFiledlg.pszTitle = szTitle ;
  pfdFiledlg.ulUser = 0L ;
  pfdFiledlg.lReturn = 0L ;
  pfdFiledlg.lSRC = 0L ;
  pfdFiledlg.hMod = 0 ;
  pfdFiledlg.usDlgId = 0 ;
  pfdFiledlg.x = 0 ;
  pfdFiledlg.y = 0 ;

  strcpy(pfdFiledlg.szFullFile, pszTemplate) ;

  pfdFiledlg.pszIType        = (PSZ)NULL ;
  pfdFiledlg.papszITypeList  = (PAPSZ)NULL ;
  pfdFiledlg.pszIDrive       = (PSZ)NULL ;
  pfdFiledlg.papszIDriveList = (PAPSZ)NULL ;
  pfdFiledlg.sEAType         = (SHORT)0 ;
  pfdFiledlg.papszFQFilename = (PAPSZ)NULL ;
  pfdFiledlg.ulFQFCount      = 0L ;

 /*
 ** Display dialog and get the files
 */
  hwndDlg = WinFileDlg(HWND_DESKTOP, hwndParent, &pfdFiledlg) ;

  if(hwndDlg && (pfdFiledlg.lReturn == DID_OK))
  {
    strcpy(pszSelectedFile , pfdFiledlg.szFullFile) ;
  }

 }

/*------------------------------------------------------------------------*/

/*
**  Function : OpenSaveFilterProc
**  Author   : Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created  : 24 Sep 1992
**  Updated  : 02 Oct 1992
**  Version  : 1.00
**
*/
 MRESULT APIENTRY OpenSaveFilterDlgProc
 (
   HWND hwnd, 
   ULONG msg,
   MPARAM mp1, 
   MPARAM mp2
 )
 {
   return WinDefFileDlgProc( hwnd, msg, mp1, mp2 ) ;
 }

/*------------------------------------------------------------------------*/
