/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Include    : TSTCVSTR.INC
**  Authors    : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**               Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created    : 28 Aug 1992
**  Updated    : 24 Sep 1993
**  Version    : 2.12
**  Content    : Include file for test program
*/
{
  int i ;
  BOOL done ;
  zcvTABLE ChrStrTable ;
  CHAR szWorkBuf[tstSTRINGLEN] ; // local scratch memory

  CHAR InChrStr[tstSTRINGLEN] ,
       OutChrStr[tstSTRINGLEN] ;

  zcvCCSID SourceCCSID ,
           TargetCCSID ;

  Xltstr = (XLTSTRStruct *)WinQueryWindowULong(hWndClient, OFFSET_XLTSTR) ;

 /*
 **  Initialize OutChrStr string as a null string
 */
  memset(OutChrStr,'\0',sizeof(OutChrStr)) ;

 /*
 **  Query the string values in the entry field controls and
 **  move the string values to the dialog structure variables
 */
  WinQueryDlgItemText(hWndDlg, XLTSTRSSTMLE, tstSTRINGLEN, szWorkBuf) ;
  strcpy(Xltstr->XltStrSourceString, szWorkBuf) ;

  WinQueryDlgItemText(hWndDlg, XLTSTRSCPFLD,   7, szWorkBuf) ;
  strcpy(Xltstr->XltStrSourceCP, szWorkBuf) ;

  WinQueryDlgItemText(hWndDlg, XLTSTRTCPDDL,   7, szWorkBuf) ;
  strcpy(Xltstr->XltStrTargetCP, szWorkBuf) ;

  SourceCCSID = atol(Xltstr->XltStrSourceCP) ;
  TargetCCSID = atol(Xltstr->XltStrTargetCP) ;

 /*
 **  Initialize char stream conversion table
 */
  done = FALSE ;
  if(zcvAllocTable(&ChrStrTable))
  {
   /*
   **  Make char stream conversion table
   */
    if(zcvMakeTable(ChrStrTable, SourceCCSID, TargetCCSID))
    {
     /*
     **  Convert char stream
     */
      if(zcvConvertCharStream(Xltstr->XltStrSourceString,
                              (zcvSTREAM)OutChrStr,
                              zcvNULLTERM,
                              ChrStrTable))
        done = TRUE ;
      {
        ULONG icon ;
        CHAR title[tstMAXSTRLEN] ;
        CHAR msg[tstMAXSTRLEN] ;

     /* 
     **  Use this block of code instead of that below the commented lines
     **  if you wish the annoying message "String successfully converted"
     **  when everything is OK.
     ** 
     **  if (done)
     **  {
     **    icon = MB_INFORMATION ;
     **    WinLoadString(hAB, 0, tstSTR_INFTITLE, tstMAXSTRLEN, title) ;
     **    WinLoadString(hAB, 0, tstMSG_STRCONVERTED, tstMAXSTRLEN, msg) ;
     **  }
     **  else
     **  {
     **    icon = MB_ERROR ;
     **    WinLoadString(hAB, 0, tstSTR_ERRTITLE, tstMAXSTRLEN, title) ;
     **    WinLoadString(hAB, 0, tstERR_FILNOTCONVERTED, tstMAXSTRLEN, msg) ;
     **  }
     ** 
     **  WinMessageBox(HWND_DESKTOP, hWndDlg,
     **                msg, title,
     **                0, MB_OK|icon);
     */
        if (!done)
        {
          icon = MB_ERROR ;
          WinLoadString(hAB, 0, tstSTR_ERRTITLE, tstMAXSTRLEN, title) ;
          WinLoadString(hAB, 0, tstERR_FILNOTCONVERTED, tstMAXSTRLEN, msg) ;

          WinMessageBox(HWND_DESKTOP, hWndDlg,
                        msg, title,
                        0, MB_OK|icon) ;
        }
      }
    }
    zcvFreeTable(ChrStrTable) ;
  }

  strcpy(Xltstr->XltStrTargetString , OutChrStr) ;

 /*
 **  Display converted message: XltStrTargetString
 */
  WinSendDlgItemMsg(hWndDlg, XLTSTRTSTMLE, EM_SETTEXTLIMIT,
                    MPFROMSHORT(tstSTRINGLEN), 0L);

  if(Xltstr->XltStrTargetString[0])
    WinSetDlgItemText(hWndDlg, XLTSTRTSTMLE, Xltstr->XltStrTargetString);

  return (MRESULT)done ;
}
