/*
** /----------------------------------------------------------------------\
** |             IBM Z Family Reusable Libraries/2 (5641-504)             |
** |----------------------------------------------------------------------|
** | (C) Copyright International Business Machines Corporation 1993, 1994 |
** |----------------------------------------------------------------------|
** |                       DISCLAIMER OF WARRANTIES                       |
** |                       ------------------------                       |
** | The following code is sample code created by IBM Corporation.        |
** | Such a code is provided to you solely for the purpose of assisting   |
** | you in the development of your applications. The code is provided    |
** | "AS IS", without warranty of any kind.  IBM shall not be liable for  |
** | any damages arising out of your use of the following code, even if   |
** | they have been advised of the possibility of such damages.           |                                                                         *
** \----------------------------------------------------------------------/
**
**  Include : TSTCVFIL.INC
**  Authors : Valerio Tavazzi (TAVAZZI at ROMEPPC)
**            Dario de Judicibus (DEJUDICI at ROMEPPC)
**  Created : 31 Aug 1992
**  Updated : 24 Sep 1993
**  Version : 2.12
**  Content : Convert a file from a CCSID to another
*/
{
  BOOL done ;
  zcvTABLE FileTable ;
  CHAR szWorkBuf[tstFLPATHLEN] ; // local scratch memory

  zcvCCSID SourceCCSID ,
           TargetCCSID ;

  Xltfil = (XLTFILStruct *)WinQueryWindowULong(hWndClient, OFFSET_XLTFIL) ;

 /*
 **  Query the string value in the entry field controls and
 **  move the string values to the dialog structure variables
 */
  WinQueryDlgItemText(hWndDlg, XLTFILSFLFLD, tstFLPATHLEN, szWorkBuf) ;
  strcpy(Xltfil->XltFilSourceFile, szWorkBuf) ;

  WinQueryDlgItemText(hWndDlg, XLTFILTFLFLD, tstFLPATHLEN, szWorkBuf) ;
  strcpy(Xltfil->XltFilTargetFile, szWorkBuf) ;

  WinQueryDlgItemText(hWndDlg, XLTFILSCPDDL,  7, szWorkBuf) ;
  strcpy(Xltfil->XltFilSourceCP, szWorkBuf) ;

  WinQueryDlgItemText(hWndDlg, XLTFILTCPDDL,  7, szWorkBuf) ;
  strcpy(Xltfil->XltFilTargetCP, szWorkBuf) ;

 /*
 **  Convert strings to integers (long)
 */
  SourceCCSID = atol(Xltfil->XltFilSourceCP) ;
  TargetCCSID = atol(Xltfil->XltFilTargetCP) ;

 /*
 **  Initialize file conversion table
 */
  done = FALSE ;
  if(zcvAllocTable(&FileTable))
  {
   /*
   **  Make file conversion table
   */
    if(zcvMakeTable(FileTable, SourceCCSID, TargetCCSID))
    {
     /*
     **  Convert file
     */
      if(zcvConvertTextFile(Xltfil->XltFilSourceFile,
                            Xltfil->XltFilTargetFile,
                            0, FileTable))
      done = TRUE ;
      {
        ULONG icon ;
        CHAR title[tstMAXSTRLEN] ;
        CHAR msg[tstMAXSTRLEN] ;

        if (done)
        {
          icon = MB_INFORMATION ;
          WinLoadString(hAB, 0, tstSTR_INFTITLE, tstMAXSTRLEN, title) ;
          WinLoadString(hAB, 0, tstMSG_FILCONVERTED, tstMAXSTRLEN, szWorkBuf) ;
          sprintf(msg,szWorkBuf, Xltfil->XltFilSourceFile, Xltfil->XltFilTargetFile) ;
        }
        else
        {
          icon = MB_ERROR ;
          WinLoadString(hAB, 0, tstSTR_ERRTITLE, tstMAXSTRLEN, title) ;
          WinLoadString(hAB, 0, tstERR_FILNOTCONVERTED, tstMAXSTRLEN, szWorkBuf) ;
          sprintf(msg,szWorkBuf, Xltfil->XltFilSourceFile) ;
        }

        WinMessageBox(HWND_DESKTOP, hWndDlg,
                      msg, title,
                      0, MB_OK|icon) ;
      }
    }
    zcvFreeTable(FileTable) ;
  }
  return (MRESULT)done ;
}
