#
# /----------------------------------------------------------------------\
# |             IBM Z Family Reusable Libraries/2 (5641-504)             |
# |----------------------------------------------------------------------|
# | (C) Copyright International Business Machines Corporation 1993, 1994 |
# |----------------------------------------------------------------------|
#
#  Module    : ZCVCLONE.MAK
#  Authors   : Luca Miccoli (MICCOLI at ROMEPPC)
#  Reviewer  : Dario de Judicibus (DEJUDICI at ROMEPPC)
#  Created   : 06 Apr 1993
#  Reviewed  : 24 Sep 1993
#  Version   : 2.12
#
#  ------------------------------------------------------------------------------
#
#  NOTE : This is a SAMPLE makefile. You may need to modify it to satisfy your
#         specific needs. You may also want to include it in a larger MAKE file
#         which is used to generate your application. In any case, read carefully
#         the comments below and the "User's Guide", to understand what you can
#         change, and what should be used as is.
#  ------------------------------------------------------------------------------

#
#  User provided name of the .DLL (to be filled)
#
USRNAME = ________

STBNAME = zcvstub
INTNAME = zcvfuncs

#
#  Do not change OPTIONS unless really needed. They SHOULD match the original ones.
#
OPTIONS = /Ge- /Kb /Gd- /Gm+ /Ss /Ms /DES32TO16 /Gt /I.\ /Tx+
LINKOPT = /NOI

#
#  MAKE file generates a DLL and the corresponding IMPORT library having the
#  name specified as USRNAME above.
#
all: $(USRNAME).dll $(USRNAME).lib

#
#  STUB should be compiled by using the same options used for Z Family/2 DLL
#
$(STBNAME).obj: $(STBNAME).c
   icc /C+ $(OPTIONS) $(STBNAME).c

#
#  Use STUB and Z Family/2 OBJECT library to generate the User's Cloned DLL
#  Use $(INTNAME).def to make your $(USRNAME).def, changing the name after
#  LIBRARY (first instruction of the definition file).
#
$(USRNAME).dll: $(STBNAME).obj $(INTNAME).lib $(USRNAME).def
  link386 $(LINKOPT) $(STBNAME).obj,$(USRNAME).dll,,$(INTNAME).lib + acs.lib,$(USRNAME).def ;

#
#  Use the User's Cloned DLL to generate the corresponding IMPORT library
#
$(USRNAME).lib: $(USRNAME).dll $(USRNAME).def
  implib $(USRNAME).lib $(USRNAME).def

