#ifndef _IZXPBAR_
  #define _IZXPBAR_
/***************************************************************                         
 *  FILE NAME: D:\ERIC\PBAR3\VSZxPBar.hpp                                                           
 *  Progress bar                                                  
 *  23 May 2000                                                  
 *  Copyright 1994 HockWare, Inc.                                                   
 ***************************************************************/                         
#ifndef _ICONTROL_                                                              
  #include <icontrol.hpp>                                                       
#endif                                                                          
#ifndef _IRECT_                                                                 
  #include <irect.hpp>                                                          
#endif                                                                          
                                                                             
// Forward declarations for other classes:                                      
class IString;                                                                  
class IResourceId;                                                              
                                                                                
/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)                                                                 
                                                                                
class IZxPBar : public IControl  {                                            
typedef IControl Inherited;                                                     
/*******************************************************************************
* The IZxPBar class creates and manages the Progress bar control.  *
*******************************************************************************/
public:                                                                         
/*---------------------- Style --------------------------------------------     
  The following functions provide a means to set and query Progress bar styles:     
                                                                                
    Style - Nested class that provides static members that define the set of    
            valid Progress bar styles.  These styles can be used in conjunction     
            with the styles defined by the nested classes IWindow::Style and    
            IControl::Style. 
            An object of this type is provided when the Progress bar is created.    
            A customizable default is used if no styles are specified.  Once    
            the object is constructed, IZxPBar, IWindow, and IControl          
            member functions can be used to set or query the object's style.    
                                                                                
            The declaration of the IZxPBar::Style nested class is generated    
            by the INESTEDBITFLAGCLASSDEF2 macro.                               
                                                                                
  The valid Progress bar styles are:                                                
    ZxPercent - Set progress bar as a percent display
    ZxNumeric - Set progress bar as a numeric display
    ZxButtonStyle - Give the progress bar a Button relief style

  The following functions provide a means of getting and setting the default    
  style for this class:                                                         
    defaultStyle    - Returns the current default style.  This is the same as   
                      classDefaultStyle unless setDefaultStyle has been         
                      called.                                                   
    setDefaultStyle - Sets the default style for all subsequent Progress bars.     
-------------------------------------------------------------------------*/     
INESTEDBITFLAGCLASSDEF2(Style, IZxPBar, IWindow, IControl);                    


static const Style
     classDefaultStyle,
     ZxPercent,
     ZxNumeric,
     ZxButtonStyle;

static Style                                                                       
   defaultStyle();                                                                 
static void                                                                        
   setDefaultStyle(const Style& style);                                            
static void                                                                        
  initialize(void);
                                                                                   
/*------------------------ Constructors ----------------------------------------   
| You can construct an instance of this class in the following ways:           |   
|    - From a control ID, parent and owner windows, rectangle, and style.      |   
|      This creates the specified Progress bar control and an object for it.       | 
|    - From the ID of a Progress bar control on a dialog window.  This creates     | 
|      the object for the specified Progress bar control.                          | 
|    - From the window handle of an existing Progress bar control.  This creates   | 
|      the object for the specified Progress bar control.                          | 
------------------------------------------------------------------------------*/   
  IZxPBar(unsigned long id,                                                       
           IWindow* parent,                                                        
           IWindow* owner,                                                         
           const IRectangle& initial = IRectangle(),                               
           const Style& style = defaultStyle() );                                  
                                                                                   
  IZxPBar(unsigned long id,                                                       
           IWindow* parent);                                                       
                                                                                   
  IZxPBar(const IWindowHandle& handle);                                           
                                                                                   
  virtual ~IZxPBar();                                                             
                                                                                   
/*------------------------ General methods ---------------------------------       
|                                                                              |   
|  UPDPROGRESS - Updates the progress with a min and max value
|                                                                              |   
------------------------------------------------------------------------------*/   
                                                                                   
IZxPBar& UPDPROGRESS();
                                                                                   
/*------------------------ Style Functions -------------------------------------   
|                                                                              |   
|    isZxPercent - Returns true if the ZxPercent style is set. 
|    enableZxPercent - Enables or disables the ZxPercent style. 
|    isZxNumeric - Returns true if the ZxNumeric style is set. 
|    enableZxNumeric - Enables or disables the ZxNumeric style. 
|                                                                              |   
------------------------------------------------------------------------------*/   
                                                                                   
virtual Boolean isZxPercent() const;
virtual IZxPBar &enableZxPercent(Boolean enable = true);
virtual Boolean isZxNumeric() const;
virtual IZxPBar &enableZxNumeric(Boolean enable = true);
                                                                                   
static  Style         
  currentDefaultStyle;
                                                                                   
};// IZXPBAR                                                                                   
//Global Style Functions                                                           
INESTEDBITFLAGCLASSFUNCS(Style, IZxPBar);                                         
                                                                                   
                                                                                 
/*----------------------------------------------------------------------------*/   
/* Resume compiler default packing and warning messages.                      */   
/*----------------------------------------------------------------------------*/   
#pragma pack()                                                                     
                                                                                   
#endif  /* _IZXPBAR_ */                                                           
