
#include "ui/applic.h"

#include "appwin.h"

const UI_ViewID ID_BUTTON = 101;

OurComposite::OurComposite ()
: UI_CompositeVObject (NULL, (UI_ViewDescriptor*) NULL, FALSE,
                       UI_Rectangle (50, 50, 500, 400), 0)
{
    status = new UI_Label      (this, UI_Rectangle (50, 50, 400, 30));
    btn    = new UI_PushButton (this, UI_Rectangle (200, 300, 100, 50),
                                ID_BUTTON);
    btn->Title () = "OK";
}

bool OurComposite::MouseMove (const UI_Point& cursorPos)
{
    CL_String s = "Mouse at " + CL_String ((long) cursorPos.XCoord())
        + ", " + CL_String ((long) cursorPos.YCoord());
    status->Title() = s;
    return TRUE;
}


bool OurComposite::HandleChildEvent (const UI_Event& e)
{
    switch (e.Type()) {
    case Event_ViewEnter:
        if (e.Origin() == btn)
            status->Title() = "Click here to terminate.";
        break;
        
    case Event_ViewLeave:
        status->Title()= "";
        break;

    case Event_Select:
        if (e.Origin() == btn)
            _Application->Destroy(this);
        break;
    }
    return TRUE;
}


