

#include "menudrv.h"
#include "ids.h"


#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/stddlg.h"



#if defined(__GNUC__)
template class CL_Binding<MenuDriver>; // Instantiate the binding
#endif

extern UI_Application* _TheApplication;

typedef CL_Binding<MenuDriver> MenuBinding;

#if 0
MenuDriver::MenuDriver()
{
    UI_CompositeVObject* root = _TheApplication->MainWindow();
    UI_Rectangle shape = root->ClientArea ();
    status = new UI_Label (root, UI_Rectangle (0, shape.Height()-30,
                                               shape.Width(), 30));
    status->ShowBorder ();
//     MenuBinding bind (this, &MenuDriver::Resize);
//     root->AddEventDependent (Event_Reconfigure, bind, 1);
}
#endif



struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_EventType           event;
    long                   parameter;
} FAR dispatch [] = {
    {ID_JAN,      MenuDriver::Inform, Event_Select,  ID_JAN}
  , {ID_FEB,      MenuDriver::Inform, Event_Select,  ID_FEB}
  , {ID_MAR,      MenuDriver::Inform, Event_Select,  ID_MAR}
  , {ID_APR,      MenuDriver::Inform, Event_Select,  ID_APR}
  , {ID_MAY,      MenuDriver::Inform, Event_Select,  ID_MAY}
};



void MenuDriver::Setup (UI_Menu* menu)
{
    _menu = menu;
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        (*menu)[dispatch[i].menu_id]->AddEventDependent
            (dispatch[i].event, MenuBinding (this, dispatch[i].method),
             dispatch[i].parameter);
    }
}




bool MenuDriver::Inform (CL_Object&, long item_id)
{
    UI_SimpleDialog ("You chose " + (*_menu)[item_id]->Title());
    return TRUE;
}





