

#include "menudrv.h"
#include "ids.h"
#include "box.h"

#include "ui/ui.h"


#if defined(__GNUC__)
template class CL_Binding<MenuDriver>; // Instantiate the binding
#endif

extern UI_Application* _TheApplication;
extern UI_MenuBar*     MainMenu;

typedef CL_Binding<MenuDriver> MenuBinding;
MenuDriver::MenuDriver()
{
    box = NULL;
    (*MainMenu)[ID_STOP]->Disable();
    UI_CompositeVObject* root = _TheApplication->MainWindow();
    UI_Rectangle shape = root->ClientArea ();
    status = new UI_Label (root, UI_Rectangle (0, shape.Height()-30,
                                               shape.Width(), 30));
    status->ShowBorder ();
    status->Title() = "Ready";
    MenuBinding bind (this, &MenuDriver::Resize);
    root->AddEventDependent (Event_Reconfigure, bind, 1);
}

MenuDriver::~MenuDriver()
{
    if (box)
        _TheApplication->Destroy(box);
}


struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_EventType           event;
    long                   parameter;
} FAR dispatch [] = {
    {ID_START,    MenuDriver::Start,  Event_Select,  1}
  , {ID_STOP,     MenuDriver::Stop,   Event_Select,  1}
  , {ID_SETSEL,   MenuDriver::SetSel, Event_Select,  1}
  , {ID_EMPTY,    MenuDriver::Empty,  Event_Select,  1}
  , {ID_REFILL,   MenuDriver::Refill, Event_Select,  1}
  , {ID_SORT,     MenuDriver::Sort,   Event_Select,  1}
  , {ID_QUIT,     MenuDriver::Quit,   Event_Select,  1}

  , {ID_SUBMENU1, MenuDriver::Inform, Event_Select,  ID_SUBMENU1}
  , {ID_SUBMENU2, MenuDriver::Inform, Event_Select,  ID_SUBMENU2}

  , {ID_START, MenuDriver::Change, Event_GetFocus, ID_START}
  , {ID_STOP,  MenuDriver::Change, Event_GetFocus, ID_STOP}
  , {ID_SETSEL,MenuDriver::Change, Event_GetFocus, ID_SETSEL}
  , {ID_QUIT,  MenuDriver::Change, Event_GetFocus, ID_QUIT}

  , {ID_START, MenuDriver::Change, Event_LoseFocus, 0}
  , {ID_STOP,  MenuDriver::Change, Event_LoseFocus, 0}
  , {ID_SETSEL,MenuDriver::Change, Event_LoseFocus, 0}
  , {ID_QUIT,  MenuDriver::Change, Event_LoseFocus, 0}

  , {ID_APP2,  MenuDriver::Change, Event_GetFocus, 0}
  , {ID_APP3,  MenuDriver::Change, Event_GetFocus, 0}
    
};



void MenuDriver::Setup (UI_MenuBar* menu)
{
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        (*menu)[dispatch[i].menu_id]->AddEventDependent
            (dispatch[i].event, MenuBinding (this, dispatch[i].method),
             dispatch[i].parameter);
    }
}




bool MenuDriver::Start (CL_Object&, long)
{
    if (!box) {
        box = new Box (_TheApplication->MainWindow(),
                       UI_Rectangle (20, 50, 400, 250));
        (*MainMenu)[ID_STOP]->Enable();
        (*MainMenu)[ID_START]->Disable();
        return TRUE;
    }
    return FALSE;
}



bool MenuDriver::Stop  (CL_Object&, long)
{
    if (box) {
        _TheApplication->Destroy(box);
        box = NULL;
    }
    (*MainMenu)[ID_START]->Enable();
    (*MainMenu)[ID_STOP]->Disable();
    return TRUE;
}


bool MenuDriver::Quit  (CL_Object&, long)
{
    _TheApplication->End();
    return TRUE;
}

bool MenuDriver::Change (CL_Object& o, long menu_id)
{
    CL_String& s  = (CL_String &) status->Model();
    UI_Event& e = (UI_Event&) o;
    if (e.Type() == Event_LoseFocus) {
        s = "";
        return TRUE;
    }
    switch (menu_id) {
    case ID_START:
        s = "Creates the composite";
        break;
        
    case ID_STOP:
        s = "Destroys the composite";
        break;
        
    case ID_QUIT:
        s = "Terminates the application";
        break;
        
    case ID_SETSEL:
        s = "Sets selections in string views";
        break;

    default:
        s = "Ready";
    }
    return TRUE;
}


bool MenuDriver::SetSel (CL_Object&, long)
{
    if (!box)
        return TRUE;
    UI_StringViewSingleSel& sngl = (UI_StringViewSingleSel&)
        *((*box)[ID_SINGLE_VIEW]);
    UI_StringViewSingleSel& mult = (UI_StringViewSingleSel&)
        *((*box)[ID_MULT_VIEW]);
    sngl.Selection() = 1;
    mult.Selection() = CL_IntegerSet (2,4); // Select three items
    return TRUE;
}




bool MenuDriver::Empty (CL_Object&, long)
{
    if (box) {
        UI_StringSequence& seq = box->Sequence();
        seq.MakeEmpty();
    }
    return TRUE;
}


bool MenuDriver::Refill (CL_Object&, long)
{
    if (box) {
        UI_StringSequence& seq = box->Sequence();
        const char* sq[] =
                     {"One", "Two", "Three", "Four", "Five", "Six", "Seven",
                      "Eight", "Nine", "Ten", "Eleven", "Twelve",
                      "Thirteen", "Fourteen", "Fifteen"};
        seq = CL_StringSequence (sq, 15);
    }
    return TRUE;
}

#include <iostream.h> // DEBUG
bool MenuDriver::Resize (CL_Object&, long)
{
    if (!box)
        return TRUE;
    UI_Rectangle& shape = _TheApplication->MainWindow()->ClientArea();
    UI_Rectangle& boxShape = box->ClientArea();
    UI_Point p ((shape.Width()  - boxShape.Width())/2,
                (shape.Height() - boxShape.Height())/2);
    boxShape.Origin (p);
    return TRUE;
}


bool MenuDriver::Sort (CL_Object&, long)
{
    if (box) {
        UI_StringSequence& seq = box->Sequence();
        seq.Sort();
    }
    return TRUE;
}


bool MenuDriver::Inform (CL_Object&, long item_id)
{
    if (box) {
        UI_StringSequence& seq = box->Sequence();
        seq[3] = "three";
        seq[4] = "four";
    }
    UI_SimpleDialog ("You chose " + (*MainMenu)[item_id]->Title());
    if (item_id == ID_SUBMENU1) {
        MainMenu->Add (298, "New item", ID_APP2);
        MainMenu->Add (299, "Another New item", ID_APP2);
        MainMenu->Add (300, "Secondary item", ID_APP2, 0);
    }
    else
        MainMenu->Remove (ID_APP2);
    return TRUE;
}

