

#include "ui/ui.h"

#include "menudrv.h"
#include "box.h"
#include "ids.h"

#ifdef __BORLANDC__
extern unsigned _stklen = 35000;
#endif

UI_MenuItemDescriptor App1Submenu [] = {
  {"A one",  ID_SUBMENU1}
, {"A two",  ID_SUBMENU2}
, {NULL   ,            0}
};

UI_MenuItemDescriptor App1Menu [] = {
    {"&Start"        , ID_START , NULL       }
  , {"S&top"         , ID_STOP  , NULL       }
  , {"Submenu"       , 120      , App1Submenu}
  , {UIMenu_Separator, NULL     , NULL       }
  , {"Select"        , ID_SETSEL, NULL       }
  , {"Make empty"    , ID_EMPTY , NULL       }
  , {"Rebuild"       , ID_REFILL, NULL       }
  , {"Resize"        , ID_RESIZE, NULL       }
  , {"Sort"          , ID_SORT  , NULL       }
  , {"&Quit"         , ID_QUIT  , NULL       }
  , {NULL            , 0        , NULL       }
};

UI_MenuItemDescriptor App3Menu [] = {
    {"Start",  ID_START2}
  , {"Stop" ,  ID_STOP2}
  , {"Quit" ,  ID_QUIT2}
  , {0      ,      0   }
};


UI_MenuItemDescriptor MainMenuDesc [] = {
    {"&One"  , ID_APP1, App1Menu}
  , {"&Two"  , ID_APP2, NULL    }
  , {"Th&ree", ID_APP3, App3Menu}
  , {NULL    ,       0, NULL    }
};


UI_MenuBar*     MainMenu;



typedef CL_Binding<MenuDriver> MenuBinding;




// ======================== Main program ===========================


int UI_Application::Main (int, char* [])
{
    UI_CompositeVObject* root = new UI_CompositeVObject
        (NULL, NULL, FALSE, UI_Rectangle (100, 100, 470, 470));
    MakeTopWindow (root);
    MainMenu = new UI_MenuBar (root, MainMenuDesc);

    MenuDriver driver;
    driver.Setup (MainMenu);
    Run();
    return 0;
}

