

#include "ui/ui.h"
#include "appwin.h"


AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (10, 50, 425, 400))
{
    Title () = "YACL graphics demo 3";
}


bool AppWindow::Paint ()
{
    Draw ();
    return TRUE;
}

#include <iostream.h> // DEBUG


char mask[] = {
    0x00, 0x01, 0x00, 0x00,
    0x00, 0x01, 0x80, 0x00,
    0x00, 0x03, 0xc0, 0x00,
    0x00, 0x07, 0xe0, 0x00,
    0x00, 0x0f, 0xf0, 0x00,
    0x00, 0x1f, 0xf8, 0x00,
    0x00, 0x3f, 0xfc, 0x00,
    0x00, 0x7f, 0xfe, 0x00,
    0x00, 0xff, 0xff, 0x00,
    0x01, 0xff, 0xff, 0x80,
    0x03, 0xff, 0xff, 0xc0,
    0x07, 0xff, 0xff, 0xe0,
    0x0f, 0xff, 0xff, 0xf0,
    0x1f, 0xff, 0xff, 0xf8,
    0x3f, 0xff, 0xff, 0xfc,
    0x7f, 0xff, 0xff, 0xfe
};

const short WIDTH = 32, HEIGHT = 16;


void AppWindow::Initialize ()
{
    CreateDisplaySurface ();
}

void AppWindow::Draw ()
{
    Background (UIColor_White);
    //    CreateDisplaySurface ();

    UI_Rectangle r;
    UI_DisplaySurface& sfc = *(DisplaySurface());

    UI_Rectangle area = sfc.DrawingArea ();
    area.Origin (UI_Point (0, 0));
    sfc.ColorRectangle (area, UIColor_White);
    UI_Pen& pen = sfc.Pen ();
    UI_Brush& brush = sfc.Brush();
    UI_Font& font = sfc.Font();

    brush.Color (UIColor_Blue); brush.Pattern (UIBrush_Solid);
    pen.Color (UIColor_Red);
    sfc.DrawEllipse   (UI_Rectangle (150, 20,  100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));

    pen.Thickness (1);
    pen.Color (UIColor_Black);
    pen.Pattern (UIPen_Dot);
    sfc.DrawLine (UI_Point (20,  20), UI_Point (80,  20));
    pen.Pattern (UIPen_Dash);
    sfc.DrawLine (UI_Point (20,  40), UI_Point (80,  40));
    pen.Pattern (UIPen_Solid);
    sfc.DrawLine (UI_Point (20,  60), UI_Point (80,  60));

    font = UI_FontDesc (UIFont_Courier, 12, UIFont_Underline);
    sfc.WriteString ("An ellipse", UI_Rectangle (270, 20, 145, 30));

    brush.Color   (UI_Color (0, 1, 1)); // Cyan
    sfc.DrawRectangle (UI_Rectangle (150, 90, 100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Times,   12, UIFont_Italic | UIFont_BoldFace);
    sfc.WriteString ("A rectangle", UI_Rectangle (270, 100, 145, 40));


    pen.Thickness (2);
    pen.Color (UIColor_Green); 
    sfc.DrawLine (UI_Point (20,  90), UI_Point (80,  90));
    pen.Color (UIColor_Red);
    sfc.DrawLine (UI_Point (20, 110), UI_Point (80, 110));
    pen.Color (UIColor_Blue);
    sfc.DrawLine (UI_Point (20, 130), UI_Point (80, 130));

    //  pen.Color (UIColor_MediumGray);
    font = UI_FontDesc (UIFont_Helvetica, 12, UIFont_BoldFace);
    sfc.WriteString ("A few lines", UI_Rectangle (20, 150, 120, 40));

    font = UI_FontDesc (UIFont_Times, 12, UIFont_StrikeOut |
                        UIFont_BoldFace);
    sfc.WriteString ("Struck out text", UI_Rectangle (20, 200, 130, 40));

    pen.Thickness (1);

    brush.Color (UI_Color (UIColor_Green)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 180, 100, 60);
    UI_PieWedge p (r, 60*64, 100*64);
    sfc.DrawPieWedge (p, (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Times, 14, UIFont_BoldFace);
    sfc.WriteString ("A PieWedge", UI_Rectangle (270, 200, 145, 40));

    brush.Color   (UI_Color (UIColor_MediumGray)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 240, 100, 60);
    UI_Chord c (r, 60*64, 110*64);
    sfc.DrawChord (c, (UID_DrawOptions) (UID_Outline | UID_Fill));
    sfc.WriteString ("A Chord", UI_Rectangle (270, 250, 145, 40));

    r = UI_Rectangle (150, 300, 100, 60);
    UI_Arc arc (r, 60*64, 249*64);
    arc.DrawOn (sfc);
    sfc.WriteString ("An arc", UI_Rectangle (270, 320, 145, 40));


    {
        UI_Bitmap bm;
        UI_Stencil s (mask, WIDTH, HEIGHT);
        bm.CopyFrom (*_displaySurface, UI_Rectangle (270, 250, 32, 16));
        _displaySurface->Draw (bm, s, UI_Point (30, 300));
    }
    //    DestroyDisplaySurface ();
}

bool AppWindow::ButtonDown (const UI_Point& p, UI_MouseButton m,
                            bool, bool)
{
    if (m != UIM_Left)
        return FALSE;
    _oldP = p;
    _inDrag = TRUE;
    UI_Stencil s (mask, WIDTH, HEIGHT);
    _displaySurface->Invert (s, p + UI_Point (-WIDTH, -HEIGHT));
    return TRUE;
}


bool AppWindow::MouseMove (const UI_Point& p)
{
    if (!_inDrag)
        return TRUE;
    UI_Stencil s (mask, WIDTH, HEIGHT);
    _displaySurface->Invert (s, _oldP + UI_Point (-WIDTH, -HEIGHT));
    _displaySurface->Invert (s, p + UI_Point (-WIDTH, -HEIGHT));
    _oldP = p;
    return TRUE;
}



bool AppWindow::ButtonUp (const UI_Point& p, UI_MouseButton m)
{
    if (m != UIM_Left)
        return FALSE;
    _inDrag = FALSE;
    UI_Stencil s (mask, WIDTH, HEIGHT);
    _displaySurface->Invert (s, p + UI_Point (-WIDTH, -HEIGHT));
    _Controller->ReleaseMouse();
    return TRUE;
}
