

#include "ui/lineseg.h"
#include "ui/piewedge.h"
#include "ui/chord.h"
#include "ui/arc.h"
#include "ui/ellipse.h"
#include "ui/dsplsurf.h"
#include "appwin.h"


AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (10, 50, 425, 400))
{
    Title () = "YACL graphics demo 2";
}


bool AppWindow::Paint ()
{
    Draw ();
    return TRUE;
}

#include <iostream.h> // DEBUG
void AppWindow::Draw ()
{
    Background (UIColor_White);
    CreateDisplaySurface ();

    UI_Rectangle r;
    UI_DisplaySurface& sfc = *(DisplaySurface());

    UI_Rectangle area = sfc.DrawingArea ();
    area.Origin (UI_Point (0, 0));
    sfc.ColorRectangle (area, UIColor_White);
    UI_Pen& pen = sfc.Pen ();
    UI_Brush& brush = sfc.Brush();
    UI_Font& font = sfc.Font();

    brush.Color (UIColor_Blue); brush.Pattern (UIBrush_Solid);
    pen.Color (UIColor_Red);
    sfc.DrawEllipse   (UI_Rectangle (150, 20,  100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));

    pen.Thickness (1);
    pen.Color (UIColor_Black);
    pen.Pattern (UIPen_Dot);
    sfc.DrawLine (UI_Point (20,  20), UI_Point (80,  20));
    pen.Pattern (UIPen_Dash);
    sfc.DrawLine (UI_Point (20,  40), UI_Point (80,  40));
    pen.Pattern (UIPen_Solid);
    sfc.DrawLine (UI_Point (20,  60), UI_Point (80,  60));

    font = UI_FontDesc (UIFont_Courier, 12, UIFont_Underline);
    sfc.WriteString ("An ellipse", UI_Rectangle (270, 20, 145, 30));

    brush.Color   (UI_Color (0, 1, 1)); // Cyan
    sfc.DrawRectangle (UI_Rectangle (150, 90, 100, 60),
                       (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Times,   12, UIFont_Italic | UIFont_BoldFace);
    sfc.WriteString ("A rectangle", UI_Rectangle (270, 100, 145, 40));


    pen.Thickness (2);
    pen.Color (UIColor_Green); 
    sfc.DrawLine (UI_Point (20,  90), UI_Point (80,  90));
    pen.Color (UIColor_Red);
    sfc.DrawLine (UI_Point (20, 110), UI_Point (80, 110));
    pen.Color (UIColor_Blue);
    sfc.DrawLine (UI_Point (20, 130), UI_Point (80, 130));

    pen.Color (UIColor_MediumGray);
    font = UI_FontDesc (UIFont_Helvetica, 12, UIFont_BoldFace);
    sfc.WriteString ("A few lines", UI_Rectangle (20, 150, 120, 40));

    font = UI_FontDesc (UIFont_Times, 12, UIFont_StrikeOut |
                        UIFont_BoldFace);
    sfc.WriteString ("Struck out text", UI_Rectangle (20, 200, 130, 40));

    pen.Thickness (1);

    brush.Color (UI_Color (UIColor_Green)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 180, 100, 60);
    UI_PieWedge p (r, 60*64, 100*64);
    sfc.DrawPieWedge (p, (UID_DrawOptions) (UID_Outline | UID_Fill));
    font = UI_FontDesc (UIFont_Times, 14, UIFont_BoldFace);
    sfc.WriteString ("A PieWedge", UI_Rectangle (270, 200, 145, 40));

    brush.Color   (UI_Color (UIColor_MediumGray)); 
    pen.Color   (UI_Color (UIColor_Red));
    r = UI_Rectangle (150, 240, 100, 60);
    UI_Chord c (r, 60*64, 110*64);
    sfc.DrawChord (c, (UID_DrawOptions) (UID_Outline | UID_Fill));
    sfc.WriteString ("A Chord", UI_Rectangle (270, 250, 145, 40));

    r = UI_Rectangle (150, 300, 100, 60);
    UI_Arc arc (r, 60*64, 249*64);
    arc.DrawOn (sfc);
    sfc.WriteString ("An arc", UI_Rectangle (270, 320, 145, 40));

    DestroyDisplaySurface ();
}
