

#include "ui/font.h"
#include "ui/dialog.h"
#include "ui/applic.h"

#include "appwin.h"


UI_ViewDescriptor desc[] = {
    {View_PushButton, 2, 0, 0,  60, 30, TRUE,  "Start"},
    {View_PushButton, 3, 0, 60, 60, 30, TRUE,  "Quit"},
    {View_None, -1, 0, 0, 0, 0, 0, 0}
};


UI_DialogEventDescriptor desc2 [] = {
    105, Event_Select,
    106, Event_Select,
    -1,  Event_None
};




AppWindow::AppWindow ()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (50, 50, 500, 400))
{
    msg = new UI_Label (this, UI_Rectangle (10, 100, 340, 250));
    msg->Font().PointSize(11);
}







bool AppWindow::HandleChildEvent(const UI_Event& e)
{
    if( e.Origin()->ViewID() == 3 && e.Type()== Event_Select) {
        _Application->End();
        return FALSE;
    }
    if (e.Origin()->ViewID() != 2 || e.Type() != Event_Select)
        return FALSE;

    UI_Dialog* d =  new UI_Dialog (this,"DIALOG_1", desc2);
    d->Title() = "Inner dialog";
    CL_String& msg_value = (CL_String&) (msg->Model());
    msg_value = "";
    UI_ViewID quitID = d->ExecuteModal ().id; 

    CL_IntPtrMapIterator itr ((CL_IntPtrMap&) (d->Model()));
    itr.Reset();
    while (itr.More()) {
        CL_IntPtrAssoc  assoc = itr.Next();
        UI_ViewID id = assoc.key;
        msg_value += "Id " + CL_String (id)
            + " value: " + assoc.value->AsString() + "\r\n";
    }
    msg_value += "Quit button Id: " + CL_String (quitID)
        + "\r\n";
    _Application->Destroy (d);
    return TRUE;
}

