
#ifndef _bigstrv_h_
#define _bigstrv_h_



// A BigStringView is a StringView that can display large numbers of
// strings. It uses a StringSequence as its model, and the latter can hold
// millions of strings.
//
// The BigStringView class is provided to illustrate how the graphic
// capabilities can be used for building custom widgets. It simulates a
// normal StringView  by drawing a view area and the strings in it, and
// managing the scroll bar appropriately.


#include "ui/scrolbar.h"
#include "ui/vobjcoll.h"
#include "base/strgseq.h"

class BigStringView: public UI_VObjCollection {

public:
    BigStringView (UI_VObjCollection* parent, const UI_Rectangle& shape,
                   CL_StringSequence& model, UI_ViewID id = -1);

    CL_Object& Model() {return _modelSeq;};

    long Selection () {return _selection; };
    
protected:
    UI_VScrollBar*       _scrollBar;
    CL_StringSequence&   _modelSeq;
    short                _visibleCount;  // Number of visible strings
    long                 _selection;     // Index of selected string in
                                         // model sequence; -1 if no selection

    bool MakeVisualElement () {return UI_VObjCollection::MakeVisualElement();}
    void Initialize ();
    bool Paint ();
    bool ButtonDown (const UI_Point& position, UI_MouseButton btn,
                     bool shiftKey, bool ctrlKey); 
private:
    bool _Scroll (CL_Object&, long);
    // Called when the scroll bar is scrolled

    bool _ModelChanged (CL_Object&, long);
    bool _DrawClientArea ();

    void _SetupScrollBar ();
    
};

#endif /* _bigstrv_h_ */
