

#include "bigstrv.h"

#include "ui/dsplsurf.h"
#include "ui/font.h"
#include "ui/cntroler.h"

typedef CL_Binding<BigStringView> Bind;

#if defined(__GNUC__)
template class CL_Binding<BigStringView>;
#endif

const short scrollBarWidth = 20;
const UI_ViewID ID_BAR = 101;

BigStringView::BigStringView
    (UI_VObjCollection* parent, const UI_Rectangle& shape, 
     CL_StringSequence& model, UI_ViewID id)
: UI_VObjCollection (parent, shape, id), _modelSeq (model)
{
    Bind bind (this, &BigStringView::_ModelChanged);
    _modelSeq.AddDependent (bind, 1);

    UI_Rectangle scrollBarRect (shape.Width () - scrollBarWidth, 0,
                                scrollBarWidth, shape.Height ());
    _scrollBar = new UI_VScrollBar (this, scrollBarRect, ID_BAR);
    Bind scrollBind (this, &BigStringView::_Scroll);
    _scrollBar->ClientSet().Add (scrollBind, 1);

    _selection = -1;
}

void BigStringView::Initialize ()
{
    _visibleCount    = 0;
}

void BigStringView::_SetupScrollBar ()
{
    long size = _modelSeq.Size();
    _scrollBar->SetVisibility (_visibleCount < size ? TRUE : FALSE);
    _scrollBar->PageAmount() = _visibleCount-1;
    _scrollBar->Range () = CL_Interval (0, maxl (_visibleCount,
                                                 size - _visibleCount));
    CL_Interval& scrollInterval = (CL_Interval&) _scrollBar->Model();
    long low = minl (scrollInterval.Low(), size-1);
    scrollInterval = CL_Interval (low, low + _visibleCount - 1);
}

#include <iostream.h>
bool BigStringView::_DrawClientArea ()
{
    UI_DisplaySurface& sfc = CreateDisplaySurface ();
    short charHeight       = Font().Height();
    if (charHeight <= 1) { // Something wrong
        DestroyDisplaySurface ();
        return FALSE;
    }

    // Determine the box in which the strings will be drawn
    short boxHeight = _shape.Height() - 2;
    UI_Rectangle box = UI_Rectangle (0, 0, _shape.Width(), boxHeight);
    long modelSize  = _modelSeq.Size();
    if (!_visibleCount) {
        // Very first paint event
        _visibleCount   = boxHeight/charHeight;
        _SetupScrollBar ();
    }
    if (_visibleCount < modelSize)
        box.AddToWidth (-scrollBarWidth);
    
    sfc.Brush().Color   (UIColor_White);
    sfc.Brush().Pattern (UIBrush_Solid);
    sfc.DrawRectangle  (box, UID_Outline | UID_Fill);

    // Draw the strings
    long topElement = _visibleCount >= modelSize ? 0
        : ((CL_Interval&) _scrollBar->Model ()).Low ();
    short yOffset = 0;
    short count = minl (topElement + _visibleCount, modelSize);
    short textWidth = box.Width()-2; // text rectangle is narrower than box
    for (long i = topElement; i < count
         && yOffset + charHeight <= boxHeight; i++, yOffset += charHeight) {
        UI_Rectangle textRect (2, yOffset, textWidth, charHeight);
        sfc.WriteString (_modelSeq[i], textRect);
    }

    // Invert the selected string, if any
    if (_selection >= 0) {
        short index = _selection - topElement;
        if (index >= 0 && index < _visibleCount) {
            UI_Rectangle selectRect (2, index * charHeight,
                                     textWidth, charHeight);
            sfc.InvertRectangle (selectRect);
        }
    }

    // All done
    DestroyDisplaySurface ();
    return TRUE;
}

bool BigStringView::_ModelChanged (CL_Object&, long)
{
    _SetupScrollBar ();
    _DrawClientArea ();
    return TRUE;
}

bool BigStringView::_Scroll (CL_Object&, long)
{
    _DrawClientArea ();
    return TRUE;
}

bool BigStringView::Paint ()
{
    return _DrawClientArea ();
}

bool BigStringView::ButtonDown (const UI_Point& position, UI_MouseButton btn,
                                bool, bool)
{
    if (btn != UIM_Left)
        return FALSE;
    short charHeight = Font().Height();
    if (charHeight <= 1)
        return FALSE;  // Safety check
    short index = position.YCoord() / charHeight;
    if (index >= _visibleCount)
        return FALSE;
    long topElement = _visibleCount >= _modelSeq.Size() ? 0
        : ((CL_Interval&) _scrollBar->Model()).Low();
    long newSelection = topElement + index;
    if (newSelection >= _modelSeq.Size())
        return FALSE;
    if (newSelection != _selection) {
        UI_DisplaySurface& sfc = CreateDisplaySurface ();
        short charHeight       = Font().Height();
        short width = _shape.Width()-2;
        if (_scrollBar->IsVisible())
            width -= scrollBarWidth;
        if (_selection >= topElement &&
            _selection < topElement + _visibleCount) {
            // Old selection exists and is visible, so de-highlight it
            UI_Rectangle oldSelRect (2, (_selection - topElement) * charHeight,
                                     width, charHeight);
            sfc.InvertRectangle (oldSelRect);
        }                                     
        _selection = newSelection;
        UI_Rectangle selRect (2, (newSelection - topElement) * charHeight,
                              width, charHeight);
        sfc.InvertRectangle (selRect);
    }

    _Controller->AddEvent (new UI_Event (Event_Select, this, this));
    return TRUE;
}

