
#include "ui/strseq.h"

#include "appwin.h"
#include "bigstrv.h"

const UI_ViewID ID_LABEL = 120; // Appease OS/2, and make all children have
                                // id's

AppWindow::AppWindow (CL_StringSequence& model)
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (10, 50, 370, 190)),
  _big (new BigStringView (this, UI_Rectangle (30, 30, 300, 120), model))
{
    Title () = "BigStringView Demo";
    _big->Font() = UI_FontDesc (UIFont_Helvetica, 10);
    _label = new UI_Label (this, UI_Rectangle (10, 160, 280, 20), ID_LABEL);
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin() == _big && e.Type() == Event_Select) {
        UI_StringSequence& model = (UI_StringSequence&) _big->Model();
        _label->Title() = CL_String ("# entries: ") + CL_String (model.Size())
            + " selection: " + CL_String (_big->Selection());
    }
    return TRUE;
}

