




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/xrbtngrp.h"
#include "ui/cntroler.h"
#include "ui/xrtglbtn.h"

typedef CL_Binding <UI_ExOrButtonGroup> Bind;

#if defined(__GNUC__)
template class CL_Binding<UI_ExOrButtonGroup>;
#endif


UI_ExOrButtonGroup::UI_ExOrButtonGroup
    (UI_VObjCollection* parent, const UI_Rectangle& shape,
     UI_ViewID id, UI_ViewDescriptor* vd)
: UI_ButtonGroup (parent, shape, id)
{
    if (vd) {
        char* fmt = "UI_ExOrButtonGroup constructor: invalid type %d "
            "at index %d";
        for (short i = 0; vd[i].type != View_None; i++) {
            if (vd[i].type != View_ExOrToggleButton) {
                CL_Error::Warning (fmt, vd[i].type, i);
                break;
            }
            UI_ExOrToggleButton* p = new UI_ExOrToggleButton
                (this, vd[i].shape, vd[i].id);
            p->Title() = vd[i].title;
            _objMap.Add (id, p);
        }
    }
    _Init ();
}


#if defined(__MS_WINDOWS__)
UI_ExOrButtonGroup::UI_ExOrButtonGroup
    (UI_CompositeVObject* parent,  UI_ViewID id, UI_ViewHandle h)
: UI_ButtonGroup (parent, id, h)
{
    _Init ();
}

#endif



void UI_ExOrButtonGroup::_Init ()
{
    Bind bind (this, &UI_ExOrButtonGroup::_ModelChanged);
    _selection.AddDependent (bind, 1);
}


bool UI_ExOrButtonGroup::_ModelChanged (CL_Object&, long)
{
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        UI_ViewID id = assoc.key;
        (CL_Integer&) ((*this)[id]->Model()) = 0;
    }
    if (_objMap.IncludesKey (_selection))
        (CL_Integer&) ((*this)[_selection]->Model()) = 1;
    return TRUE;
}





bool UI_ExOrButtonGroup::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
#if defined(__MS_WINDOWS__) || defined(__OS2__)
    _UpdateSelection ();
    
#elif defined(__X_MOTIF__)
    UI_VisualObject* v = e.Origin();
    UI_ViewID id = v->ViewID();
    Bind bind (this, &UI_ExOrButtonGroup::_ModelChanged);
    _selection.RemoveDependent (bind);
    _selection = id; // The dependent removal is so that this
                     // assignment does not give us notification
    _selection.AddDependent (bind, 1);
#endif
    _Controller->AddEvent (new UI_Event (Event_Select, this, this));
    return TRUE;
}




CL_Integer& UI_ExOrButtonGroup::Selection()
{
    _UpdateSelection ();
    return _selection;
}


void UI_ExOrButtonGroup::_UpdateSelection()
{
    CL_IntPtrMapIterator itr (_objMap);
    while (itr.More()) {
        CL_IntPtrAssoc assoc = itr.Next();
        UI_ViewID id = assoc.key;
        CL_Integer value =  (CL_Integer&) ((*this)[id]->Model());
        if (value) {
            Bind bind (this, &UI_ExOrButtonGroup::_ModelChanged);
            _selection.RemoveDependent (bind);
            _selection = id; // The dependent removal is so that this
                             // assignment does not give us notification
            _selection.AddDependent (bind, 1);
            break;
        }
    }
}

