



#ifndef _vobjcoll_h_ /* Fri Nov 25 12:49:45 1994 */
#define _vobjcoll_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/visualob.h"
#include "ui/viewdesc.h"

#include "base/iterator.h"


class CL_EXPORT UI_VObjCollection: public UI_VisualObject {

public:
    // ------------------- View-related methods ---------------
    
    virtual bool Enable ();
    // Allow view to capture events. This overrides the inherited method;
    // the overriding code enables all descendants.

    virtual bool Disable ();
    // Prevent view from capturing events. This overrides the inherited
    // method; the overriding code disables all descendants.

    virtual void MakeInvisible ();
    // This overrides the inherited method with code that makes all
    // descendants invisible.
    
    virtual void MakeVisible ();
    // This overrides the inherited method with code that makes all
    // descendants visible.

    virtual UI_VisualObject* operator [] (UI_ViewID id);
    // Return a pointer to the child with the given ID. The return value
    // is NULL if there is no such child.
    
    long ChildCount ();
    // Return the number of children of this collection.

    bool Contains (UI_ViewID id);
    // Test whether the object with ID 'id' is a child of this
    // collection.

    virtual UI_WindowClass WindowClass () const;
    

    const char* ClassName() const { return "UI_VObjCollection";};



protected:
    
    // ---------------------- Construction ----------------------------

    UI_VObjCollection (UI_VObjCollection* parent,
                       const UI_Rectangle& shape, UI_ViewID id = -1);

    ~UI_VObjCollection ();

    virtual bool MakeVisualElement () = 0;
    
    // 
    // Method for child event inspection:
    // 

    virtual bool HandleChildEvent (const UI_Event& e) {return FALSE;};
    // This is a hook for inspecting and processing any event originating
    // in any of the contained objects that are passed up to this
    // VObjCollection. The default implementation simply returns
    // FALSE. It may be overridden in derived class for custom event handling.

    bool DestroyVisualElement ();

    bool _ModelChanged (CL_Object&, long);

    void _PrivateInitialize();


    friend class UI_Controller;
    friend class UI_VObjCollIterator;

    // 
    // Instance Variables:
    // 

    CL_IntPtrMap       _objMap;

public:
    virtual void AddChild    (UI_VisualObject* child);
    // [YACL internal use only]

    virtual UI_VisualObject* RemoveChild (UI_VisualObject* view);
    // [YACL internal use only]

    bool SetFont (UI_Font* font);
    // [YACL internal use only]

private:
    bool _PrivateHandleChildEvent (UI_Event& e);
    // The real child event gateway.
    
};






// The VObjCollIterator is a means of iterating over all the children of a
// VObjCollection. This object can only be created on a VObjCollection
// {\it after\/} the latter is initialized and ready for display.
//
// Warning: do not add or remove children from a VObjCollection while an
// iterator is active.


class UI_VObjCollIterator {

public:
    UI_VObjCollIterator (UI_VObjCollection& v);
    // Construct an iterator on the VObjCollection v.

    void Reset ();
    // Reset the iterator to the beginning.

    UI_VisualObject* Next ();
    // Return a pointer to the next child of our collection. Return NULL if
    // there are no more children.

    bool More ();
    
protected:
    CL_IntPtrMapIterator _itr;

};


#endif /* _vobjcoll_h_ */
