
#ifndef _uidefs_h_ /* Sat Dec 25 09:21:26 1993 */
#define _uidefs_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if !defined(__MS_WINDOWS__) && !defined(__X_MOTIF__) && !defined(__OS2__)
#error uidefs.h: unsupported platform
#endif

// --------------------- uidefs.h -----------------------------
//
//      Basic declarations for the user interface framework
//
// ------------------------------------------------------------



#include "base/defs.h"

// The View Id: a "persistent" way of identifying visual objects
typedef long UI_ViewID;

// The View Handle is a platform-specific handle to a VisualObject. Its
// typedef depends on platform. The WindowClass is a platform-specific
// typedef that establishes the class of window.

# if defined(__MS_WINDOWS__)
// ----------------- Windows-specific definitions: -----------------------

    typedef long            UI_ViewHandle;
    typedef const char*     UI_WindowClass;
    
#   define NativeEventStruct MSG
#   define BTNGROUP_PROPERTY1 "YACLBtnGrp1"
#   define BTNGROUP_PROPERTY2 "YACLBtnGrp2"

# elif defined(__OS2__)
#   define INCL_PM
#   include <os2.h>
    typedef QMSG          NativeEventStruct;
    typedef ulong         UI_ViewHandle;
    typedef const char*   UI_WindowClass;
    
# elif defined(__X_MOTIF__)
// -----------------    X-specific definitions: --------------------------

    extern "C" {
    // These are stolen from X11/Intrinsic.h. They might have to be fixed up
    // in future versions of X, if the definitions of "Widget" and
    // "WidgetClass" change. We refrain from including Intrinsic.h here so
    // as to minimize preprocessing time when compiling applications.
    struct _WidgetRec;
    struct _WidgetClassRec;
    }
    typedef _WidgetClassRec*   UI_WindowClass;
    typedef struct _WidgetRec* UI_ViewHandle;
#   define NativeEventStruct XEvent


#endif



// --------------------- Useful enumerations -----------------------

enum UI_TextStyle {UIText_Left, UIText_Right, UIText_Center};

// Standard id's of the buttons on  dialogs:
enum UI_StdButtonEnum {
    UI_IDOK = 1, UI_IDCANCEL, UI_IDYES,  UI_IDNO
};




// ----------------------- Misc stuff -----------------------------

extern char _YACLWindowClassName[]; // Defined in cntroler.cxx

#ifndef __MS_WINDOWS__
# define FAR    
#endif


#endif /* _uidefs_h_ */

