




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__GNUC__)
#pragma implementation
#endif


#include "base/binding.h"
#include "ui/strseq.h"
#include "ui/strview.h"

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_StringSequence>;
#endif


typedef CL_Binding<UI_StringSequence> SeqBind;

void UI_StringSequence::AddClient (UI_StringView* v)
{
    _clientSet.Add(v);
}



void UI_StringSequence::RemoveClient (UI_StringView* v)
{
    _clientSet.Remove (v);
}



bool UI_StringSequence::Update (CL_Object&, long index)
{
    _ChangeUpdate (index);
    return TRUE;
}






bool UI_StringSequence::Insert (const CL_String& s, long index)
{
    if (!CL_StringSequence::Insert (s, index))
        return FALSE;
    SeqBind b (this, &UI_StringSequence::Update);
    (*this)[index+1].AddDependent (b, index+1);
    _InsertionUpdate (index);
    _ReassignCodes ();
    return TRUE;
}


CL_String UI_StringSequence::Remove (long index)
{
    CL_String s = CL_StringSequence::Remove (index);
    _RemovalUpdate (index);
    _ReassignCodes ();
    return s;
}


bool UI_StringSequence::ShiftLeftAt  (long pos, long amount)
{
    if (!CL_StringSequence::ShiftLeftAt (pos, amount))
        return FALSE;
    _ReassignCodes ();
    return TRUE;
}

bool UI_StringSequence::ShiftRightAt (long pos, long amount)
{
    if (!CL_StringSequence::ShiftRightAt (pos, amount))
        return FALSE;
    _ReassignCodes ();
    return TRUE;
}




CL_Sequence<CL_String>& UI_StringSequence::operator=
    (const CL_Sequence<CL_String>& s)
{
    CL_ObjectSetIterator itr (_clientSet);
    while (itr.More())
        ((UI_StringView*) itr.Next())->ModelEmptied ();
    CL_Sequence<CL_String>::operator= (s);
    long n = s.Size();
    for (long i = 0; i < n; i++)
        _InsertionUpdate (i-1);
    _ReassignCodes();
    return *this;
}


void UI_StringSequence::MakeEmpty ()
{
    CL_ObjectSetIterator itr (_clientSet);
    while (itr.More())
        ((UI_StringView*) itr.Next())->ModelEmptied ();
}


CL_Sequence<CL_String>& UI_StringSequence::operator+=
    (const CL_Sequence<CL_String>& s)
{
    long n = Size();
    CL_Sequence<CL_String>::operator+= (s);
    long m = Size();
    for (long i = n; i < m; i++) {
        _InsertionUpdate (i-1);
    }
    _ReassignCodes();
    return *this;
}


#ifndef __GNUC__ // Temporarily disable these methods to work around
                 // the GCC bug
void UI_StringSequence::operator-= (const CL_IntegerSet& s)
{
    CL_IntegerSetIterator itr (s);
    long count = 0;
    while (itr.More()) {
        Remove (itr.Next() - count);
        // ----------------^^^^^^^
        // Needed to account for previously-deleted items
        count++;
    }
    _ReassignCodes();
}


#endif    // __GNUC__



bool UI_StringSequence::ChangeSize (long new_size)
{
    long n = Size();
    if (!CL_StringSequence::ChangeSize (new_size))
        return FALSE;
    if (new_size < n) {
        for (long i = new_size; i < n; i++)
            _RemovalUpdate (i);
    }
    else {
        for (long i = n; i < new_size; i++)
            _InsertionUpdate (i-1);
    }
    _ReassignCodes ();
    return TRUE;
}


bool UI_StringSequence::Sort (long pos, long len)
{
    if (!CL_StringSequence::Sort(pos, len))
        return FALSE;
    CL_ObjectSetIterator itr (_clientSet);
    while (itr.More())
        ((UI_StringView*) itr.Next())->ModelEmptied ();
    long n = Size();
    for (long i = 0; i < n; i++) {
        _InsertionUpdate (i-1);
    }
    _ReassignCodes();
    return TRUE;
}




void UI_StringSequence::_ReassignCodes ()
{
    long n = Size();
    SeqBind b (this, &UI_StringSequence::Update);
    for (long i = 0; i < n; i++)
        (*this)[i].PostChangeCode (b) = i;
}







void UI_StringSequence::_InsertionUpdate (long i)
{
    CL_ObjectSetIterator itr (_clientSet);

    itr.Reset();
    while (itr.More())
        ((UI_StringView*) itr.Next())->ItemInserted (i);
}

void UI_StringSequence::_RemovalUpdate (long i)
{
    CL_ObjectSetIterator itr (_clientSet);

    itr.Reset();
    while (itr.More())
        ((UI_StringView*) itr.Next())->ItemRemoved (i);
}

void UI_StringSequence::_ChangeUpdate (long i)
{
    CL_ObjectSetIterator itr (_clientSet);

    itr.Reset();
    while (itr.More())
        ((UI_StringView*) itr.Next())->ItemChanged(i);
}







