
#if defined(__GNUC__)
#pragma implementation
#endif



#include "base/defs.h"
#include "ui/uidefs.h"
#include "ui/stencil.h"


UI_Stencil::UI_Stencil (short w, short h)
{
    _width  = maxl (w, 1);
    _height = maxl (h, 1);
    _data   = new char [w * h];
}


UI_Stencil::UI_Stencil (const char data[], short w, short h)
{
    long size = w * h;
    _width  = maxl (w, 1);
    _height = maxl (h, 1);
    _data   = new char [w * h];
    if (!_data)
        return;
    for (long i = 0; i < size; i++)
        _data[i] = data[i];
}

UI_Stencil::UI_Stencil (const UI_Stencil& s)
{
    short w   = s._width;
    short h   = s._height;
    long size = w * h;
    _width  = maxl (w, 1);
    _height = maxl (h, 1);
    _data   = new char [w * h];
    if (!_data)
        return;
    for (long i = 0; i < size; i++)
        _data[i] = s._data[i];
}


UI_Stencil::~UI_Stencil ()
{
    delete [] _data;
}


char& UI_Stencil::Byte (short i, short j)
{
    static char c;
    if (!_data)
        return c; // No memory
    if (i >= 0 && i < _height && j >= 0 && j < _width)
        return _data[i * _width + j];
    CL_Error::Warning ("UI_Stencil::Byte : indexes (%d %d) out of "
                       "range (%d %d)", i, j, _width-1, _height-1);
    return c;
}



short UI_Stencil::Bit  (short i, short j) const
{
    if (!_data)
        return 0; // No memory
    if (i >= 0 && i < _height && j >= 0 && j < _width*8) {
        long index = i * _width + (j/8);
        return (_data[index] & (0x0080 >> (j % 8))) ? 1 : 0;
    }
    CL_Error::Warning ("UI_Stencil::Bit : indexes (%d %d) out of "
                       "range (%d %d)", i, j, 8*_width-1, _height-1);
    return 0;
}



