
#ifndef _printjob_h_ /* Wed Jan 18 21:09:15 1995 */
#define _printjob_h_



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// Author: M. A. Sridhar
// Date: Jan 19, 1995

// A PrintJob is a DrawingSurface whose commands draw on pages to be sent to
// the system printer. Each PrintJob is made up of one or more pages; any of
// the drawing operations can be invoked on it to draw on the current page.
// The {\tt StartNewPage} method terminates the 
// current page  and starts a new page. When the PrintJob object is destroyed,
// it is spooled to the system's printer.
//
// THIS IMPLEMENTATION IS CURRENTLY AVAILABLE ONLY UNDER MICROSOFT WINDOWS.



#if defined(__GNUC__)
#pragma interface
#endif


#include "ui/dwgsurf.h"

class CL_EXPORT UI_PrintJob: public UI_DrawingSurface {

public:
    UI_PrintJob (const char* jobName = "");
    // Start a new job with the given name.
    
    ~UI_PrintJob ();
    // Finish the job.

    bool StartNewPage ();
    // Start a new page.

    // 
    // Query:
    //     

    double HorzPixelsPerMM () const;
    // Return the number of pixels per millimeter in the horizontal direction.

    double VertPixelsPerMM () const;
    // Return the number of pixels per millimeter in the vertical direction.

    UI_Rectangle DrawingArea() const;
    // Returns the rectangle enclosing the print page, in pixels. The
    // origin is (0, 0).

    UI_Rectangle DrawingAreaInMM () const;
    // Returns the drawing area, in millimeters. The origin is (0, 0).

    bool SupportsColor () const;
    // Override inherited method.
    
    bool DrawBitmap (const UI_Bitmap& b, const UI_Point& topLeft);
    // Draw the given bitmap on this surface.


protected:
    double           _horzPPM;
    double           _vertPPM;

#if defined(__OS2__)
    HDC              _printDC;
    SIZEL            _drawingArea;
#endif
};


#endif /* _printjob_h_ */
