

#ifndef _graphic_h_ /* Fri Oct 28 17:18:04 1994 */
#define _graphic_h_



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


// GraphicObject is an abstract class representing a graphic object that can
// be drawn on a DrawingSurface.


#if defined(__GNUC__)
#pragma interface
#endif

#include "base/object.h"
#include "ui/point.h"

class CL_EXPORT UI_DrawingSurface;
class CL_EXPORT UI_Rectangle;

enum UI_HitTest {
    UIHit_Boundary, UIHit_Inside, UIHit_Outside
};


struct UI_PointPair {
    UI_PointPair (const UI_Point& p, const UI_Point& q) : p1 (p), p2(q) {};
    UI_PointPair () {};
    UI_Point p1, p2;
};

class CL_EXPORT UI_GraphicObject: public CL_Object {

public:

    ~UI_GraphicObject() {};
    
    virtual UI_Rectangle BoundingRectangle () const = 0;
    // Return the bounding rectangle for this graphic. [Pure virtual]

    virtual UI_Point Center () const;
    // Return the center of this GraphicObject. The default implementation
    // returns the center of the BoundingRectangle.
    
    virtual bool DrawOn (UI_DrawingSurface& sfc,
                         const UI_Point& p = UI_Point (0, 0)) const = 0;
    // [Pure virtual method] Draw the graphic on the given surface,
    // translated with respect to {\tt p} (i.e., treating {\tt p} as the
    // origin).

    virtual bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Grow or shrink the graphic so that the two given points become the
    // diagonally-opposing points of its bounding box. Return TRUE if
    // successful. The default implementation returns FALSE unconditionally.

    virtual bool Fill   (UI_DrawingSurface& s) const;
    // Fill the interior of the graphic on the given surface with the current
    // foreground color of the given surface. This operation makes sense
    // only for closed figures. The default implementation returns FALSE.

    virtual UI_HitTest HitTest (const UI_Point& p) const;
    // Tell whether the given point is inside, outside or on the boundary of
    // this graphic. The default implementation uses HitTest on the bounding
    // rectangle.

    virtual bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Tell whether the given rectangle intersects the boundary of this
    // GraphicObject. The default implementation uses the bounding
    // rectangle.

    virtual bool IsContainedIn (const UI_Rectangle& r) const;
    // Tell whether the given rectangle entirely contains this
    // GraphicObject. The default implementation returns whether this
    // object's bounding rectangle is contained in {\tt r}.

};

#endif /* _graphic_h_ */
