
#if defined(__GNUC__)
#pragma implementation
#endif


#include "ui/fontdesc.h"



UI_FontDesc::UI_FontDesc (const char* type_face, short point_size,
                          ulong style_enum)
: _typeFace (type_face), _ptSize (point_size), _style (style_enum)
{
}


UI_FontDesc::UI_FontDesc ()
{
}

void UI_FontDesc::operator= (const CL_Object& o)
{
    if (o.IsA (*this))
        *this = ((const UI_FontInfo&) o);
}


UI_FontDesc& UI_FontDesc::operator= (const UI_FontDesc& o)
{
    _typeFace    = o._typeFace;
    _ptSize      = o._ptSize;
    _style       = o._style;
    return *this;
}



short UI_FontDesc::Compare (const CL_Object& o) const
{
    if (o.IsA (*this))
        return Compare ((const UI_FontDesc&) o);
    return -1;
}

short UI_FontDesc::Compare (const UI_FontDesc& o) const
{
    short cmp = _typeFace.Compare (o._typeFace);
    if (!cmp) {
        if (_ptSize == o._ptSize) {
            if (_style == o._style)
                return 0;
            return _style < o._style ? -1 : 1;
        }
        return _ptSize < o._ptSize ? -1 : 1;
    }
    return cmp;
}





// -------------------------- UI_FontInfo --------------------------------


UI_FontInfo::UI_FontInfo ()
{
#if defined(__MS_WINDOWS__)
    _scalable = FALSE;
#endif

#if defined(__X_MOTIF__)
    _fixedWidth = TRUE;
#endif
}

UI_FontInfo::UI_FontInfo (const char* type_face, short point_size,
                          ulong style_enum, bool f)
: UI_FontDesc (type_face, point_size, style_enum)
{
    _scalable = f;

#if defined(__X_MOTIF__)
    _fixedWidth = !f; // ?? FIX THIS
#endif
}


short UI_FontInfo::Compare (const CL_Object& o) const
{
    if (o.IsA (*this))
        return Compare ((const UI_FontInfo&) o);
    return -1;
}

short UI_FontInfo::Compare (const UI_FontInfo& o) const
{
    short cmp = _typeFace.Compare (o._typeFace);
    if (!cmp) {
        if (_ptSize == o._ptSize) {
            if (_style == o._style) {
                if (_scalable == o._scalable)
                    return 0;
                return _scalable < o._scalable ? -1 : 1;
            }
            return _style < o._style ? -1 : 1;
        }
        return _ptSize < o._ptSize ? -1 : 1;
    }
    return cmp;
}


void UI_FontInfo::operator= (const CL_Object& o)
{
    if (o.IsA (*this))
        *this = ((const UI_FontInfo&) o);
}


UI_FontInfo& UI_FontInfo::operator= (const UI_FontInfo& o)
{
    UI_FontDesc::operator= (o);
#if defined(__MS_WINDOWS__)
    _scalable    = o._scalable;
#endif
#if defined(__X_MOTIF__)
    _fixedWidth  = o._fixedWidth;
    _realName    = o._realName;
#endif
    return *this;
}


CL_String UI_FontInfo::AsString () const
{
    
    CL_String s = "'" + _typeFace + "'";
    if (_scalable)
        s += " scalable";
    else
        s +=  " " + CL_String(_ptSize) + " points";
#if defined(__X_MOTIF__)
    s += " " + CL_String (_fixedWidth ? "(fixed) " : "(variable)");
#endif
    if (_style & UIFont_Italic)
        s += " italic";
    if (_style & UIFont_Underline)
        s += " underlined";
    if (_style & UIFont_BoldFace)
        s += " bold";
    if (_style & UIFont_StrikeOut)
        s += " strikeout";
    return s;
}

