


#ifndef _combobox_h_ /* Wed Feb 22 22:18:00 1995 */
#define _combobox_h_



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma interface
#endif

#include "ui/strview.h"

#if defined(__X_MOTIF__)
#error No combo boxes under Motif (yet)!
#endif

// This is a ComboBox, a combination StringEditor and StringView in which
// the StringView part functions as a drop-down list. A ComboBox is said to
// be {\it editable\/} if the user can type in a string in the StringEditor
// that is different from any of the strings in the drop-down list. If it is
// not editable, the ComboBox displays the current selection in a label.
//
// This class is {\it not yet\/} supported under Motif.


class CL_EXPORT UI_ComboBox: public UI_StringViewSingleSel {

public:
    UI_ComboBox (UI_VObjCollection* parent, const UI_Rectangle& shape,
                 UI_ViewID id, bool editable = FALSE);

    CL_String& EditString ();
    // Return the content of the edit string of the ComboBox. If this
    // ComboBox is editable, then this string is the one typed by the user,
    // and therefore is not necessarily a part of the model. If the
    // application modifies this  String, the content of the edit box is
    // correspondingly changed.

    void SetLengthLimit (short n);
    // Limit user type-in to the edit string to $n$ characters.
    
    virtual void  ShowDropDown ();
    // Show the drop-down list, if not currently shown.
    
    virtual void  HideDropDown ();
    // Hide the drop-down list, if not currently hidden.

    bool IsDropDownShowing() const;
    // Is the drop-down list currently showing?
    
    virtual long  TopIndex () const;
    // Return the index of the topmost visible string in the view.

    virtual short VisibleCount () const;
    // Return the number of visible strings. [Not yet implemented under
    // OS/2.]
    
    virtual void  ScrollTo (long index);
    // Scroll the view so that the String at the given index is at the top.
    
    
    // ---------------- Overridden SimpleVObject methods -------------

    virtual UI_WindowClass WindowClass () const;

    // ---------------- Overridden basic methods ---------------------
    
    const char* ClassName () const { return "UI_ComboBox";};


    
protected:

    virtual void _UpdateSelection ();
    // Called by {\tt ItemInserted} and {\tt ItemRemoved} to tell us
    // to update our selection.


    virtual void ItemInserted (long pos);
    //  [YACL internal use only] Called by the model to notify this view
    //  that the model just added a new item immediately  after the given
    //  position.

    virtual void ItemRemoved (long);
    // [YACL internal use only]

    virtual void ItemChanged (long);
    // [YACL internal use only]

    virtual void ModelEmptied ();
    // [YACL internal use only]
    
    virtual bool _SelectionChanged (CL_Object&, long);
    // [YACL internal use only] Called by the selection when it is modified
    // by the application.
    
#if defined(__MS_WINDOWS__)
    UI_ComboBox (UI_CompositeVObject* parent, UI_ViewID id,
                 UI_ViewHandle h);
    // [MS-Windows-specific] Resource-based construction.

#endif

    void  _PrivateInitialize ();

    bool Select ();

    virtual bool _EditStringChanged (CL_Object&, long);
    
protected:
    bool        _editable;
    CL_Integer  _selection;
    CL_String   _editString;
    short       _limit;
};

#endif /* _combobox_h_ */
