




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined(__GNUC__)
#pragma implementation
#endif



#include "ui/color.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined (__X_MOTIF__)
#include <X11/Xlib.h>

#endif



struct ColorStruct {
    double red, green, blue;
    ColorStruct (double r, double g, double b) : red(r), green(g), blue(b){};
};



static ColorStruct Colors (UI_ColorScheme c)
{
    switch(c) {
    case UIColor_Black:
        return ColorStruct (0, 0, 0);

    case UIColor_Red:
        return ColorStruct (1, 0, 0);

    case UIColor_Green:
        return ColorStruct (0, 1, 0);

    case UIColor_Blue:
        return ColorStruct (0, 0, 1);

    case UIColor_White:
        return ColorStruct (1, 1, 1);

    case UIColor_MediumGray:
        return ColorStruct (0.5, 0.5, 0.5);

    default:
        return ColorStruct (0, 0, 0);
    }
}




UI_Color::UI_Color ()
{
    _red = _green = _blue = 0;
    _colorVal = getColorVal (0, 0, 0);
}


UI_Color::UI_Color (UI_ColorScheme c)
{
    _colorVal  = getAbsVal (c);
    ColorStruct s = Colors (c);
    _red   = s.red;
    _blue  = s.blue;
    _green = s.green;
}


UI_Color::UI_Color(double r, double g, double b)
{
    if (r < 0 || r > 1) {
        CL_Error::Warning ("UI_Color constructor: invalid red component "
                           "%e", r);
        _red = _green = _blue = 0;
    }
    else if (g < 0 || g > 1) {
        CL_Error::Warning ("UI_Color constructor: invalid green component "
                           "%e", g);
        _red = _green = _blue = 0;
    }
    else if (b < 0 || b > 1) {
        CL_Error::Warning ("UI_Color constructor: invalid blue component "
                           "%e", b);
        _red = _green = _blue = 0;
    }
    else {
        _red      = r;
        _green    = g;
        _blue     = b;
    }
    _colorVal = getColorVal (_red, _green, _blue);
}


UI_Color::UI_Color (const UI_Color& c)
{
    _red      = c._red;
    _green    = c._green;
    _blue     = c._blue;
    _colorVal = c._colorVal;
}


void UI_Color::Red (double r)
{
    if (!PrepareToChange ())
        return;
    _red      = r;
    _colorVal = getColorVal (_red, _green, _blue);
    Notify ();
}


void UI_Color::Green (double g)
{
    if (!PrepareToChange())
        return;
    _green    = g;
    _colorVal = getColorVal (_red, _green, _blue);
    Notify();
}


void UI_Color::Blue (double b)
{
    if (!PrepareToChange())
        return;
    _blue     = b;
    _colorVal = getColorVal (_red, _green, _blue);
    Notify();
}


void UI_Color::Set (UI_ColorScheme c)
{
    if (!PrepareToChange())
        return;

    _colorVal = getAbsVal (c);
    Notify();
}


void UI_Color::operator= (const UI_Color& x)
{
    if (!PrepareToChange())
        return;

    _red       = x._red;
    _green     = x._green;
    _blue      = x._blue;
    _colorVal  = x._colorVal;
    Notify();
}


bool UI_Color::operator== (const UI_Color& o) const
{
#if defined(__MS_WINDOWS__) || defined(__OS2__)
    return _colorVal == o._colorVal;

#elif defined (__X_MOTIF__)
    bool retval = (_colorVal.red   == o._colorVal.red && 
                   _colorVal.green == o._colorVal.green &&
                   _colorVal.blue  == o._colorVal.blue ? TRUE : FALSE);
    return retval;
#endif
}


UI_NativeColorRep& UI_Color::NativeForm () const
{
    return (UI_NativeColorRep &) _colorVal;
}


UI_NativeColorRep UI_Color::getColorVal (double r, double g, double b)
{
#if defined(__MS_WINDOWS__)

    return RGB (255 * r, 255 * g, 255 * b); 

#elif defined(__OS2__)
    return ((ushort) (255*r) << 16) + ((ushort) (255*g) << 8) +
            ((ushort) (255*b));
            
#elif defined(__X_MOTIF__)
    _colorVal.red   = (short) (UI_MAXCOLORS * r);
    _colorVal.green = (short) (UI_MAXCOLORS * g);
    _colorVal.blue  = (short) (UI_MAXCOLORS * b);

    return _colorVal;
#endif

}


UI_NativeColorRep UI_Color::getAbsVal(UI_ColorScheme c)
{
    ColorStruct s = Colors (c);
    return getColorVal (s.red, s.green, s.blue);
}

