

#include <stdio.h>

#include "io/bytstore.h"
#include "base/base.h"

void main ()
{
    CL_ByteString buffer (100);
    CL_IntegerSet handles;
    
#if 1
    uchar* p = buffer.AsPtr();
    for (uchar c = 2; c < 100; c++)
        p[c-2] = c;
    CL_ByteStringStore store ("data.dat", TRUE);
    buffer = 1L;
    CL_SlottedFileHandle h = store.Add (buffer);
    store.Retrieve (h, buffer);
    buffer.ChangeSize (300);
    buffer (4, 4) = 8L;
    buffer (100, 4) = 16L;
    buffer.Suffix (104).SetAllBytesTo (33);
    bool b = store.Modify (h, buffer);
    printf ("Handle %lx buffer size %ld\n", h, buffer.Size());
    handles.Add (h);
    buffer.ChangeSize (0);
    store.Retrieve (h, buffer);

    buffer.ChangeSize (210);
    buffer.SetAllBytesTo (13);
    h = store.Add (buffer);
    printf ("Handle %lx buffer size %ld\n", h, buffer.Size());
    handles.Add (h);
    buffer.ChangeSize (0);
    store.Retrieve (h, buffer);
    
    buffer.ChangeSize (40);
    buffer.SetAllBytesTo (43);
    h = store.Add (buffer);
    printf ("Handle %lx buffer size %ld\n", h, buffer.Size());
    handles.Add (h);
    buffer.ChangeSize (0);
    store.Retrieve (h, buffer);
    
    buffer = 2L;
    CL_SlottedFileHandle h2 = store.Add (buffer);
    printf ("Handle %lx buffer size %ld\n", h2, buffer.Size());
    handles.Add (h2);
    store.Retrieve (h, buffer);
#else
    CL_ByteStringStore store ("data.dat");
    CL_SlottedFileHandle h;
#endif
    CL_ByteStoreIterator itr (store);
    itr.Reset();
    printf ("--------------\nBegin iteration:\n");
    do {
        h = itr.Next (buffer);
        printf ("Handle %lx buffer size %ld\n", h, buffer.Size());
    } while (h != 0);

    for (short i = 0; i < handles.Size(); i++) {
        h = handles.ItemWithRank(i);
        if (!store.Remove (h))
            printf ("Handle %lx removal failed\n", h);
        else {
            printf ("--------------After removing %lx:\n", h);
            CL_ByteStoreIterator itr (store);
            itr.Reset ();
            do {
                h = itr.Next (buffer);
                printf ("Handle %lx buffer size %ld\n", h, buffer.Size());
            } while (h != 0);
        }
    }

}
