
/*
 *@@sourcefile xwpadmin.c:
 *      This file contains SOM code for the following XWorkplace classes:
 *
 *      --  XWPAdmin ("XWorkplace Administrator" object, WPAbstract subclass)
 *
 *      This class implements the "XWorkplace Administrator"
 *      setting object, in which administrators may configure XWPShell.
 *
 *@@added V0.9.9 (2001-02-08) [umoeller]
 *@@somclass XWPAdmin adm_
 *@@somclass M_XWPAdmin admM_
 */

/*
 *      Copyright (C) 2001-2002 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_xwpadmin_Source
#define SOM_Module_xwpadmin_Source
#endif
#define XWPAdmin_Class_Source
#define M_XWPAdmin_Class_Source

#pragma strings(readonly)

/*
 *  Suggested #include order:
 *  1)  os2.h
 *  2)  C library headers
 *  3)  setup.h (code generation and debugging options)
 *  4)  headers in helpers\
 *  5)  at least one SOM implementation header (*.ih)
 *  6)  dlgids.h, headers in shared\ (as needed)
 *  7)  headers in implementation dirs (e.g. filesys\, as needed)
 *  8)  #pragma hdrstop and then more SOM headers which crash with precompiled headers
 */

#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_DOSQUEUES
#define INCL_DOSMODULEMGR
#define INCL_DOSERRORS

#define INCL_WINSTATICS
#define INCL_WINBUTTONS
#define INCL_WINSTDCNR
#include <os2.h>

// C library headers
#include <stdio.h>

// generic headers
#include "setup.h"                      // code generation and debugging options

// headers in /helpers
#include "helpers\cnrh.h"               // container helper routines
#include "helpers\dialog.h"             // dialog helpers
#include "helpers\standards.h"          // some standard macros
#include "helpers\stringh.h"            // string helper routines
#include "helpers\xstring.h"            // extended string helpers

// SOM headers which don't crash with prec. header files
#include "xwpadmin.ih"

// XWorkplace implementation headers
#include "dlgids.h"                     // all the IDs that are shared with NLS
#include "shared\common.h"              // the majestic XWorkplace include file
#include "shared\helppanels.h"          // all XWorkplace help panel IDs
#include "shared\kernel.h"              // XWorkplace Kernel
#include "shared\notebook.h"            // generic XWorkplace notebook handling
#include "shared\xsetup.h"              // XWPSetup implementation

#include "security\xwpsecty.h"          // XWorkplace Security base
#include "shared\xsecapi.h"             // XWorkplace Security API

// other SOM headers
#pragma hdrstop

/* ******************************************************************
 *
 *   Helpers
 *
 ********************************************************************/

/*
 *@@ Error:
 *
 *@@added V0.9.19 (2002-04-02) [umoeller]
 */

static VOID Error(WPObject *somSelf,
                  HWND hwndOwner,
                  APIRET arc)
{
    XSTRING str;
    xstrInit(&str, 0);
    cmnDescribeError(&str, arc, NULL, TRUE);
    cmnMessageBox(hwndOwner,
                  _wpQueryTitle(somSelf),
                  str.psz,
                  NULLHANDLE, // no help
                  MB_CANCEL);
}

/* ******************************************************************
 *
 *   Local User page
 *
 ********************************************************************/

#define LEFT_COLUMN     100
#define RIGHT_COLUMN    50

static const CONTROLDEF
    LocalUserGroup = LOADDEF_GROUP(ID_AMDI_USER_LOCAL_GROUP, SZL_AUTOSIZE),
    LocalUserNameTxt = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_USERNAME_TXT,
                            LEFT_COLUMN,
                            -1),
    LocalUserNameData = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_USERNAME_DATA,
                            RIGHT_COLUMN,
                            -1),
    LocalUserIDTxt = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_USERID_TXT,
                            LEFT_COLUMN,
                            -1),
    LocalUserIDData = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_USERID_DATA,
                            RIGHT_COLUMN,
                            -1),
    LocalGroupNameTxt = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_GROUPNAME_TXT,
                            LEFT_COLUMN,
                            -1),
    LocalGroupNameData = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_GROUPNAME_DATA,
                            RIGHT_COLUMN,
                            -1),
    LocalGroupIDTxt = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_GROUPID_TXT,
                            LEFT_COLUMN,
                            -1),
    LocalGroupIDData = CONTROLDEF_TEXT(
                            LOAD_STRING,
                            ID_AMDI_USER_GROUPID_DATA,
                            RIGHT_COLUMN,
                            -1);

static const DLGHITEM dlgLocalUser[] =
    {
        START_TABLE,            // root table, required
            START_ROW(0),       // row 1 in the root table, required
                // create group on top
                START_GROUP_TABLE(&LocalUserGroup),
                    START_ROW(ROW_VALIGN_CENTER),
                        CONTROL_DEF(&LocalUserNameTxt),
                        CONTROL_DEF(&LocalUserNameData),
                    START_ROW(ROW_VALIGN_CENTER),
                        CONTROL_DEF(&LocalUserIDTxt),
                        CONTROL_DEF(&LocalUserIDData),
                    START_ROW(ROW_VALIGN_CENTER),
                        CONTROL_DEF(&LocalGroupNameTxt),
                        CONTROL_DEF(&LocalGroupNameData),
                    START_ROW(ROW_VALIGN_CENTER),
                        CONTROL_DEF(&LocalGroupIDTxt),
                        CONTROL_DEF(&LocalGroupIDData),
                END_TABLE,
            START_ROW(0),       // notebook buttons (will be moved)
                CONTROL_DEF(&G_HelpButton),         // notebook.c
        END_TABLE
    };

/*
 *@@ admLocalUserInitPage:
 *
 */

VOID admLocalUserInitPage(PNOTEBOOKPAGE pnbp,   // notebook info struct
                          ULONG flFlags)        // CBI_* flags (notebook.h)
{
    if (flFlags & CBI_INIT)
    {
        // insert the controls using the dialog formatter
        ntbFormatPage(pnbp->hwndDlgPage,
                      dlgLocalUser,
                      ARRAYITEMCOUNT(dlgLocalUser));
    }

    if (flFlags & CBI_SET)
    {
        APIRET arc = NO_ERROR;
        XWPLOGGEDON LoggedOn;

        if (arc = xsecQueryLocalLoggedOn(&LoggedOn))
        {
            // error:
            CHAR szError[100];
            sprintf(szError, "Error %d", arc);
            WinSetDlgItemText(pnbp->hwndDlgPage,
                              ID_AMDI_USER_USERNAME_DATA,
                              szError);
        }
        else
        {
            WinSetDlgItemText(pnbp->hwndDlgPage,
                              ID_AMDI_USER_USERNAME_DATA,
                              LoggedOn.szUserName);
            WinSetDlgItemShort(pnbp->hwndDlgPage,
                               ID_AMDI_USER_USERID_DATA,
                               LoggedOn.uid,
                               FALSE);          // unsigned
            WinSetDlgItemText(pnbp->hwndDlgPage,
                              ID_AMDI_USER_GROUPNAME_DATA,
                              LoggedOn.szGroupName);
            WinSetDlgItemShort(pnbp->hwndDlgPage,
                               ID_AMDI_USER_GROUPID_DATA,
                               LoggedOn.gid,
                               FALSE);          // unsigned
        }
    }
}

/* ******************************************************************
 *
 *   All Users page
 *
 ********************************************************************/

typedef struct _USERRECORD
{
    RECORDCORE      recc;

    PSZ             pszFullName;
    PSZ             pszGroupName;

    XWPUSERDBENTRY  Entry;

} USERRECORD, *PUSERRECORD;

/*
 *@@ admAllUsersInitPage:
 *
 */

VOID admAllUsersInitPage(PNOTEBOOKPAGE pnbp,   // notebook info struct
                         ULONG flFlags)        // CBI_* flags (notebook.h)
{
    HWND hwndCnr = WinWindowFromID(pnbp->hwndDlgPage, ID_XFDI_CNR_CNR);

    if (flFlags & CBI_INIT)
    {
        XFIELDINFO xfi[5];
        PFIELDINFO pfi = NULL;
        int        i = 0;

        WinSetDlgItemText(pnbp->hwndDlgPage,
                          ID_XFDI_CNR_GROUPTITLE,
                          cmnGetString(ID_XSSI_ADMIN_ALL_USERS));

        // set up cnr details view
        xfi[i].ulFieldOffset = FIELDOFFSET(USERRECORD, Entry.uid);
        xfi[i].pszColumnTitle = "User ID";
        xfi[i].ulDataType = CFA_ULONG;
        xfi[i++].ulOrientation = CFA_RIGHT;

        xfi[i].ulFieldOffset = FIELDOFFSET(RECORDCORE, pszIcon);
        xfi[i].pszColumnTitle = "User name";
        xfi[i].ulDataType = CFA_STRING;
        xfi[i++].ulOrientation = CFA_LEFT;

        xfi[i].ulFieldOffset = FIELDOFFSET(USERRECORD, pszFullName);
        xfi[i].pszColumnTitle = "Full name";
        xfi[i].ulDataType = CFA_STRING;
        xfi[i++].ulOrientation = CFA_LEFT;

        xfi[i].ulFieldOffset = FIELDOFFSET(USERRECORD, Entry.gid);
        xfi[i].pszColumnTitle = "Group ID";
        xfi[i].ulDataType = CFA_ULONG;
        xfi[i++].ulOrientation = CFA_RIGHT;

        xfi[i].ulFieldOffset = FIELDOFFSET(USERRECORD, pszGroupName);
        xfi[i].pszColumnTitle = "Group name";
        xfi[i].ulDataType = CFA_STRING;
        xfi[i++].ulOrientation = CFA_LEFT;

        pfi = cnrhSetFieldInfos(hwndCnr,
                                xfi,
                                i,             // array item count
                                TRUE,          // draw lines
                                2);            // split bar after third column

        BEGIN_CNRINFO()
        {
            cnrhSetView(CV_DETAIL | CA_DETAILSVIEWTITLES);
            cnrhSetSplitBarAfter(pfi);
            cnrhSetSplitBarPos(250);
        } END_CNRINFO(hwndCnr);
    }

    if (flFlags & CBI_SET)
    {
        APIRET arc;
        ULONG cUsers;
        PXWPUSERDBENTRY paUsers;

        if (!(arc = xsecQueryUsers(&cUsers,
                                   &paUsers)))
        {
            PUSERRECORD preccFirst
                = (PUSERRECORD)cnrhAllocRecords(hwndCnr,
                                                sizeof(USERRECORD),
                                                cUsers);
            if (preccFirst)
            {
                PXWPUSERDBENTRY pUserThis = paUsers;
                PUSERRECORD preccThis = preccFirst;
                ULONG ul;
                for (ul = 0;
                     ul < cUsers;
                     ++ul)
                {
                    memcpy(&preccThis->Entry,
                           pUserThis,
                           sizeof(XWPUSERDBENTRY));

                    preccThis->recc.pszIcon = preccThis->Entry.szUserName;
                    preccThis->pszFullName = preccThis->Entry.szFullName;
                    preccThis->pszGroupName = preccThis->Entry.szGroupName;

                    ++pUserThis;
                    preccThis = (PUSERRECORD)preccThis->recc.preccNextRecord;
                }

                cnrhInsertRecords(hwndCnr,
                                  NULL,
                                  (PRECORDCORE)preccFirst,
                                  TRUE, // invalidate
                                  NULL,
                                  CRA_RECORDREADONLY,
                                  cUsers);
            }

            free(paUsers);
        }
        else
            Error(pnbp->inbp.somSelf, pnbp->hwndDlgPage, arc);
    }
}

/* ******************************************************************
 *
 *   All Groups page
 *
 ********************************************************************/

typedef struct _GROUPRECORD
{
    RECORDCORE      recc;

    XWPSECID        gid;
    PSZ             pszGroupName;
    CHAR            szGroupName[XWPSEC_NAMELEN];    // group name

} GROUPRECORD, *PGROUPRECORD;

/*
 *@@ admAllGroupsInitPage:
 *
 */

VOID admAllGroupsInitPage(PNOTEBOOKPAGE pnbp,   // notebook info struct
                         ULONG flFlags)        // CBI_* flags (notebook.h)
{
    HWND hwndCnr = WinWindowFromID(pnbp->hwndDlgPage, ID_XFDI_CNR_CNR);

    if (flFlags & CBI_INIT)
    {
        XFIELDINFO xfi[3];
        PFIELDINFO pfi = NULL;
        int        i = 0;

        WinSetDlgItemText(pnbp->hwndDlgPage,
                          ID_XFDI_CNR_GROUPTITLE,
                          cmnGetString(ID_XSSI_ADMIN_ALL_GROUPS));

        // set up cnr details view
        xfi[i].ulFieldOffset = FIELDOFFSET(GROUPRECORD, gid);
        xfi[i].pszColumnTitle = "Group ID";
        xfi[i].ulDataType = CFA_ULONG;
        xfi[i++].ulOrientation = CFA_RIGHT;

        xfi[i].ulFieldOffset = FIELDOFFSET(GROUPRECORD, pszGroupName);
        xfi[i].pszColumnTitle = "Group name";
        xfi[i].ulDataType = CFA_STRING;
        xfi[i++].ulOrientation = CFA_LEFT;

        pfi = cnrhSetFieldInfos(hwndCnr,
                                xfi,
                                i,             // array item count
                                TRUE,          // draw lines
                                0);            // return first column

        BEGIN_CNRINFO()
        {
            cnrhSetView(CV_DETAIL | CA_DETAILSVIEWTITLES);
        } END_CNRINFO(hwndCnr);
    }

    if (flFlags & CBI_SET)
    {
        APIRET arc;
        ULONG cGroups;
        PXWPGROUPDBENTRY paGroups;

        if (!(arc = xsecQueryGroups(&cGroups,
                                   &paGroups)))
        {
            PGROUPRECORD preccFirst
                = (PGROUPRECORD)cnrhAllocRecords(hwndCnr,
                                                sizeof(GROUPRECORD),
                                                cGroups);
            if (preccFirst)
            {
                PXWPGROUPDBENTRY pGroupThis = paGroups;
                PGROUPRECORD preccThis = preccFirst;
                ULONG ul;
                for (ul = 0;
                     ul < cGroups;
                     ++ul)
                {
                    preccThis->gid = pGroupThis->gid;

                    memcpy(preccThis->szGroupName,
                           pGroupThis->szGroupName,
                           sizeof(preccThis->szGroupName));
                    preccThis->pszGroupName = preccThis->szGroupName;

                    ++pGroupThis;
                    preccThis = (PGROUPRECORD)preccThis->recc.preccNextRecord;
                }

                cnrhInsertRecords(hwndCnr,
                                  NULL,
                                  (PRECORDCORE)preccFirst,
                                  TRUE, // invalidate
                                  NULL,
                                  CRA_RECORDREADONLY,
                                  cGroups);
            }

            free(paGroups);
        }
        else
            Error(pnbp->inbp.somSelf, pnbp->hwndDlgPage, arc);
    }
}

/* ******************************************************************
 *
 *   XWPAdmin instance methods
 *
 ********************************************************************/

/*
 *@@ xwpAddXWPAdminPages:
 *      this actually adds the new pages into the
 *      "XWorkplace Administrator" notebook.
 */

SOM_Scope ULONG  SOMLINK adm_xwpAddXWPAdminPages(XWPAdmin *somSelf,
                                                 HWND hwndDlg)
{
    ULONG   ulrc;
    INSERTNOTEBOOKPAGE  inbp;
    HMODULE             savehmod = cmnQueryNLSModuleHandle(FALSE);
    PID                 pidXWPShell;
    HQUEUE              hqXWPShell;

    /* XWPAdminData *somThis = XWPAdminGetData(somSelf); */
    XWPAdminMethodDebug("XWPAdmin","adm_xwpAddXWPAdminPages");

    memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
    inbp.somSelf = somSelf;
    inbp.hwndNotebook = hwndDlg;
    inbp.hmod = savehmod;

    // check if XWPShell is running; if so the queue must exist
    if (DosOpenQueue(&pidXWPShell,
                     &hqXWPShell,
                     QUEUE_XWPSHELL))
    {
        // error: display XWP page only then
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = "XWorkplace";
        inbp.ulDlgID = ID_XCD_FIRST;
        inbp.ulPageID = SP_SETUP_XWPLOGO;
        inbp.pfncbInitPage    = setLogoInitPage;
        inbp.pfncbMessage = setLogoMessages;
        ulrc = ntbInsertPage(&inbp);
    }
    else
    {
        // XWPShell running:
        DosCloseQueue(hqXWPShell);

        // all groups
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_ADMIN_ALL_GROUPS);
        inbp.ulDlgID = ID_XFD_CONTAINERPAGE;
        inbp.ulDefaultHelpPanel  = ID_XSH_ADMIN_ALL_GROUPS;
        inbp.ulPageID = SP_ADMIN_ALL_GROUPS;
        inbp.pampControlFlags = G_pampGenericCnrPage;
        inbp.cControlFlags = G_cGenericCnrPage;
        inbp.pfncbInitPage    = admAllGroupsInitPage;
        ntbInsertPage(&inbp);

        // all users
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_ADMIN_ALL_USERS);
        inbp.ulDlgID = ID_XFD_CONTAINERPAGE;
        inbp.ulDefaultHelpPanel  = ID_XSH_ADMIN_ALL_USERS;
        inbp.ulPageID = SP_ADMIN_ALL_USERS;
        inbp.pampControlFlags = G_pampGenericCnrPage;
        inbp.cControlFlags = G_cGenericCnrPage;
        inbp.pfncbInitPage    = admAllUsersInitPage;
        ntbInsertPage(&inbp);

        // current local user
        inbp.ulDlgID = ID_XFD_EMPTYDLG; // ID_AMD_USER;
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_ADMIN_LOCAL_USER);
        inbp.ulDefaultHelpPanel  = ID_XSH_ADMIN_LOCAL_USER;
        inbp.ulPageID = SP_ADMIN_LOCAL_USER;
        inbp.pampControlFlags = NULL;
        inbp.cControlFlags = 0;
        inbp.pfncbInitPage    = admLocalUserInitPage;
        ulrc = ntbInsertPage(&inbp);

    }

    return ulrc;
}

/*
 *@@ wpFilterPopupMenu:
 *      this WPObject instance method allows the object to
 *      filter out unwanted menu items from the context menu.
 *      This gets called before wpModifyPopupMenu.
 */

SOM_Scope ULONG  SOMLINK adm_wpFilterPopupMenu(XWPAdmin *somSelf,
                                               ULONG ulFlags,
                                               HWND hwndCnr,
                                               BOOL fMultiSelect)
{
    /* XWPAdminData *somThis = XWPAdminGetData(somSelf); */
    XWPAdminMethodDebug("XWPAdmin","adm_wpFilterPopupMenu");

    return (XWPAdmin_parent_WPAbstract_wpFilterPopupMenu(somSelf,
                                                         ulFlags,
                                                         hwndCnr,
                                                         fMultiSelect)
            & ~CTXT_NEW
           );
}

/*
 *@@ wpQueryDefaultView:
 *      this WPObject method returns the default view of an object,
 *      that is, which view is opened if the program file is
 *      double-clicked upon. This is also used to mark
 *      the default view in the "Open" context submenu.
 *
 *      This must be overridden for direct WPAbstract subclasses,
 *      because otherwise double-clicks on the object won't
 *      work.
 */

SOM_Scope ULONG  SOMLINK adm_wpQueryDefaultView(XWPAdmin *somSelf)
{
    /* XWPAdminData *somThis = XWPAdminGetData(somSelf); */
    XWPAdminMethodDebug("XWPAdmin","adm_wpQueryDefaultView");

    return (OPEN_SETTINGS);     // settings view is default
}

/*
 *@@ wpAddObjectWindowPage:
 *      this WPObject instance method normally adds the
 *      "Standard Options" page to the settings notebook
 *      (that's what the WPS reference calls it; it's actually
 *      the "Window" page).
 *
 *      We don't want that page here, so we remove it.
 */

SOM_Scope ULONG  SOMLINK adm_wpAddObjectWindowPage(XWPAdmin *somSelf,
                                                   HWND hwndNotebook)
{
    /* XWPAdminData *somThis = XWPAdminGetData(somSelf); */
    XWPAdminMethodDebug("XWPAdmin","adm_wpAddObjectWindowPage");

    return SETTINGS_PAGE_REMOVED;
}

/*
 *@@ wpAddSettingsPages:
 *      this WPObject instance method gets called by the WPS
 *      when the Settings view is opened to have all the
 *      settings page inserted into hwndNotebook.
 *
 *      We add the various new pages here.
 */

SOM_Scope BOOL  SOMLINK adm_wpAddSettingsPages(XWPAdmin *somSelf,
                                               HWND hwndNotebook)
{
    /* XWPAdminData *somThis = XWPAdminGetData(somSelf); */
    XWPAdminMethodDebug("XWPAdmin","adm_wpAddSettingsPages");

    XWPAdmin_parent_WPAbstract_wpAddSettingsPages(somSelf,
                                                  hwndNotebook);

    // add XWorkplace pages on top
    _xwpAddXWPAdminPages(somSelf, hwndNotebook);

    return TRUE;
}

/* ******************************************************************
 *
 *   XWPAdmin instance methods
 *
 ********************************************************************/

/*
 *@@ wpclsInitData:
 *      this WPObject class method gets called when a class
 *      is loaded by the WPS (probably from within a
 *      somFindClass call) and allows the class to initialize
 *      itself.
 */

SOM_Scope void  SOMLINK admM_wpclsInitData(M_XWPAdmin *somSelf)
{
    /* M_XWPAdminData *somThis = M_XWPAdminGetData(somSelf); */
    M_XWPAdminMethodDebug("M_XWPAdmin","admM_wpclsInitData");

    M_XWPAdmin_parent_M_WPAbstract_wpclsInitData(somSelf);
}

/*
 * wpclsQueryStyle:
 *      prevent copy, delete, print.
 *
 *@@changed V0.9.16 (2001-11-25) [umoeller]: added nevertemplate
 */

SOM_Scope ULONG  SOMLINK admM_wpclsQueryStyle(M_XWPAdmin *somSelf)
{
    /* M_XWPAdminData *somThis = M_XWPAdminGetData(somSelf); */
    M_XWPAdminMethodDebug("M_XWPAdmin","admM_wpclsQueryStyle");

    return (M_XWPAdmin_parent_M_WPAbstract_wpclsQueryStyle(somSelf)
                | CLSSTYLE_NEVERTEMPLATE        // V0.9.16 (2001-11-25) [umoeller]
                | CLSSTYLE_NEVERPRINT
                | CLSSTYLE_NEVERCOPY
                | CLSSTYLE_NEVERDELETE);
}

/*
 *@@ wpclsQueryTitle:
 *      this WPObject class method tells the WPS the clear
 *      name of a class, which is shown in the third column
 *      of a Details view and also used as the default title
 *      for new objects of a class.
 */

SOM_Scope PSZ  SOMLINK admM_wpclsQueryTitle(M_XWPAdmin *somSelf)
{
    // PNLSSTRINGS pNLSStrings = cmnQueryNLSStrings();
    /* M_XWPAdminData *somThis = M_XWPAdminGetData(somSelf); */
    M_XWPAdminMethodDebug("M_XWPAdmin","admM_wpclsQueryTitle");

    return (cmnGetString(ID_XSSI_ADMINISTRATOR)) ; // pszAdministrator
}

/*
 *@@ wpclsQueryDefaultHelp:
 *      this WPObject class method returns the default help
 *      panel for objects of this class. This gets called
 *      from WPObject::wpQueryDefaultHelp if no instance
 *      help settings (HELPLIBRARY, HELPPANEL) have been
 *      set for an individual object. It is thus recommended
 *      to override this method instead of the instance
 *      method to change the default help panel for a class
 *      in order not to break instance help settings (fixed
 *      with 0.9.20).
 *
 *@@added V0.9.20 (2002-07-12) [umoeller]
 */

SOM_Scope BOOL  SOMLINK admM_wpclsQueryDefaultHelp(M_XWPAdmin *somSelf,
                                                   PULONG pHelpPanelId,
                                                   PSZ pszHelpLibrary)
{
    /* M_XWPAdminData *somThis = M_XWPAdminGetData(somSelf); */
    M_XWPAdminMethodDebug("M_XWPAdmin","admM_wpclsQueryDefaultHelp");

    return (M_XWPAdmin_parent_M_WPAbstract_wpclsQueryDefaultHelp(somSelf,
                                                                 pHelpPanelId,
                                                                 pszHelpLibrary));
}

/*
 *@@ wpclsQueryIconData:
 *      this WPObject class method must return information
 *      about how to build the default icon for objects
 *      of a class. This gets called from various other
 *      methods whenever a class default icon is needed;
 *      most importantly, M_WPObject::wpclsQueryIcon
 *      calls this to build a class default icon, which
 *      is then cached in the class's instance data.
 *      If a subclass wants to change a class default icon,
 *      it should always override _this_ method instead of
 *      wpclsQueryIcon.
 *
 *      Note that the default WPS implementation does not
 *      allow for specifying the ICON_FILE format here,
 *      which is why we have overridden
 *      M_XFldObject::wpclsQueryIcon too. This allows us
 *      to return icon _files_ for theming too. For details
 *      about the WPS's crappy icon management, refer to
 *      src\filesys\icons.c.
 *
 *      We override this to give XWPAdmin objects a new
 *      icon (src\shared\xwpadmin.ico).
 */

SOM_Scope ULONG  SOMLINK admM_wpclsQueryIconData(M_XWPAdmin *somSelf,
                                                 PICONINFO pIconInfo)
{
    /* M_XWPAdminData *somThis = M_XWPAdminGetData(somSelf); */
    M_XWPAdminMethodDebug("M_XWPAdmin","admM_wpclsQueryIconData");

    if (pIconInfo)
    {
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->resid   = ID_ICONXWPADMIN;
        pIconInfo->hmod    = cmnQueryMainResModuleHandle();
    }

    return (sizeof(ICONINFO));
}

/*
 *@@ wpclsQuerySettingsPageSize:
 *      this WPObject class method should return the
 *      size of the largest settings page in dialog
 *      units; if a settings notebook is initially
 *      opened, i.e. no window pos has been stored
 *      yet, the WPS will use this size, to avoid
 *      truncated settings pages.
 */

SOM_Scope BOOL  SOMLINK admM_wpclsQuerySettingsPageSize(M_XWPAdmin *somSelf,
                                                        PSIZEL pSizl)
{
    /* M_XWPAdminData *somThis = M_XWPAdminGetData(somSelf); */
    M_XWPAdminMethodDebug("M_XWPAdmin","admM_wpclsQuerySettingsPageSize");

    return (M_XWPAdmin_parent_M_WPAbstract_wpclsQuerySettingsPageSize(somSelf,
                                                                      pSizl));
}

