
/*
 *@@sourcefile xfwps.c:
 *      This file contains SOM code for the following XWorkplace classes:
 *
 *      --  XFldWPS SOM stuff (WPSystem subclass)
 *
 *      This class implements the "Workplace Shell" settings
 *      object.
 *
 *      Installation of this class is optional, but you won't
 *      be able to change XWorkplace's settings without it.
 *
 *      This class used to be in xfsys.c (together with XFldSystem,
 *      the "OS/2 Kernel" object), but has been moved here for
 *      clarity with V0.9.0.
 *
 *      Starting with V0.9.0, the files in classes\ contain only
 *      i.e. the methods themselves.
 *      The implementation for this class is in several files in
 *      filesys\; check the function prefixes to find out where.
 *
 *@@somclass XFldWPS xwp_
 *@@somclass M_XFldWPS xwpM_
 */

/*
 *      Copyright (C) 1997-2002 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_xfwps_Source
#define SOM_Module_xfwps_Source
#endif
#define xfwps_Class_Source
#define M_xfwps_Class_Source

#pragma strings(readonly)

/*
 *  Suggested #include order:
 *  1)  os2.h
 *  2)  C library headers
 *  3)  setup.h (code generation and debugging options)
 *  4)  headers in helpers\
 *  5)  at least one SOM implementation header (*.ih)
 *  6)  dlgids.h, headers in shared\ (as needed)
 *  7)  headers in implementation dirs (e.g. filesys\, as needed)
 *  8)  #pragma hdrstop and then more SOM headers which crash with precompiled headers
 */

#define INCL_DOSSEMAPHORES
#define INCL_DOSMODULEMGR
#define INCL_WINMENUS
#include <os2.h>

// C library headers
#include <stdio.h>              // needed for except.h

// generic headers
#include "setup.h"                      // code generation and debugging options

// headers in /helpers
#include "helpers\dosh.h"               // Control Program helper routines

// SOM headers which don't crash with prec. header files
#include "xfwps.ih"
#include "xfldr.ih"

// XWorkplace implementation headers
#include "dlgids.h"                     // all the IDs that are shared with NLS
#include "shared\common.h"              // the majestic XWorkplace include file
#include "shared\helppanels.h"          // all XWorkplace help panel IDs
#include "shared\kernel.h"              // XWorkplace Kernel
#include "shared\notebook.h"            // generic XWorkplace notebook handling

#include "filesys\filetype.h"           // extended file types implementation
#include "filesys\folder.h"             // XFolder implementation
#include "filesys\fdrmenus.h"           // shared folder menu logic
#include "filesys\statbars.h"           // status bar translation logic

// other SOM headers
#pragma hdrstop                         // VAC++ keeps crashing otherwise

/* ******************************************************************
 *
 *   here come the XFldWPS instance methods
 *
 ********************************************************************/

/*
 *@@ xwpAddWPSMenuPages:
 *      called indirectly from XFldWPS::xwpAddXFldWPSPages.
 *
 *@@added V0.9.16 (2001-10-08) [umoeller]
 *@@changed V0.9.16 (2001-10-23) [umoeller]: fixed page subtitles
 *@@changed V0.9.19 (2002-04-17) [umoeller]: extracted to mnuAddWPSMenuPages
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSMenuPages(XFldWPS *somSelf,
                                                HWND hwndDlg)
{
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSMenuPages");

    return mnuAddWPSMenuPages(somSelf, hwndDlg);
}

/*
 *@@ xwpAddWPSFdrViewsPage:
 *      called indirectly from XFldWPS::xwpAddXFldWPSPages.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSFdrViewsPage(XFldWPS *somSelf,
                                                     HWND hwndDlg,
                                                     BOOL fMajor)
{
    INSERTNOTEBOOKPAGE inbp;
    HMODULE         savehmod = cmnQueryNLSModuleHandle(FALSE);
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSFdrViewsPage");

    memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
    inbp.somSelf = somSelf;
    inbp.hwndNotebook = hwndDlg;
    inbp.hmod = savehmod;
    inbp.usPageStyleFlags = (fMajor) ? BKA_MAJOR : BKA_MINOR;
    inbp.fEnumerate = TRUE;
    inbp.pcszName = cmnGetString(ID_XSSI_WPSFDRVIEWPAGE);  // V0.9.16(2001-11-04) [umoeller]
    inbp.ulDlgID = ID_XFD_EMPTYDLG;           // V0.9.16 (2001-09-29) [umoeller]
    inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS1;
    inbp.ulPageID = SP_WPS_FOLDERVIEWS;
    inbp.pfncbInitPage    = fdrViewInitPage;
    inbp.pfncbItemChanged = fdrViewItemChanged;
    return ntbInsertPage(&inbp);
}

/*
 *@@ xwpAddWPSFdrHotkeysPage:
 *      called indirectly from XFldWPS::xwpAddXFldWPSPages.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSFdrHotkeysPage(XFldWPS *somSelf,
                                                     HWND hwndDlg)
{
    ULONG ulrc = SETTINGS_PAGE_REMOVED;
    INSERTNOTEBOOKPAGE inbp;
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSFdrHotkeysPage");

    // insert "Hotkeys" page
#ifndef __ALWAYSFDRHOTKEYS__
    if (cmnQuerySetting(sfFolderHotkeys))
#endif
    {
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndDlg;
        inbp.hmod = cmnQueryNLSModuleHandle(FALSE);
        inbp.ulDlgID = ID_XSD_SET4ACCELS;
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_4ACCELERATORS);  // psz4Accelerators
        inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS1+5;
        inbp.ulPageID = SP_4ACCELERATORS;
        inbp.pfncbInitPage    = fdrHotkeysInitPage;
        inbp.pfncbItemChanged = fdrHotkeysItemChanged;
        ulrc = ntbInsertPage(&inbp);
    }

    return ulrc;
}

/*
 *@@ xwpAddWPSFdrSnap2GridPage:
 *      called indirectly from XFldWPS::xwpAddXFldWPSPages.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSFdrSnap2GridPage(XFldWPS *somSelf,
                                                       HWND hwndDlg)
{
    INSERTNOTEBOOKPAGE inbp;
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSFdrSnap2GridPage");

    // insert "Snap to grid" page
#ifndef __NOSNAPTOGRID__
    if (cmnQuerySetting(sfSnap2Grid))
    {
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndDlg;
        inbp.hmod = cmnQueryNLSModuleHandle(FALSE);
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_3SNAPTOGRID);  // psz3SnapToGrid
        inbp.ulDlgID = ID_XSD_SET3SNAPTOGRID;
        inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS1+4;
        inbp.ulPageID = SP_3SNAPTOGRID;
        inbp.pfncbInitPage    = fdrGridInitPage;
        inbp.pfncbItemChanged = fdrGridItemChanged;
        return ntbInsertPage(&inbp);
    }
#endif

    return SETTINGS_PAGE_REMOVED;
}

/*
 *@@ xwpAddWPSFdrStatusBarPages:
 *      called indirectly from XFldWPS::xwpAddXFldWPSPages.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSFdrStatusBarPages(XFldWPS *somSelf,
                                                        HWND hwndDlg)
{
    ULONG ulrc = SETTINGS_PAGE_REMOVED;
    INSERTNOTEBOOKPAGE inbp;
    HMODULE         savehmod = cmnQueryNLSModuleHandle(FALSE);
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSFdrStatusBarPages");

    /*
     * "Status bar" pages
     */

    if (
#ifndef __ALWAYSSUBCLASS__
            (!cmnQuerySetting(sfNoSubclassing))
#else
        1
#endif
        &&
#ifndef __NOCFGSTATUSBARS__
            (cmnQuerySetting(sfStatusBars))
#else
        1
#endif
       )
    {
#ifndef __NOCFGSTATUSBARS__
        // insert "Status bar" page 2
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndDlg;
        inbp.hmod = savehmod;
        inbp.usPageStyleFlags = BKA_MINOR;
        inbp.fEnumerate = TRUE;
        // inbp.pcszName = cmnGetString(ID_XSSI_27STATUSBAR);  // psz27StatusBar
            // this is page 2, don't give it a title (context menu)
            // V0.9.16 (2001-10-23) [umoeller]
        inbp.ulDlgID = ID_XSD_SET28STATUSBARS2;
        inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS_SB2;
        inbp.ulPageID = SP_28STATUSBAR2;
        inbp.pfncbInitPage    = stbStatusBar2InitPage;
        inbp.pfncbItemChanged = stbStatusBar2ItemChanged;
        ntbInsertPage(&inbp);
#endif

        // insert "Status bar" page 1
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndDlg;
        inbp.hmod = savehmod;
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.fEnumerate = TRUE;
        inbp.pcszName = cmnGetString(ID_XSSI_27STATUSBAR);  // psz27StatusBar
        inbp.ulDlgID = ID_XFD_EMPTYDLG; // ID_XSD_SET27STATUSBARS; V0.9.19 (2002-04-24) [umoeller]
        inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS1+3;
        inbp.ulPageID = SP_27STATUSBAR;
        inbp.pfncbInitPage    = stbStatusBar1InitPage;
        inbp.pfncbItemChanged = stbStatusBar1ItemChanged;
        ulrc = ntbInsertPage(&inbp);
    }

    return ulrc;
}

/*
 *@@ xwpAddWPSFdrSortPage:
 *      called indirectly from XFldWPS::xwpAddXFldWPSPages.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSFdrSortPage(XFldWPS *somSelf,
                                                  HWND hwndDlg)
{
    ULONG ulrc = SETTINGS_PAGE_REMOVED;
    INSERTNOTEBOOKPAGE inbp;
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSFdrSortPage");

    // insert "Sort" page
#ifndef __ALWAYSEXTSORT__
    if (cmnQuerySetting(sfExtendedSorting))
#endif
    {
        // extended sorting enabled:
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndDlg;
        inbp.hmod = cmnQueryNLSModuleHandle(FALSE);
        inbp.ulDlgID = ID_XSD_SETTINGS_FLDRSORT;
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_SORT);  // pszSort
        inbp.ulDefaultHelpPanel  = ID_XSH_SORTPAGE;
                        // changed V0.9.12 (2001-05-20) [umoeller]
        // mark this page as "global", because both
        // the instance settings notebook and the
        // "Workplace Shell" object use the same
        // callbacks
        inbp.ulPageID = SP_FLDRSORT_GLOBAL;
        inbp.pfncbInitPage    = fdrSortInitPage;
        inbp.pfncbItemChanged = fdrSortItemChanged;
        ulrc = ntbInsertPage(&inbp);
    }

    return ulrc;
}

/*
 *@@ xwpAddXFldWPSPages:
 *      called from XFldWPS::wpInsertSettingsPage to have
 *      a bunch of settings pages inserted into the
 *      middle of the settings notebook.
 *
 *      If our hack in that method failed, this gets called
 *      from XFldWPS::wpAddSettingsPages (Warp 3 probably).
 *
 *      This is only a method so that we don't have to
 *      duplicate the code. With V0.9.19, this only calls
 *      the other methods in the correct order any more.
 *
 *@@changed V0.9.0 [umoeller]: added "File types" page, removed "XFolder" pages
 *@@changed V0.9.6 (2000-10-16) [umoeller]: made "File types" resizeable
 *@@changed V0.9.19 (2002-04-17) [umoeller]: extracted all the other xwpAdd* methods
 *@@changed V0.9.19 (2002-04-17) [umoeller]: this no longer adds all pages
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddXFldWPSPages(XFldWPS *somSelf,
                                                HWND hwndNotebook)
{
    ULONG ulrc;
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddXFldWPSPages");

    if (    (ulrc = _xwpAddWPSMenuPages(somSelf, hwndNotebook))
         && (ulrc = _xwpAddWPSFdrSortPage(somSelf, hwndNotebook))
         && (ulrc = _xwpAddWPSFdrHotkeysPage(somSelf, hwndNotebook))
         && (ulrc = _xwpAddWPSFdrSnap2GridPage(somSelf, hwndNotebook))
         && (ulrc = _xwpAddWPSFdrStatusBarPages(somSelf, hwndNotebook))
         && (ulrc = _xwpAddWPSFdrViewsPage(somSelf, hwndNotebook, TRUE))
       )
        return TRUE;

    return FALSE;
}

/*
 *@@ xwpAddWPSFileTypesPage:
 *      called directly from XFldWPS::wpAddSettingsPages
 *      to have the file types page inserted on top.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_xwpAddWPSFileTypesPage(XFldWPS *somSelf,
                                                    HWND hwndDlg)
{
    INSERTNOTEBOOKPAGE inbp;
    // XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_xwpAddWPSFileTypesPage");

    /*
     * "File types" page (new with V0.9.0)
     */

#ifndef __NEVEREXTASSOCS__
    if (cmnQuerySetting(sfExtAssocs))
    {
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndDlg;
        inbp.hmod = cmnQueryNLSModuleHandle(FALSE);
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_FILETYPESPAGE);  // pszFileTypesPage
        inbp.ulDlgID = ID_XFD_EMPTYDLG;       // ID_XSD_FILETYPES;  V0.9.20 (2002-08-04) [umoeller]
        inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS_FILETYPES;
        inbp.ulPageID = SP_FILETYPES;
        inbp.pampControlFlags = G_pampFileTypesPage;
        inbp.cControlFlags = G_cFileTypesPage;
        inbp.pfncbInitPage    = ftypFileTypesInitPage;
        inbp.pfncbItemChanged = ftypFileTypesItemChanged;
        return ntbInsertPage(&inbp);
    }
#endif

    return SETTINGS_PAGE_REMOVED;
}

/*
 *@@ wpFilterPopupMenu:
 *      this WPObject instance method allows the object to
 *      filter out unwanted menu items from the context menu.
 *      This gets called before wpModifyPopupMenu.
 *
 *      We remove the "Create another" menu item.
 *
 *@@added V0.9.2 (2000-02-26) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_wpFilterPopupMenu(XFldWPS *somSelf,
                                               ULONG ulFlags,
                                               HWND hwndCnr,
                                               BOOL fMultiSelect)
{
    /* XFldWPSData *somThis = XFldWPSGetData(somSelf); */
    XFldWPSMethodDebug("XFldWPS","xwp_wpFilterPopupMenu");

    return (XFldWPS_parent_WPSystem_wpFilterPopupMenu(somSelf,
                                                      ulFlags,
                                                      hwndCnr,
                                                      fMultiSelect)
            & ~CTXT_NEW
           );
}

/*
 *@@ wpAddSystemScreenPage:
 *      this WPSystem instance method is overridden in order
 *      to suppress the "Screen" page in the "Workplace Shell"
 *      object, because we want that page in the new "Screen"
 *      object instead.
 */

SOM_Scope ULONG  SOMLINK xwp_wpAddSystemScreenPage(XFldWPS *somSelf,
                                                   HWND hwndNotebook)
{
    /* XFldWPSData *somThis = XFldWPSGetData(somSelf); */
    XFldWPSMethodDebug("XFldWPS","xwp_wpAddSystemScreenPage");

    return SETTINGS_PAGE_REMOVED;
}

/*
 *@@ wpAddDMQSDisplayTypePage:
 *      this WPSystem instance method is overridden in order
 *      to suppress the second "Screen" page in the "Workplace
 *      Shell" object. Depending on the installed video driver,
 *      this page may or may not be displayed in the "System"
 *      notebook, but we never want this in "Workplace Shell",
 *      but in "Screen" instead.
 */

SOM_Scope ULONG  SOMLINK xwp_wpAddDMQSDisplayTypePage(XFldWPS *somSelf,
                                                      HWND hwndNotebook)
{
    /* XFldWPSData *somThis = XFldWPSGetData(somSelf); */
    XFldWPSMethodDebug("XFldWPS","xwp_wpAddDMQSDisplayTypePage");

    return SETTINGS_PAGE_REMOVED;
}

/*
 *@@ wpAddSystemPrintScreenPage:
 *      this WPSystem instance method is overridden in order
 *      to suppress the "Print screen" page in the "Workplace
 *      Shell" object. We want this page in the new "Screen"
 *      object instead.
 *
 *@@added V0.9.2 (2000-02-23) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_wpAddSystemPrintScreenPage(XFldWPS *somSelf,
                                                          HWND hwndNotebook)
{
    /* XFldWPSData *somThis = XFldWPSGetData(somSelf); */
    XFldWPSMethodDebug("XFldWPS","xwp_wpAddSystemPrintScreenPage");

    return SETTINGS_PAGE_REMOVED;
}

#define PAGE_MENU_ADDED            0x0001

/*
 *@@ wpAddSettingsPages:
 *      this WPObject instance method gets called by the WPS
 *      when the Settings view is opened to have all the
 *      settings page inserted into hwndNotebook.
 *
 *      For "Workplace Shell", this is a bit tricky. We
 *      want some of the settings pages from the "System"
 *      notebook (from which we inherit), but while we
 *      can override some pages we don't want to return
 *      SETTINGS_PAGE_REMOVED, we can't do that with all
 *      because some pages have method interfaces only
 *      with V0.9.19. We therefore go for a truly bad
 *      hack in XFldWPS::wpInsertSettingsPage.
 *
 *      With V0.9.19, the pages have been reordered. We
 *      now have:
 *
 *      1)  "File types" on top
 *
 *      2)  then a bunch of old WPSystem pages: Confirmations,
 *          Title, Window 1 and 2 (where 3 is suppressed
 *          in XFldWPS::wpInsertSettingsPage);
 *
 *      3)  Then (since Window 2 is folder-related) our own
 *          folder-specific pages: Folder views, Status bars,
 *          Grid, Folder hotkeys, Sort.
 *
 *      4)  Then the "Menu" page, which we replace also with
 *          our bunch of pages.
 *
 *      5)  Then the rest of the WPSystem pages: user
 *          interface, Logo, Icon.
 *
 *@@changed V0.9.19 (2002-04-17) [umoeller]: complete revamp of settings pages
 */

SOM_Scope BOOL  SOMLINK xwp_wpAddSettingsPages(XFldWPS *somSelf,
                                               HWND hwndNotebook)
{
    XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_wpAddSettingsPages");

    // reset for hacks
    _flPagesAdded = 0;

    // call parent to have some WPSystem pages inserted...
    // note that we kick out those that should rather be
    // in "Screen". Besides, we sort of "override" some
    // methods that are only available on Warp 4 thru
    // the hacks in our wpInsertSettingsPage override,
    // see below.
    // V0.9.19 (2002-04-17) [umoeller]

    XFldWPS_parent_WPSystem_wpAddSettingsPages(somSelf,
                                               hwndNotebook);

    // check if our hack for the "Menu" page worked
    if (!(_flPagesAdded & PAGE_MENU_ADDED))
        // no: insert on top then (Warp 3 probably)
        _xwpAddXFldWPSPages(somSelf, hwndNotebook);

    // file types on top
    _xwpAddWPSFileTypesPage(somSelf, hwndNotebook);

    return TRUE;
}

/*
 *@@ wpInsertSettingsPage:
 *      this WPObject method is really only a helper
 *      for inserting a page into a settings notebook.
 *      This gets called by all the wpAddSomething
 *      methods in the WPS.
 *
 *      Fortunately, we can say, because via method
 *      overrides we can hack ourselves into pages
 *      that we don't have method interfaces for.
 *      We do this for V0.9.19 now to suppress or
 *      replace some of the "System" pages. Yes, we
 *      could also have made wpAddSettingsPages not
 *      call the parent, but then we make it difficult
 *      for people to derive from XFldWPS in the future.
 *
 *@@added V0.9.19 (2002-04-17) [umoeller]
 */

SOM_Scope ULONG  SOMLINK xwp_wpInsertSettingsPage(XFldWPS *somSelf,
                                                  HWND hwndNotebook,
                                                  PPAGEINFO ppageinfo)
{
    CHAR    szModule[CCHMAXPATH];
    ULONG   ulrc = 0;

    XFldWPSData *somThis = XFldWPSGetData(somSelf);
    XFldWPSMethodDebug("XFldWPS","xwp_wpInsertSettingsPage");

    /*
        Alright, truly evil hack here. We replace certain
        Warp 4 settings pages by actually evaluating the
        PAGEINFO and checking the module. If it's WPCONMRI.DLL,
        which is the NLS module for WPCONFIG.DLL on both
        Warp 3 and 4, we then also check the dialog ID to
        identify the page. I get the following list in
        this order when opening the XFldWPS settings notebook:

        module   dlgid  title          warp3 warp4
        WPCONMRI 1201   Logo           X     X
        WPCONMRI 1302   User intfc.    -     X
        WPCONMRI 1307   Menu           -     X
        WPCONMRI 1303   [NULL]         X     X      (is "window 3" page)
        WPCONMRI 2107   [NULL]         X     X      (is "window 2" page)
        WPCONMRI 1200   Window         X     X
        WPCONMRI 3052   Title          X     X
        WPCONMRI 1202   Confirmations  X     X
    */

    if (!DosQueryModuleName(ppageinfo->resid, sizeof(szModule), szModule))
    {
        PCSZ p;

        if (    (p = strrchr(szModule, '\\'))
             && (!stricmp(p + 1, "WPCONMRI.DLL"))
           )
        {
            switch (ppageinfo->dlgid)
            {
                case 1307:      // "Menu" page... this we want to replace,
                                // plus add a bunch of others on top
                    if (_xwpAddXFldWPSPages(somSelf, hwndNotebook))
                              // this will recurse into this method again,
                              // because _xwpAddXFldWPSPages calls
                              // ntbInsertPage which calls this method again,
                              // but then the above checks will fail, so no worry
                    {
                        // mark for wpAddSettingsPages
                        _flPagesAdded |= PAGE_MENU_ADDED;
                        // and return -1
                        ulrc = SETTINGS_PAGE_REMOVED;
                    }
                break;

                case 1303:      // "Window 3" page (folder default view)
                    // remove this, this had the default
                    // folder view which never works anyway
                    ulrc = SETTINGS_PAGE_REMOVED;
                break;
            }
        }
    }

    if (!ulrc)
        // not hacked:
        ulrc = XFldWPS_parent_WPSystem_wpInsertSettingsPage(somSelf,
                                                            hwndNotebook,
                                                            ppageinfo);

    return ulrc;
}


/* ******************************************************************
 *
 *   here come the XFldWPS class methods
 *
 ********************************************************************/

/*
 *@@ wpclsInitData:
 *      this WPObject class method gets called when a class
 *      is loaded by the WPS (probably from within a
 *      somFindClass call) and allows the class to initialize
 *      itself.
 *
 *@@changed V0.9.0 [umoeller]: added class object to KERNELGLOBALS
 */

SOM_Scope void  SOMLINK xwpM_wpclsInitData(M_XFldWPS *somSelf)
{
    /* M_XFldWPSData *somThis = M_XFldWPSGetData(somSelf); */
    M_XFldWPSMethodDebug("M_XFldWPS","xwpM_wpclsInitData");

    M_XFldWPS_parent_M_WPSystem_wpclsInitData(somSelf);

    krnClassInitialized(G_pcszXFldWPS);
}

/*
 *@@ wpclsQuerySettingsPageSize:
 *      this WPObject class method should return the
 *      size of the largest settings page in dialog
 *      units; if a settings notebook is initially
 *      opened, i.e. no window pos has been stored
 *      yet, the WPS will use this size, to avoid
 *      truncated settings pages.
 */

SOM_Scope BOOL  SOMLINK xwpM_wpclsQuerySettingsPageSize(M_XFldWPS *somSelf,
                                                        PSIZEL pSizl)
{
    BOOL brc;
    /* M_XFldWPSData *somThis = M_XFldWPSGetData(somSelf); */
    M_XFldWPSMethodDebug("M_XFldWPS","xwpM_wpclsQuerySettingsPageSize");

    brc = M_XFldWPS_parent_M_WPSystem_wpclsQuerySettingsPageSize(somSelf,
                                                                   pSizl);
    if (brc)
    {
        pSizl->cy = 170;        // this is the height of the "WPS Classes" page,
                                // which seems to be the largest in the "Workplace
                                // Shell" object
        if (G_fIsWarp4)
            // on Warp 4, reduce again, because we're moving
            // the notebook buttons to the bottom
            pSizl->cy -= WARP4_NOTEBOOK_OFFSET;
    }
    return brc;
}

/*
 *@@ wpclsQueryTitle:
 *      this WPObject class method tells the WPS the clear
 *      name of a class, which is shown in the third column
 *      of a Details view and also used as the default title
 *      for new objects of a class.
 */

SOM_Scope PSZ  SOMLINK xwpM_wpclsQueryTitle(M_XFldWPS *somSelf)
{
    // M_XFldWPSData *somThis = M_XFldWPSGetData(somSelf);
    M_XFldWPSMethodDebug("M_XFldWPS","xwpM_wpclsQueryTitle");

    return ("Workplace Shell");
}

/*
 *@@ wpclsQueryDefaultHelp:
 *      this WPObject class method returns the default help
 *      panel for objects of this class. This gets called
 *      from WPObject::wpQueryDefaultHelp if no instance
 *      help settings (HELPLIBRARY, HELPPANEL) have been
 *      set for an individual object. It is thus recommended
 *      to override this method instead of the instance
 *      method to change the default help panel for a class
 *      in order not to break instance help settings (fixed
 *      with 0.9.20).
 *
 *      We return the default help for the "Workplace Shell"
 *      object here.
 *
 *@@added V0.9.20 (2002-07-12) [umoeller]
 */

SOM_Scope BOOL  SOMLINK xwpM_wpclsQueryDefaultHelp(M_XFldWPS *somSelf,
                                                   PULONG pHelpPanelId,
                                                   PSZ pszHelpLibrary)
{
    /* M_XFldWPSData *somThis = M_XFldWPSGetData(somSelf); */
    M_XFldWPSMethodDebug("M_XFldWPS","xwpM_wpclsQueryDefaultHelp");

    strcpy(pszHelpLibrary, cmnQueryHelpLibrary());
    *pHelpPanelId = ID_XSH_XFLDWPS;
    return TRUE;
}

/*
 *@@ wpclsQueryIconData:
 *      this WPObject class method must return information
 *      about how to build the default icon for objects
 *      of a class. This gets called from various other
 *      methods whenever a class default icon is needed;
 *      most importantly, M_WPObject::wpclsQueryIcon
 *      calls this to build a class default icon, which
 *      is then cached in the class's instance data.
 *      If a subclass wants to change a class default icon,
 *      it should always override _this_ method instead of
 *      wpclsQueryIcon.
 *
 *      Note that the default WPS implementation does not
 *      allow for specifying the ICON_FILE format here,
 *      which is why we have overridden
 *      M_XFldObject::wpclsQueryIcon too. This allows us
 *      to return icon _files_ for theming too. For details
 *      about the WPS's crappy icon management, refer to
 *      src\filesys\icons.c.
 *
 *      We give the "Workplace Shell" object a new icon.
 */

SOM_Scope ULONG  SOMLINK xwpM_wpclsQueryIconData(M_XFldWPS *somSelf,
                                                 PICONINFO pIconInfo)
{
    // M_XFldWPSData *somThis = M_XFldWPSGetData(somSelf);
    M_XFldWPSMethodDebug("M_XFldWPS","xwpM_wpclsQueryIconData");

    if (pIconInfo)
    {
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->resid   = ID_ICONWPS;
        pIconInfo->hmod    = cmnQueryMainResModuleHandle();
    }

    return (sizeof(ICONINFO));
}


