
/*
 *@@sourcefile xfdisk.c:
 *      This file contains SOM code for the following XWorkplace classes:
 *
 *      --  XFldDisk (WPDisk replacement)
 *
 *      XFldDisk is needed mainly to modify the popup menus
 *      of Disk objects also. Since these are not instances
 *      of WPFolder, we need an extra subclass.
 *
 *      Installation of this class is now optional (V0.9.0).
 *      However, if it is installed, XFolder must also be
 *      installed.
 *
 *      Starting with V0.9.0, the files in classes\ contain only
 *      i.e. the methods themselves.
 *      The implementation for this class is mostly in filesys\disk.c.
 *
 *@@somclass XFldDisk xfdisk_
 *@@somclass M_XFldDisk xfdiskM_
 */

/*
 *      Copyright (C) 1997-2002 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_xfdisk_Source
#define SOM_Module_xfdisk_Source
#endif
#define XFldDisk_Class_Source
#define M_XFldDisk_Class_Source

#pragma strings(readonly)

/*
 *  Suggested #include order:
 *  1)  os2.h
 *  2)  C library headers
 *  3)  setup.h (code generation and debugging options)
 *  4)  headers in helpers\
 *  5)  at least one SOM implementation header (*.ih)
 *  6)  dlgids.h, headers in shared\ (as needed)
 *  7)  headers in implementation dirs (e.g. filesys\, as needed)
 *  8)  #pragma hdrstop and then more SOM headers which crash with precompiled headers
 */

#define INCL_DOSSEMAPHORES
#define INCL_DOSERRORS

#define INCL_WINFRAMEMGR
#define INCL_WINMENUS
#include  <os2.h>

// C library headers
#include <stdio.h>

// generic headers
#include "setup.h"                      // code generation and debugging options

// headers in /helpers
#include "helpers\dosh.h"               // Control Program helper routines
#include "helpers\winh.h"               // PM helper routines
#include "helpers\standards.h"          // some standard macros

// SOM headers which don't crash with prec. header files
#include "xfdisk.ih"
#include "xfldr.ih"

// XWorkplace implementation headers
#include "dlgids.h"                     // all the IDs that are shared with NLS
#include "shared\common.h"              // the majestic XWorkplace include file
#include "shared\helppanels.h"          // all XWorkplace help panel IDs
#include "shared\kernel.h"              // XWorkplace Kernel
#include "shared\notebook.h"            // generic XWorkplace notebook handling

#include "filesys\disk.h"               // XFldDisk implementation
#include "filesys\folder.h"             // XFolder implementation
#include "filesys\fdrmenus.h"           // shared folder menu logic
#include "filesys\object.h"             // XFldObject implementation
#include "filesys\statbars.h"           // status bar translation logic

// other SOM headers
#include "helpers\undoc.h"              // some undocumented stuff
#pragma hdrstop

/* ******************************************************************
 *
 *   Global variables
 *
 ********************************************************************/

/* ******************************************************************
 *
 *   here come the XFldDisk instance methods
 *
 ********************************************************************/

/*
 *@@ xwpSafeQueryRootFolder:
 *      safe version of WPDisk::wpQueryRootFolder which
 *      attempts not to provoke the terrible white
 *      hard-error box if the disk is not ready.
 *
 *      This used to be wpshQueryRootFolder, but has
 *      been made an instance method with V0.9.19.
 *
 *      On errors, NULL is returned, and *pulErrorCode
 *      receives the APIRET from doshAssertDrive.
 *
 *      If you're not interested in the return code,
 *      you may pass pulErrorCode as NULL.
 *
 *@@added V0.9.19 (2002-06-15) [umoeller]
 */

SOM_Scope WPRootFolder*  SOMLINK xfdisk_xwpSafeQueryRootFolder(XFldDisk *somSelf,
                                                               BOOL fForceMap,
                                                               PULONG pulErrorCode)
{
    WPFolder    *pReturnFolder = NULL;
    APIRET      arc = NO_ERROR;
    ULONG       ulLogicalDrive;

    /* XFldDiskData *somThis = XFldDiskGetData(somSelf); */
    XFldDiskMethodDebug("XFldDisk","xfdisk_xwpSafeQueryRootFolder");

    ulLogicalDrive = _wpQueryLogicalDrive(somSelf);
    arc = doshAssertDrive(ulLogicalDrive, 0);

    if (    (arc == ERROR_DISK_CHANGE)
         && (fForceMap)
         && ((ulLogicalDrive == 1) || (ulLogicalDrive == 2))
         && (doshSetLogicalMap(ulLogicalDrive) == NO_ERROR)
       )
    {
        arc = doshAssertDrive(ulLogicalDrive, 0);
    }

    if (!arc)
    {
        // drive seems to be ready:
        if (!(pReturnFolder = _wpQueryRootFolder(somSelf)))
            // still NULL: something bad is going on
            // V0.9.2 (2000-03-09) [umoeller]
            arc = ERROR_NOT_DOS_DISK; // 26; cannot access disk
    }

    if (pulErrorCode)
        *pulErrorCode = arc;

    return pReturnFolder;
}

/*
 *@@ wpFilterPopupMenu:
 *      this WPObject instance method allows the object to
 *      filter out unwanted menu items from the context menu.
 *      This gets called before wpModifyPopupMenu.
 *
 *      We remove default entries for disks according to the
 *      global menu settings.
 *
 *@@changed V0.9.5 (2000-09-18) [umoeller]: now removing "Create another" always
 *@@changed V0.9.19 (2002-04-17) [umoeller]: adjusted for new menu handling
 */

SOM_Scope ULONG  SOMLINK xfdisk_wpFilterPopupMenu(XFldDisk *somSelf,
                                                ULONG ulFlags,
                                                HWND hwndCnr,
                                                BOOL fMultiSelect)
{
    ULONG ulrc;
    // XFldDiskData *somThis = XFldDiskGetData(somSelf);
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpFilterPopupMenu");

    ulrc = (    XFldDisk_parent_WPDisk_wpFilterPopupMenu(somSelf,
                                                         ulFlags,
                                                         hwndCnr,
                                                         fMultiSelect)
             &  ~(
                    // hack out items where the CTXT_* flag is
                    // set for disks V0.9.19 (2002-04-17) [umoeller]
                    cmnQuerySetting(mnuQueryMenuWPSSetting(somSelf))
                  | CTXT_NEW
                 )
           );

    return (ulrc);
}

/*
 *@@ wpModifyPopupMenu:
 *      this WPObject instance methods gets called by the WPS
 *      when a context menu needs to be built for the object
 *      and allows the object to manipulate its context menu.
 *      This gets called _after_ wpFilterPopupMenu.
 *
 *      We add the various XFolder menu entries here
 *      by calling mnuModifyFolderPopupMenu in fdrmenus.c,
 *      which is also used by the XFolder class.
 *
 *@@todo hwndCnr is NULLHANDLE always
 */

SOM_Scope BOOL  SOMLINK xfdisk_wpModifyPopupMenu(XFldDisk *somSelf,
                                                 HWND hwndMenu,
                                                 HWND hwndCnr,
                                                 ULONG iPosition)
{
    BOOL            rc;

    // XFldDiskData *somThis = XFldDiskGetData(somSelf);
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpModifyPopupMenu");

    _PmpfF(("entering"));

    if (rc = XFldDisk_parent_WPDisk_wpModifyPopupMenu(somSelf,
                                                      hwndMenu,
                                                      hwndCnr,
                                                      iPosition))
    {
        WPFolder *pFolder = _wpQueryRootFolder(somSelf);

        static const ULONG aSuppressFlags[] =
            {
                XWPCTXT_CHKDSK,
                XWPCTXT_FORMAT,
                XWPCTXT_COPYDSK,
                XWPCTXT_LOCKDISK,
                XWPCTXT_EJECTDISK,
                XWPCTXT_UNLOCKDISK,
            };
        mnuRemoveMenuItems(somSelf,
                           hwndMenu,
                           aSuppressFlags,
                           ARRAYITEMCOUNT(aSuppressFlags));

        if (pFolder)
            // drive ready:
            rc = mnuModifyFolderPopupMenu(pFolder,
                                          hwndMenu,
                                          hwndCnr,    // @@todo this seems to be NULLHANDLE
                                          iPosition);
    }

    _PmpfF(("leaving"));

    return (rc);
}

/*
 *@@ wpMenuItemSelected:
 *      this WPObject method processes menu selections.
 *      This must be overridden to support new menu
 *      items which have been added in wpModifyPopupMenu.
 *
 *      See XFldObject::wpMenuItemSelected for additional
 *      remarks.
 *
 *      We pass the input to mnuMenuItemSelected in fdrmenus.c
 *      because disk menu items are mostly shared with XFolder.
 */

SOM_Scope BOOL  SOMLINK xfdisk_wpMenuItemSelected(XFldDisk *somSelf,
                                                  HWND hwndFrame,
                                                  ULONG ulMenuId)
{
    XFolder         *pFolder = _wpQueryRootFolder(somSelf);
    // XFldDiskData *somThis = XFldDiskGetData(somSelf);
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpMenuItemSelected");

    if (mnuMenuItemSelected(pFolder, hwndFrame, ulMenuId))
        return TRUE;
    else
        return (XFldDisk_parent_WPDisk_wpMenuItemSelected(somSelf, hwndFrame,
                                                   ulMenuId));
}

/*
 *@@ wpMenuItemHelpSelected:
 *      display help for a context menu item;
 *      we pass the input to mnuMenuItemHelpSelected in fdrmenus.c.
 */

SOM_Scope BOOL  SOMLINK xfdisk_wpMenuItemHelpSelected(XFldDisk *somSelf,
                                                      ULONG MenuId)
{
    XFolder         *pFolder = _wpQueryRootFolder(somSelf);
    // XFldDiskData *somThis = XFldDiskGetData(somSelf);
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpMenuItemHelpSelected");

    if (mnuMenuItemHelpSelected(pFolder, MenuId))
        return TRUE;
    else
        return (XFldDisk_parent_WPDisk_wpMenuItemHelpSelected(somSelf,
                                                           MenuId));
}

/*
 *@@ wpViewObject:
 *      this WPObject method either opens a new view of the
 *      object (by calling wpOpen) or resurfaces an already
 *      open view, if one exists already and "concurrent views"
 *      are enabled. This gets called every single time when
 *      an object is to be opened... e.g. on double-clicks.
 *
 *      For WPDisks, the WPS seems to be doing no drive checking
 *      in here, which leads to the annoying "Drive not ready"
 *      popups. So we try to implement this here.
 *
 *@@changed V0.9.0 [umoeller]: added global setting for disabling this feature
 *@@changed V0.9.16 (2001-10-23) [umoeller]: now intercepting OPEN_SETTINGS too
 */

SOM_Scope HWND  SOMLINK xfdisk_wpViewObject(XFldDisk *somSelf,
                                            HWND hwndCnr,
                                            ULONG ulView,
                                            ULONG param)
{
    HWND            hwndFrame = NULLHANDLE; // default: error occured

    /* XFldDiskData *somThis = XFldDiskGetData(somSelf); */
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpViewObject");

    _PmpfF(("entering"));

    // "Drive not ready" replacement enabled?
#ifndef __NEVERREPLACEDRIVENOTREADY__
    if (    (cmnQuerySetting(sfReplaceDriveNotReady))
         // && (ulView != OPEN_SETTINGS)
                // V0.9.16 (2001-10-23) [umoeller]
                // do this for settings too,
                // however, on eCS this _never_ gets called...
                // we leave this in here in case Warp 3 behaves
                // differently, but we do the same check again in
                // wpOpen below now
       )
    {
        // yes: use the safe way of opening the
        // drive (this prompts the user upon errors)
        XFolder*        pRootFolder = NULL;
        if (!(pRootFolder = dskCheckDriveReady(somSelf)))
            // error: do _not_ call default
            somSelf = NULL;
    }
#endif

    if (somSelf)
        // drive checking disabled, or disk is ready:
        hwndFrame = XFldDisk_parent_WPDisk_wpViewObject(somSelf,
                                                        hwndCnr,
                                                        ulView,
                                                        param);

    _PmpfF(("leaving"));

    return (hwndFrame);
}

/*
 *@@ wpOpen:
 *      this WPObject instance method gets called when
 *      a new view needs to be opened. Normally, this
 *      gets called after wpViewObject has scanned the
 *      object's USEITEMs and has determined that a new
 *      view is needed.
 *
 *      This _normally_ runs on thread 1 of the WPS, but
 *      this is not always the case. If this gets called
 *      in response to a menu selection from the "Open"
 *      submenu or a double-click in the folder, this runs
 *      on the thread of the folder (which _normally_ is
 *      thread 1). However, if this results from WinOpenObject
 *      or an OPEN setup string, this will not be on thread 1.
 *
 *      We call the parent first and then subclass the
 *      resulting frame window, similar to what we're doing
 *      with folder views (see XFolder::wpOpen).
 *
 *@@changed V0.9.2 (2000-03-06) [umoeller]: drives were checked even if replacement dlg was disabled; fixed
 *@@changed V0.9.3 (2000-04-08) [umoeller]: adjusted for new folder subclassing
 *@@changed V0.9.16 (2001-10-23) [umoeller]: now intercepting OPEN_SETTINGS too
 */

SOM_Scope HWND  SOMLINK xfdisk_wpOpen(XFldDisk *somSelf,
                                      HWND hwndCnr,
                                      ULONG ulView,
                                      ULONG param)
{
    HWND            hwndNewFrame = NULLHANDLE; // default: error occured

    _PmpfF(("entering"));

    switch (ulView)
    {
        case OPEN_CONTENTS:
        case OPEN_TREE:
        case OPEN_DETAILS:
        case OPEN_SETTINGS:     // V0.9.16 (2001-10-23) [umoeller]
        {
            XFolder*        pRootFolder = 0;
            // XFldDiskData *somThis = XFldDiskGetData(somSelf);
            XFldDiskMethodDebug("XFldDisk","xfdisk_wpOpen");

#ifndef __NEVERREPLACEDRIVENOTREADY__
            // "Drive not ready" replacement enabled?
            if (cmnQuerySetting(sfReplaceDriveNotReady))
            {
                // query root folder (WPRootFolder class, which is a descendant
                // of WPFolder/XFolder); each WPDisk is paired with one of those,
                // and the actual display is done by this class, so we will pass
                // pRootFolder instead of somSelf to most following method calls.
                // We use xwpSafeQueryRootFolder instead of wpQueryRootFolder to
                // avoid "Drive not ready" popups.
                if (pRootFolder = dskCheckDriveReady(somSelf))
                                // V0.9.16 (2001-10-23) [umoeller]
                                // now using dskCheckDriveReady instead of
                                // xwpSafeQueryRootFolder because wpViewObject
                                // never gets called for OPEN_SETTINGS
                    // drive ready: call parent to get frame handle
                    hwndNewFrame = XFldDisk_parent_WPDisk_wpOpen(somSelf,
                                                                 hwndCnr,
                                                                 ulView,
                                                                 param);
                // else: hwndNewFrame is still NULLHANDLE
            }
            else
#endif
            {
                // "drive not ready" replacement disabled:
                if (hwndNewFrame = XFldDisk_parent_WPDisk_wpOpen(somSelf,
                                                                 hwndCnr,
                                                                 ulView,
                                                                 param))
                    // no error:
                    pRootFolder = _wpQueryRootFolder(somSelf);
            }

            if (    (pRootFolder)
                 && (hwndNewFrame)
                 && (ulView != OPEN_SETTINGS)
               )
            {
                PSUBCLFOLDERVIEW psfv = NULL;

                hwndCnr = WinWindowFromID(hwndNewFrame, FID_CLIENT);

                // subclass frame window; this is the same
                // proc which is used for normal folder frames,
                // we just use pRootFolder instead.
                // However, we pass somSelf as the "real" object
                // which will then be stored in *psli.
                psfv = fdrSubclassFolderView(hwndNewFrame,
                                             hwndCnr,
                                             pRootFolder, // folder
                                             somSelf);    // real object; for disks, this
                                                          // is the WPDisk object...
                // add status bar, if allowed: as opposed to
                // XFolder's, for XFldDisk's we only check the
                // global setting, because there's no instance
                // setting for this with XFldDisk's
                if (
#ifndef __NOCFGSTATUSBARS__
                        (cmnQuerySetting(sfStatusBars))
                                                // feature enabled?
                     &&
#endif
                        (cmnQuerySetting(sfDefaultStatusBarVisibility))
                                                // bars visible per default?
                   )
                    // assert that subclassed list item is valid
                    if (psfv)
                    {
                        ULONG flViews = cmnQuerySetting(sflSBForViews);
                        // add status bar only if allowed for the current view type
                        if (    (   (ulView == OPEN_CONTENTS)
                                 && (flViews & SBV_ICON)
                                )
                             || (   (ulView == OPEN_TREE)
                                 && (flViews & SBV_TREE)
                                )
                             || (   (ulView == OPEN_DETAILS)
                                 && (flViews & SBV_DETAILS)
                                )
                            )
                            // this reformats the window with the status bar
                            stbCreate(psfv);
                    }

                // extended sort functions
#ifndef __ALWAYSEXTSORT__
                if (cmnQuerySetting(sfExtendedSorting))
#endif
                    if (hwndCnr)
                        fdrSetFldrCnrSort(pRootFolder,
                                          hwndCnr,
                                          FALSE);
            } // if (pRootFolder)
        }
        break;

        default:
            // e.g. settings view
            hwndNewFrame = XFldDisk_parent_WPDisk_wpOpen(somSelf,
                                                         hwndCnr,
                                                         ulView,
                                                         param);
    } // switch (ulView)

    _PmpfF(("leaving"));

    return (hwndNewFrame);
}

/*
 *@@ wpAddSettingsPages:
 *      this WPObject instance method gets called by the WPS
 *      when the Settings view is opened to have all the
 *      settings page inserted into hwndNotebook.
 *
 *      We override this so we can attempt to avoid the
 *      disk error msg boxes here.
 *
 *@@added V0.9.16 (2001-10-23) [umoeller]
 */

SOM_Scope BOOL  SOMLINK xfdisk_wpAddSettingsPages(XFldDisk *somSelf,
                                                  HWND hwndNotebook)
{
    BOOL brc = FALSE;
    /* XFldDiskData *somThis = XFldDiskGetData(somSelf); */
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpAddSettingsPages");

#ifndef __NEVERREPLACEDRIVENOTREADY__
    if (cmnQuerySetting(sfReplaceDriveNotReady))
    {
        WPFolder *pRoot;
        if (!(pRoot = _xwpSafeQueryRootFolder(somSelf, FALSE, NULL)))
            return FALSE;
    }
#endif

    return (XFldDisk_parent_WPDisk_wpAddSettingsPages(somSelf,
                                                      hwndNotebook));
}

/*
 *@@ wpAddDiskDetailsPage:
 *      this adds the "Details" page to a disk object's
 *      settings notebook.
 *
 *      We override this method to insert our enhanced
 *      page instead.
 *
 *@@added V0.9.0 [umoeller]
 */

SOM_Scope ULONG  SOMLINK xfdisk_wpAddDiskDetailsPage(XFldDisk *somSelf,
                                                     HWND hwndNotebook)
{
    /* XFldDiskData *somThis = XFldDiskGetData(somSelf); */
    XFldDiskMethodDebug("XFldDisk","xfdisk_wpAddDiskDetailsPage");

#ifndef __ALWAYSREPLACEFILEPAGE__
    if (cmnQuerySetting(sfReplaceFilePage))
#endif
    {
        INSERTNOTEBOOKPAGE inbp;
        memset(&inbp, 0, sizeof(INSERTNOTEBOOKPAGE));
        inbp.somSelf = somSelf;
        inbp.hwndNotebook = hwndNotebook;
        inbp.hmod = cmnQueryNLSModuleHandle(FALSE);
        inbp.ulDlgID = ID_XSD_DISK_DETAILS;
        inbp.ulPageID = SP_DISK_DETAILS;
        inbp.usPageStyleFlags = BKA_MAJOR;
        inbp.pcszName = cmnGetString(ID_XSSI_DETAILSPAGE);  // pszDetailsPage
        inbp.ulDefaultHelpPanel  = ID_XSH_SETTINGS_DISKDETAILS;
        inbp.pfncbInitPage    = (PFNCBACTION)dskDetailsInitPage;
        inbp.pfncbItemChanged = dskDetailsItemChanged;
        return (ntbInsertPage(&inbp));
    }

#ifndef __ALWAYSREPLACEFILEPAGE__
    return (XFldDisk_parent_WPDisk_wpAddDiskDetailsPage(somSelf,
                                                        hwndNotebook));
#endif
}

/* ******************************************************************
 *
 *   here come the XFldDisk class methods
 *
 ********************************************************************/

/*
 *@@ wpclsInitData:
 *      this WPObject class method gets called when a class
 *      is loaded by the WPS (probably from within a
 *      somFindClass call) and allows the class to initialize
 *      itself.
 *
 *@@changed V0.9.0 [umoeller]: added class object to KERNELGLOBALS
 */

SOM_Scope void  SOMLINK xfdiskM_wpclsInitData(M_XFldDisk *somSelf)
{
    // M_XFldDiskData *somThis = M_XFldDiskGetData(somSelf);
    M_XFldDiskMethodDebug("M_XFldDisk","xfdiskM_wpclsInitData");

    M_XFldDisk_parent_M_WPDisk_wpclsInitData(somSelf);

    krnClassInitialized(G_pcszXFldDisk);
}

/*
 *@@ wpclsQueryTitle:
 *      this WPObject class method tells the WPS the clear
 *      name of a class, which is shown in the third column
 *      of a Details view and also used as the default title
 *      for new objects of a class.
 *
 *      We override the standard folder class name only if
 *      the user has enabled "fix class titles" in XWPSetup.
 *
 *@@added V0.9.12 (2001-05-22) [umoeller]
 */

SOM_Scope PSZ  SOMLINK xfdiskM_wpclsQueryTitle(M_XFldDisk *somSelf)
{
    /* M_XFldDiskData *somThis = M_XFldDiskGetData(somSelf); */
    M_XFldDiskMethodDebug("M_XFldDisk","xfdiskM_wpclsQueryTitle");

#ifndef __ALWAYSFIXCLASSTITLES__
    if (!cmnQuerySetting(sfFixClassTitles))
        return (M_XFldDisk_parent_M_WPDisk_wpclsQueryTitle(somSelf));
#endif

    return (cmnGetString(ID_XSSI_CLASSTITLE_DISK));
}


