
/*
 *@@ xdebug.c:
 *      This file contains the following major XWorkplace components:
 *      --  DbgDataFile SOM stuff
 *
 *      The classes in this file are "hidden" in the XDEBUG.DLL
 *      file and not required for XWorkplace's operation. They
 *      may be used however to debug WPS classes.
 *
 *      These classes override all methods which IBM has documented
 *      for them. In order to use these classes, do the following:
 *
 *      a)  Register the classes with the WPS class list.
 *      b)  Create an object of this class manually.
 *
 *      After the next Desktop restart, you'll see an additional
 *      "Debug" menu item in all object context menus, where
 *      you can enable debugging for this one object only.
 *      This requires that PMPRINTF be properly installed.
 *
 */

/*
 *      Copyright (C) 1999-2002 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_xdebug_Source
#define SOM_Module_xdebug_Source
#endif
#define DbgDataFile_Class_Source
#define M_DbgDataFile_Class_Source

#define INCL_DOS
#define INCL_WIN
#include <os2.h>

#include <string.h>
#include <stdio.h>

// generic headers
#include "setup.h"                      // code generation and debugging options

#include "helpers\ras.h"
#include "helpers\winh.h"

#include "classes\xdebug.ih"

#include "shared\common.h"
#include "shared\wpsh.h"

#pragma hdrstop

BOOL    G_fDebugDataFileInit = FALSE;

/*
 * InstanceMethodDebug:
 * EndInstanceMethodDebug:
 *      two monster macros for printing method information
 *      using PMPRINTF.
 *      These print object and method information if _fDebugThis
 *      is TRUE (which can be set from the new context menu item
 *      inserted by DbgDataFile::wpModifyPopupMenu).
 *      This can only be used in instance methods, not class methods,
 *      but is not limited to DbgDataFile methods.
 *
 *      Note: these macros can only be used together. Using
 *      only one of them will have the compiler complain.
 *      Also, do _not_ modify _fDebugThis in between these
 *      two macros, or the WPS will crash.
 */

//         DosSysTrace(254, strlen(method), __LINE__, method);         \
//         PSZ     __pszObjectTitle = NULL;                            \
//             __pszObjectTitle = _wpQueryTitle(somSelf);              \
/*             SOMClass *pClass = _somGetClass(somSelf);               \
            PSZ __pszClassName = "?";                               \
            if (pClass) __pszClassName = _somGetName(pClass);       \
            */

#define InstanceMethodDebug(class, method)                 \
    {                                                               \
        DbgDataFileData *pDbgDataFileData = DbgDataFileGetData(somSelf);  \
        PSZ __pszClass = class;                                     \
        PSZ __pszMethod = method;                                   \
        CHAR    __szIndent[400];                                    \
        if (pDbgDataFileData->fDebugThis)                           \
        {                                                           \
            ULONG __ulOfs = sprintf(__szIndent, "0x%lX ++ ", somSelf);    \
            memset(__szIndent + __ulOfs, ' ', pDbgDataFileData->ulIndent);      \
            strcpy(&(__szIndent[__ulOfs + pDbgDataFileData->ulIndent]), "%s::%s"); \
            _Pmpf((__szIndent,                                      \
                        class,                                      \
                        method));                                   \
            pDbgDataFileData->ulIndent += 4;                        \
        }

#define EndInstanceMethodDebug()                                    \
        if (pDbgDataFileData->fDebugThis)                           \
        {                                                           \
            ULONG __ulOfs = sprintf(__szIndent, "0x%lX -- ", somSelf);    \
            pDbgDataFileData->ulIndent -= 4;                        \
            memset(__szIndent + __ulOfs, ' ', pDbgDataFileData->ulIndent);      \
            strcpy(&(__szIndent[__ulOfs + pDbgDataFileData->ulIndent]), "End of %s::%s"); \
            _Pmpf((__szIndent,                                      \
                        __pszClass,                                 \
                        __pszMethod));                              \
        }                                                           \
    }

/*
 * DbgDataFileMethodDebug:
 *      replace the default SOM method debug macro
 *      for DbgDataFile, using the macros above.
 */

#undef DbgDataFileMethodDebug
#define DbgDataFileMethodDebug(class, method) InstanceMethodDebug(class, method)

// menu item ID used for "Debug" menu item
#define ID_DOMI_DEBUGTHIS   WPMENUID_USER+2000
#define ID_DOMI_DEBUGALL    WPMENUID_USER+2001

/* ******************************************************************
 *
 *   here come the DbgDataFile instance methods
 *
 ********************************************************************/

/*
 *@@ somDefaultInit:
 *
 */

SOM_Scope void SOMLINK ddf_somDefaultInit(DbgDataFile *somSelf,
                                          somInitCtrl* ctrl)
{
    DbgDataFileData *somThis; /* set in BeginInitializer */
    somInitCtrl globalCtrl;
    somBooleanVector myMask;
    // DbgDataFileMethodDebug("DbgDataFile","somDefaultInit");
    DbgDataFile_BeginInitializer_somDefaultInit;

    /*
     * local DbgDataFile initialization code added by programmer
     */

    _fDebugThis = G_fDebugDataFileInit;  // set this to the global for instantiation;
                            // this will be reset by wpObjectReady
    _ulIndent = 0;

    DbgDataFileMethodDebug("DbgDataFile","somDefaultInit");

    // call parent
    DbgDataFile_Init_WPDataFile_somDefaultInit(somSelf, ctrl);

    EndInstanceMethodDebug();
}


/*
 *@@ somDefaultAssign:
 *
 */

SOM_Scope DbgDataFile * SOMLINK ddf_somDefaultAssign(DbgDataFile *somSelf,
                                                     somAssignCtrl* ctrl,
                                                     SOMObject* fromObj)
{
    DbgDataFileData *somThis; /* set in BeginAssignmentOp */
    somAssignCtrl globalCtrl;
    somBooleanVector myMask;
    DbgDataFileMethodDebug("DbgDataFile","somDefaultAssign");
    DbgDataFile_BeginAssignmentOp;

    DbgDataFile_Assign_WPDataFile_somDefaultAssign(somSelf, ctrl, fromObj);

    /*
     * local DbgDataFile assignmentOp code added by programmer
     */

    EndInstanceMethodDebug();

    return somSelf;
}


/*
 *@@ somDefaultConstAssign:
 *
 */

SOM_Scope DbgDataFile * SOMLINK ddf_somDefaultConstAssign(DbgDataFile *somSelf,
                                                          somAssignCtrl* ctrl,
                                                          SOMObject* fromObj)
{
    DbgDataFileData *somThis; /* set in BeginAssignmentOp */
    somAssignCtrl globalCtrl;
    somBooleanVector myMask;
    DbgDataFileMethodDebug("DbgDataFile","somDefaultConstAssign");
    DbgDataFile_BeginAssignmentOp;

    DbgDataFile_Assign_WPDataFile_somDefaultConstAssign(somSelf, ctrl, fromObj);

    /*
     * local DbgDataFile assignmentOp code added by programmer
     */

    EndInstanceMethodDebug();

    return somSelf;
}


/*
 *@@ somDefaultConstCopyInit:
 *
 */

SOM_Scope void  SOMLINK ddf_somDefaultConstCopyInit(DbgDataFile *somSelf,
                                                    somInitCtrl* ctrl,
                                                    SOMObject* fromObj)
{
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_somDefaultConstCopyInit");

    /* DbgDataFile_parent_WPDataFile_somDefaultConstCopyInit(somSelf,
                                                          ctrl,
                                                          fromObj); */
            // doesn't exist

    EndInstanceMethodDebug();
}

/*
 *@@ somDefaultCopyInit:
 *
 */

SOM_Scope void  SOMLINK ddf_somDefaultCopyInit(DbgDataFile *somSelf,
                                               somInitCtrl* ctrl,
                                               SOMObject* fromObj)
{
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_somDefaultCopyInit");

    /* DbgDataFile_parent_WPDataFile_somDefaultCopyInit(somSelf,
                                                     ctrl, fromObj); */
        // doesn't exist

    EndInstanceMethodDebug();
}

/*
 *@@ somUninit:
 *
 */

SOM_Scope void  SOMLINK ddf_somUninit(DbgDataFile *somSelf)
{
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    // DbgDataFileMethodDebug("DbgDataFile","ddf_somUninit");

    ddf_somDestruct(somSelf, FALSE, (somDestructCtrl *) NULL);

    // EndInstanceMethodDebug();
}

/*
 *@@ somDestruct:
 *
 */

SOM_Scope void SOMLINK ddf_somDestruct(DbgDataFile *somSelf,
                                       octet doFree, somDestructCtrl* ctrl)
{
    DbgDataFileData *somThis; /* set in BeginDestructor */
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;
    // DbgDataFileMethodDebug("DbgDataFile","ddf_somDestruct");
    DbgDataFile_BeginDestructor;

    /*
     * local DbgDataFile deinitialization code added by programmer
     */

    DbgDataFile_EndDestructor;
        // this calls DbgDataFile_DeInit_WPDataFile_somDestruct (see xdebug.ih)

    // EndInstanceMethodDebug();
}

/*
 * wpInitData:
 */

SOM_Scope void  SOMLINK ddf_wpInitData(DbgDataFile *somSelf)
{
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);

    DbgDataFileMethodDebug("DbgDataFile","ddf_wpInitData");

    DbgDataFile_parent_WPDataFile_wpInitData(somSelf);

    EndInstanceMethodDebug();
}

/*
 * wpSetupOnce:
 *          the WPObject version of wpSetupOnce calls wpSetup.
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetupOnce(DbgDataFile *somSelf,
                                        PSZ pszSetupString)
{
    BOOL rc = FALSE;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetupOnce");

    if (_fDebugThis)
        _Pmpf(("        setup string: %s", (pszSetupString) ? pszSetupString : "NULL"));

    rc = (DbgDataFile_parent_WPDataFile_wpSetupOnce(somSelf, pszSetupString));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpObjectReady:
 */

SOM_Scope void  SOMLINK ddf_wpObjectReady(DbgDataFile *somSelf,
                                          ULONG ulCode,
                                          WPObject* refObject)
{
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);

    if ((ulCode & OR_REFERENCE) && (refObject))
    {
        DbgDataFileData *somThat = DbgDataFileGetData(refObject);
        _fDebugThis = somThat->fDebugThis;
    }
    else
        // newly instantiated:
        _fDebugThis = FALSE;

    DbgDataFileMethodDebug("DbgDataFile","ddf_wpObjectReady");
    if ((ulCode & OR_REFERENCE) && (refObject))
        _Pmpf(("           OR_REFERENCE set"));

    DbgDataFile_parent_WPDataFile_wpObjectReady(somSelf, ulCode,
                                                refObject);

    EndInstanceMethodDebug();
}

/*
 * wpIsObjectInitialized:
 */

SOM_Scope BOOL  SOMLINK ddf_wpIsObjectInitialized(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpIsObjectInitialized");

    rc = (DbgDataFile_parent_WPDataFile_wpIsObjectInitialized(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpSetError(DbgDataFile *somSelf,
                                       ULONG ulErrorId)
{
    BOOL rc = FALSE;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetError");

    rc = (DbgDataFile_parent_WPDataFile_wpSetError(somSelf,
                                                     ulErrorId));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryError(DbgDataFile *somSelf)
{
    ULONG rc = FALSE;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryError");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryError(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpLockObject:
 */

SOM_Scope void  SOMLINK ddf_wpLockObject(DbgDataFile *somSelf)
{
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpLockObject");

    DbgDataFile_parent_WPDataFile_wpLockObject(somSelf);

    EndInstanceMethodDebug();
}

/*
 * wpUnlockObject:
 */

SOM_Scope BOOL  SOMLINK ddf_wpUnlockObject(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpUnlockObject");

    rc = (DbgDataFile_parent_WPDataFile_wpUnlockObject(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpIsDeleteable:
 */

SOM_Scope BOOL  SOMLINK ddf_wpIsDeleteable(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpIsDeleteable");

    rc = (DbgDataFile_parent_WPDataFile_wpIsDeleteable(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpDelete:
 */

SOM_Scope ULONG  SOMLINK ddf_wpDelete(DbgDataFile *somSelf, ULONG fConfirmations)
{
    ULONG rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpDelete");

    rc = (DbgDataFile_parent_WPDataFile_wpDelete(somSelf, fConfirmations));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpConfirmDelete:
 */

SOM_Scope ULONG  SOMLINK ddf_wpConfirmDelete(DbgDataFile *somSelf,
                                            ULONG fConfirmations)
{
    ULONG rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpConfirmDelete");

    rc = (DbgDataFile_parent_WPDataFile_wpConfirmDelete(somSelf,
                                                      fConfirmations));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpFree:
 */

SOM_Scope BOOL  SOMLINK ddf_wpFree(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpFree");

    rc = (DbgDataFile_parent_WPDataFile_wpFree(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpUnInitData:
 */

SOM_Scope void  SOMLINK ddf_wpUnInitData(DbgDataFile *somSelf)
{
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpUnInitData");

    DbgDataFile_parent_WPDataFile_wpUnInitData(somSelf);

    EndInstanceMethodDebug();
}

/*
 * wpSetup:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetup(DbgDataFile *somSelf, PSZ pszSetupString)
{
    BOOL rc = FALSE;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetup");

    if (_fDebugThis)
        _Pmpf(("        setup string: %s", (pszSetupString) ? pszSetupString : "NULL"));

    rc = (DbgDataFile_parent_WPDataFile_wpSetup(somSelf, pszSetupString));

    EndInstanceMethodDebug();
    return (rc);
}


SOM_Scope BOOL  SOMLINK ddf_wpAssertObjectMutexSem(DbgDataFile *somSelf)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpAssertObjectMutexSem");

    rc = (DbgDataFile_parent_WPDataFile_wpAssertObjectMutexSem(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpReleaseObjectMutexSem(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpReleaseObjectMutexSem");

    rc = (DbgDataFile_parent_WPDataFile_wpReleaseObjectMutexSem(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpRequestObjectMutexSem(DbgDataFile *somSelf,
                                                     ULONG ulTimeout)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpRequestObjectMutexSem");

    rc = (DbgDataFile_parent_WPDataFile_wpRequestObjectMutexSem(somSelf,
                                                                  ulTimeout));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpSaveImmediate(DbgDataFile *somSelf)
{
    BOOL rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSaveImmediate");

    rc = (DbgDataFile_parent_WPDataFile_wpSaveImmediate(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpSaveDeferred(DbgDataFile *somSelf)
{
    BOOL rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSaveDeferred");

    rc = (DbgDataFile_parent_WPDataFile_wpSaveDeferred(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpSaveState(DbgDataFile *somSelf)
{
    BOOL rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSaveState");

    rc = (DbgDataFile_parent_WPDataFile_wpSaveState(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpRestoreState(DbgDataFile *somSelf,
                                           ULONG ulReserved)
{
    BOOL rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpRestoreState");

    rc = (DbgDataFile_parent_WPDataFile_wpRestoreState(somSelf,
                                                         ulReserved));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpCnrInsertObject:
 *
 */

SOM_Scope PMINIRECORDCORE  SOMLINK ddf_wpCnrInsertObject(DbgDataFile *somSelf,
                                                         HWND hwndCnr,
                                                         PPOINTL pptlIcon,
                                                         PMINIRECORDCORE preccParent,
                                                         PRECORDINSERT pRecInsert)
{
    PMINIRECORDCORE rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCnrInsertObject");

    if (_fDebugThis)
    {
        _Pmpf(("        hwndCnr: 0x%lX", hwndCnr));
        _Pmpf(("        pptlIcon: 0x%lX", pptlIcon));
        if (pptlIcon)
        {
            _Pmpf(("            x: %d", pptlIcon->x));
            _Pmpf(("            y: %d", pptlIcon->y));
        }
        _Pmpf(("        preccParent: 0x%lX", preccParent));
        _Pmpf(("        preccInsert: 0x%lX", pRecInsert));
    }

    rc = (DbgDataFile_parent_WPDataFile_wpCnrInsertObject(somSelf,
                                                            hwndCnr,
                                                            pptlIcon,
                                                            preccParent,
                                                            pRecInsert));
    if (_fDebugThis)
    {
        _Pmpf(("        wpCnrInsertObject: returning precc: 0x%lX", rc));
    }
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpCnrRemoveObject(DbgDataFile *somSelf,
                                              HWND hwndCnr)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCnrRemoveObject");

    rc = (DbgDataFile_parent_WPDataFile_wpCnrRemoveObject(somSelf,
                                                            hwndCnr));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpCnrSetEmphasis(DbgDataFile *somSelf,
                                             ULONG ulEmphasisAttr,
                                             BOOL fTurnOn)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCnrSetEmphasis");

    rc = (DbgDataFile_parent_WPDataFile_wpCnrSetEmphasis(somSelf,
                                                           ulEmphasisAttr,
                                                           fTurnOn));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope void  SOMLINK ddf_wpCnrRefreshDetails(DbgDataFile *somSelf)
{

    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCnrRefreshDetails");

    DbgDataFile_parent_WPDataFile_wpCnrRefreshDetails(somSelf);
    EndInstanceMethodDebug();
}

SOM_Scope PULONG  SOMLINK ddf_wpQueryContainerFlagPtr(DbgDataFile *somSelf)
{
    PULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryContainerFlagPtr");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryContainerFlagPtr(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

#ifdef __TOOLKIT_4__
SOM_Scope BOOL  SOMLINK ddf_wpIdentify(DbgDataFile *somSelf,
                                       PSZ pszIdentity)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpIdentify");

    rc = (DbgDataFile_parent_WPDataFile_wpIdentify(somSelf,
                                                     pszIdentity));
    EndInstanceMethodDebug();
    return (rc);
}
#endif

SOM_Scope ULONG  SOMLINK ddf_wpConfirmObjectTitle(DbgDataFile *somSelf,
                                                  WPFolder* Folder,
                                                  WPObject** ppDuplicate,
                                                  PSZ pszTitle,
                                                  ULONG cbTitle,
                                                  ULONG menuID)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpConfirmObjectTitle");

    rc = (DbgDataFile_parent_WPDataFile_wpConfirmObjectTitle(somSelf,
                                                               Folder,
                                                               ppDuplicate,
                                                               pszTitle,
                                                               cbTitle,
                                                               menuID));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpCreateFromTemplate:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpCreateFromTemplate(DbgDataFile *somSelf,
                                                      WPFolder* folder,
                                                      BOOL fLock)
{
    WPObject *rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCreateFromTemplate");

    rc = (DbgDataFile_parent_WPDataFile_wpCreateFromTemplate(somSelf,
                                                           folder,
                                                           fLock));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpCopiedFromTemplate:
 */

SOM_Scope void  SOMLINK ddf_wpCopiedFromTemplate(DbgDataFile *somSelf)
{
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCopiedFromTemplate");

    DbgDataFile_parent_WPDataFile_wpCopiedFromTemplate(somSelf);

    EndInstanceMethodDebug();
}

/*
 * wpCreateAnother:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpCreateAnother(DbgDataFile *somSelf,
                                                PSZ pszTitle,
                                                PSZ pszSetupEnv,
                                                WPFolder* Folder)
{
    WPObject *rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCreateAnother");

    rc = (DbgDataFile_parent_WPDataFile_wpCreateAnother(somSelf,
                                                      pszTitle,
                                                      pszSetupEnv,
                                                      Folder));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpCreateShadowObject:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpCreateShadowObject(DbgDataFile *somSelf,
                                                      WPFolder* Folder,
                                                      BOOL fLock)
{
    WPObject *rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCreateShadowObject");

    rc = (DbgDataFile_parent_WPDataFile_wpCreateShadowObject(somSelf,
                                                           Folder,
                                                           fLock));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpCreateShadowObjectExt:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpCreateShadowObjectExt(DbgDataFile *somSelf,
                                                        WPFolder* Folder,
                                                        BOOL fLock,
                                                        PSZ pszSetup,
                                                        M_WPObject* shadowClass)
{
    WPObject *rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCreateShadowObjectExt");

    rc = (DbgDataFile_parent_WPDataFile_wpCreateShadowObjectExt(somSelf,
                                                              Folder,
                                                              fLock,
                                                              pszSetup,
                                                              shadowClass));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpCopyObject:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpCopyObject(DbgDataFile *somSelf,
                                             WPFolder* Folder,
                                             BOOL fLock)
{
    WPObject *rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCopyObject");

    rc = (DbgDataFile_parent_WPDataFile_wpCopyObject(somSelf, Folder,
                                                   fLock));

    if (rc)
    {
        DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
        DbgDataFileData *somThat = DbgDataFileGetData(rc);
        _Pmpf(("0x%lX --                wpCopyObject returned 0x%lX", somSelf, rc));

        somThat->fDebugThis = _fDebugThis;
    }

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpMoveObject:
 */

SOM_Scope BOOL  SOMLINK ddf_wpMoveObject(DbgDataFile *somSelf, WPFolder* Folder)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpMoveObject");

    rc = (DbgDataFile_parent_WPDataFile_wpMoveObject(somSelf, Folder));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpReplaceObject:
 *
 */

SOM_Scope BOOL32  SOMLINK ddf_wpReplaceObject(DbgDataFile *somSelf,
                                              WPObject* targetObject,
                                              BOOL32 fMove)
{
    BOOL32 rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpReplaceObject");

    rc = (DbgDataFile_parent_WPDataFile_wpReplaceObject(somSelf,
                                                          targetObject,
                                                          fMove));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpSetTaskRec:
 *
 */

SOM_Scope BOOL32  SOMLINK ddf_wpSetTaskRec(DbgDataFile *somSelf,
                                           PTASKREC pNew,
                                           PTASKREC pOld)
{
    BOOL32 rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetTaskRec");

    if (_fDebugThis)
    {
        _Pmpf(("        pTaskRecNew pre:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pNew);
        _Pmpf(("        pTaskRecOld pre:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pOld);
        _Pmpf(("        ++ Now calling parent"));
    }

    rc = (DbgDataFile_parent_WPDataFile_wpSetTaskRec(somSelf,
                                                       pNew,
                                                       pOld));
    if (_fDebugThis)
    {
        _Pmpf(("        -- parent is done;"));

        _Pmpf(("        pTaskRecNew post:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pNew);
        _Pmpf(("        pTaskRecOld post:"));
        wpshDumpTaskRec(somSelf, "ddf_wpSetTaskRec", pOld);
    }

    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpFindTaskRec:
 *
 */

SOM_Scope PTASKREC  SOMLINK ddf_wpFindTaskRec(DbgDataFile *somSelf)
{
    PTASKREC rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpFindTaskRec");

    rc = (DbgDataFile_parent_WPDataFile_wpFindTaskRec(somSelf));

    if (_fDebugThis)
    {
        _Pmpf(("        -- wpFindTaskRec parent is done;"));
        wpshDumpTaskRec(somSelf, "found pTaskRec", rc);
    }

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetTitle:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetTitle(DbgDataFile *somSelf, PSZ pszNewTitle)
{
    BOOL rc = FALSE;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetTitle");

    if (_fDebugThis)
    {
        _Pmpf(("            new title: %s", pszNewTitle));
    }

    rc = (DbgDataFile_parent_WPDataFile_wpSetTitle(somSelf, pszNewTitle));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryTitle:
 */

SOM_Scope PSZ  SOMLINK ddf_wpQueryTitle(DbgDataFile *somSelf)
{
    PSZ rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);

    // do not debug this, since this macro calls wpQueryTitle again
    // DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryTitle");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryTitle(somSelf));

    // EndInstanceMethodDebug()
    return (rc);
}

/*
 * wpSetStyle:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetStyle(DbgDataFile *somSelf, ULONG ulNewStyle)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetStyle");

    rc = (DbgDataFile_parent_WPDataFile_wpSetStyle(somSelf, ulNewStyle));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryStyle:
 */

SOM_Scope ULONG  SOMLINK ddf_wpQueryStyle(DbgDataFile *somSelf)
{
    ULONG rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    // DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryStyle");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryStyle(somSelf));

    // EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpModifyStyle:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpModifyStyle(DbgDataFile *somSelf,
                                          ULONG ulStyleFlags,
                                          ULONG ulStyleMask)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpModifyStyle");

    rc = (DbgDataFile_parent_WPDataFile_wpModifyStyle(somSelf,
                                                        ulStyleFlags,
                                                        ulStyleMask));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetFolder:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetFolder(DbgDataFile *somSelf,
                                        WPObject* container)
{
    BOOL rc = FALSE;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetFolder");

    if (_fDebugThis)
        _Pmpf(("            new folder: 0x%lX (%s)",
                    container,
                    (container) ? _wpQueryTitle(container) : "NULL"));

    rc = (DbgDataFile_parent_WPDataFile_wpSetFolder(somSelf, container));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryFolder:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpQueryFolder(DbgDataFile *somSelf)
{
    WPObject *rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryFolder");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryFolder(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetDefaultView:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetDefaultView(DbgDataFile *somSelf,
                                            ULONG ulView)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetDefaultView");

    rc = (DbgDataFile_parent_WPDataFile_wpSetDefaultView(somSelf,
                                                       ulView));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryDefaultView:
 */

SOM_Scope ULONG  SOMLINK ddf_wpQueryDefaultView(DbgDataFile *somSelf)
{
    ULONG rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryDefaultView");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryDefaultView(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryConfirmations(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryConfirmations");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryConfirmations(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryNameClashOptions(DbgDataFile *somSelf,
                                                     ULONG menuID)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryNameClashOptions");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryNameClashOptions(somSelf,
                                                                  menuID));
    EndInstanceMethodDebug();
    return (rc);
}

#ifdef __TOOLKIT_4__
SOM_Scope BOOL  SOMLINK ddf_wpFilterMenu(DbgDataFile *somSelf,
                                         FILTERFLAGS* pFlags,
                                         HWND hwndCnr, BOOL fMultiSelect,
                                         ULONG ulMenuType, ULONG ulView,
                                         ULONG ulReserved)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpFilterMenu");

    rc = (DbgDataFile_parent_WPDataFile_wpFilterMenu(somSelf,
                                                       pFlags,
                                                       hwndCnr,
                                                       fMultiSelect,
                                                       ulMenuType,
                                                       ulView,
                                                       ulReserved));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpModifyMenu(DbgDataFile *somSelf,
                                         HWND hwndMenu, HWND hwndCnr,
                                         ULONG iPosition, ULONG ulMenuType,
                                         ULONG ulView, ULONG ulReserved)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpModifyMenu");

    rc = (DbgDataFile_parent_WPDataFile_wpModifyMenu(somSelf,
                                                       hwndMenu,
                                                       hwndCnr,
                                                       iPosition,
                                                       ulMenuType,
                                                       ulView,
                                                       ulReserved));
    EndInstanceMethodDebug();
    return (rc);
}
#endif

SOM_Scope HWND  SOMLINK ddf_wpDisplayMenu(DbgDataFile *somSelf,
                                         HWND hwndOwner, HWND hwndClient,
                                         POINTL* ptlPopupPt,
                                         ULONG ulMenuType, ULONG ulReserved)
{
    HWND rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpDisplayMenu");

    rc = (DbgDataFile_parent_WPDataFile_wpDisplayMenu(somSelf,
                                                    hwndOwner,
                                                    hwndClient,
                                                    ptlPopupPt,
                                                    ulMenuType,
                                                    ulReserved));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpFilterPopupMenu:
 */

SOM_Scope ULONG  SOMLINK ddf_wpFilterPopupMenu(DbgDataFile *somSelf,
                                              ULONG ulFlags,
                                              HWND hwndCnr, BOOL fMultiSelect)
{
    ULONG rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpFilterPopupMenu");

    rc = (DbgDataFile_parent_WPDataFile_wpFilterPopupMenu(somSelf,
                                                        ulFlags,
                                                        hwndCnr,
                                                        fMultiSelect));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpModifyPopupMenu:
 */

SOM_Scope BOOL  SOMLINK ddf_wpModifyPopupMenu(DbgDataFile *somSelf,
                                             HWND hwndMenu, HWND hwndCnr,
                                             ULONG iPosition)
{
    BOOL rc = FALSE;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpModifyPopupMenu");

    rc = DbgDataFile_parent_WPDataFile_wpModifyPopupMenu(somSelf,
                                                        hwndMenu,
                                                        hwndCnr,
                                                        iPosition);

    if (rc)
    {
        winhInsertMenuItem(hwndMenu, MIT_END,
                           ID_DOMI_DEBUGTHIS,
                           "~Trace this object's method calls",
                           MIS_TEXT,
                           (_fDebugThis)
                                ? MIA_CHECKED
                                : 0);
        winhInsertMenuItem(hwndMenu, MIT_END,
                           ID_DOMI_DEBUGALL,
                           "~Trace all initialization method calls",
                           MIS_TEXT,
                           (G_fDebugDataFileInit)
                                ? MIA_CHECKED
                                : 0);
    }

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpInsertPopupMenuItems:
 */

SOM_Scope BOOL  SOMLINK ddf_wpInsertPopupMenuItems(DbgDataFile *somSelf,
                                                  HWND hwndMenu,
                                                  ULONG iPosition,
                                                  HMODULE hmod,
                                                  ULONG MenuID,
                                                  ULONG SubMenuID)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpInsertPopupMenuItems");

    rc = (DbgDataFile_parent_WPDataFile_wpInsertPopupMenuItems(somSelf,
                                                             hwndMenu,
                                                             iPosition,
                                                             hmod,
                                                             MenuID,
                                                             SubMenuID));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpMenuItemSelected:
 */

SOM_Scope BOOL  SOMLINK ddf_wpMenuItemSelected(DbgDataFile *somSelf,
                                              HWND hwndFrame,
                                              ULONG ulMenuId)
{
    BOOL    rc = FALSE;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    BOOL    fNewDebug = _fDebugThis,
            fNewDebugAll = G_fDebugDataFileInit;
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpMenuItemSelected");

    if (ulMenuId == ID_DOMI_DEBUGTHIS)
    {
        fNewDebug = !fNewDebug;
        rc = TRUE;
    }
    else if (ulMenuId == ID_DOMI_DEBUGALL)
    {
        fNewDebugAll = !fNewDebugAll;
        rc = TRUE;
    }
    else
    {
        _Pmpf(("            wpMenuItemSelected ulmenuID: 0x%lX", ulMenuId));
        rc = DbgDataFile_parent_WPDataFile_wpMenuItemSelected(somSelf,
                                                         hwndFrame,
                                                         ulMenuId);
    }

    EndInstanceMethodDebug();
    _fDebugThis = fNewDebug;
    G_fDebugDataFileInit = fNewDebugAll;
    return (rc);
}

/*
 * wpMenuItemHelpSelected:
 */

SOM_Scope BOOL  SOMLINK ddf_wpMenuItemHelpSelected(DbgDataFile *somSelf,
                                                  ULONG MenuId)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpMenuItemHelpSelected");

    rc = (DbgDataFile_parent_WPDataFile_wpMenuItemHelpSelected(somSelf,
                                                             MenuId));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpViewObject:
 */

SOM_Scope HWND  SOMLINK ddf_wpViewObject(DbgDataFile *somSelf, HWND hwndCnr,
                                        ULONG ulView, ULONG param)
{
    HWND rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpViewObject");

    rc = (DbgDataFile_parent_WPDataFile_wpViewObject(somSelf, hwndCnr,
                                                   ulView, param));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpOpen:
 */

SOM_Scope HWND  SOMLINK ddf_wpOpen(DbgDataFile *somSelf, HWND hwndCnr,
                                  ULONG ulView, ULONG param)
{
    HWND rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpOpen");

    rc = (DbgDataFile_parent_WPDataFile_wpOpen(somSelf, hwndCnr,
                                             ulView, param));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpRegisterView:
 */

SOM_Scope BOOL  SOMLINK ddf_wpRegisterView(DbgDataFile *somSelf,
                                          HWND hwndFrame, PSZ pszViewTitle)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpRegisterView");

    rc = (DbgDataFile_parent_WPDataFile_wpRegisterView(somSelf,
                                                     hwndFrame,
                                                     pszViewTitle));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpClose:
 */

SOM_Scope BOOL  SOMLINK ddf_wpClose(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpClose");

    rc = (DbgDataFile_parent_WPDataFile_wpClose(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpHide:
 */

SOM_Scope BOOL  SOMLINK ddf_wpHide(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpHide");

    rc = (DbgDataFile_parent_WPDataFile_wpHide(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpRestore:
 */

SOM_Scope BOOL  SOMLINK ddf_wpRestore(DbgDataFile *somSelf)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpRestore");

    rc = (DbgDataFile_parent_WPDataFile_wpRestore(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpAddToObjUseList:
 */

SOM_Scope BOOL  SOMLINK ddf_wpAddToObjUseList(DbgDataFile *somSelf,
                                             PUSEITEM pUseItem)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpAddToObjUseList");

    rc = (DbgDataFile_parent_WPDataFile_wpAddToObjUseList(somSelf,
                                                        pUseItem));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpDeleteFromObjUseList:
 */

SOM_Scope BOOL  SOMLINK ddf_wpDeleteFromObjUseList(DbgDataFile *somSelf,
                                                  PUSEITEM pUseItem)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpDeleteFromObjUseList");

    rc = (DbgDataFile_parent_WPDataFile_wpDeleteFromObjUseList(somSelf,
                                                             pUseItem));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpCnrDeleteUseItem:
 */

SOM_Scope BOOL  SOMLINK ddf_wpCnrDeleteUseItem(DbgDataFile *somSelf,
                                              HWND hwndCnr)
{
    BOOL rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpCnrDeleteUseItem");

    rc = (DbgDataFile_parent_WPDataFile_wpCnrDeleteUseItem(somSelf,
                                                         hwndCnr));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpFindUseItem:
 */

SOM_Scope PUSEITEM  SOMLINK ddf_wpFindUseItem(DbgDataFile *somSelf,
                                             ULONG type, PUSEITEM pCurrentItem)
{
    PUSEITEM rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpFindUseItem");

    rc = (DbgDataFile_parent_WPDataFile_wpFindUseItem(somSelf,
                                                    type, pCurrentItem));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpFindViewItem:
 */

SOM_Scope PVIEWITEM  SOMLINK ddf_wpFindViewItem(DbgDataFile *somSelf,
                                               ULONG flViews,
                                               PVIEWITEM pCurrentItem)
{
    PVIEWITEM rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpFindViewItem");

    rc = (DbgDataFile_parent_WPDataFile_wpFindViewItem(somSelf,
                                                     flViews,
                                                     pCurrentItem));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSwitchTo:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSwitchTo(DbgDataFile *somSelf, ULONG View)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSwitchTo");

    rc = (DbgDataFile_parent_WPDataFile_wpSwitchTo(somSelf, View));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpDoesObjectMatch:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpDoesObjectMatch(DbgDataFile *somSelf,
                                              PVOID pvoidExtendedCriteria)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpDoesObjectMatch");

    rc = (DbgDataFile_parent_WPDataFile_wpDoesObjectMatch(somSelf,
                                                            pvoidExtendedCriteria));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetIcon:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetIcon(DbgDataFile *somSelf, HPOINTER hptrNewIcon)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetIcon");

    rc = (DbgDataFile_parent_WPDataFile_wpSetIcon(somSelf, hptrNewIcon));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryIcon:
 */

SOM_Scope HPOINTER  SOMLINK ddf_wpQueryIcon(DbgDataFile *somSelf)
{
    HPOINTER rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryIcon");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryIcon(somSelf));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetIconData:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetIconData(DbgDataFile *somSelf,
                                         PICONINFO pIconInfo)
{
    BOOL rc = FALSE;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetIconData");

    rc = (DbgDataFile_parent_WPDataFile_wpSetIconData(somSelf,
                                                    pIconInfo));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryIconData:
 */

SOM_Scope ULONG  SOMLINK ddf_wpQueryIconData(DbgDataFile *somSelf,
                                            PICONINFO pIconInfo)
{
    ULONG rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryIconData");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryIconData(somSelf,
                                                      pIconInfo));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetDefaultIconPos:
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetDefaultIconPos(DbgDataFile *somSelf,
                                               PPOINTL pPointl)
{
    BOOL rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetDefaultIconPos");

    if (pPointl)
    {
        _Pmpf(("            x: %d", pPointl->x));
        _Pmpf(("            y: %d", pPointl->y));
    }

    rc = (DbgDataFile_parent_WPDataFile_wpSetDefaultIconPos(somSelf,
                                                          pPointl));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryDefaultIconPos:
 */

/*
 * wpQueryDefaultIconPos:
 *
 *     * WPDataFile methods overridden by DbgDataFile:
 *
 */

/*
 * wpQueryDefaultIconPos:
 *
 *     * WPFileSystem methods overridden by DbgDataFile:
 *
 */

/*
 *
 *     * WPFileSystem methods overridden by DbgDataFile:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpQueryDefaultIconPos(DbgDataFile *somSelf,
                                                  PPOINTL pPointl)
{
    BOOL rc = 0;
    // // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryDefaultIconPos");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryDefaultIconPos(somSelf,
                                                            pPointl));
    EndInstanceMethodDebug();
    return (rc);
}


/*
 *@@ wpSetRealName:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetRealName(DbgDataFile *somSelf,
                                          PSZ pszName)
{
    BOOL rc = 0;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetRealName");

    rc = DbgDataFile_parent_WPDataFile_wpSetRealName(somSelf,
                                                        pszName);

    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpSetType(DbgDataFile *somSelf, PSZ pszTypes,
                                      PFEA2LIST pfeal)
{
    BOOL rc = 0;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetType");

    rc = (DbgDataFile_parent_WPDataFile_wpSetType(somSelf,
                                                    pszTypes,
                                                    pfeal));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PSZ  SOMLINK ddf_wpQueryType(DbgDataFile *somSelf)
{
    PSZ rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryType");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryType(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpSetAttr(DbgDataFile *somSelf, ULONG attrFile)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetAttr");

    rc = (DbgDataFile_parent_WPDataFile_wpSetAttr(somSelf,
                                                    attrFile));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryAttr(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryAttr");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryAttr(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryCreation(DbgDataFile *somSelf,
                                             FDATE* fdate, FTIME* ftime)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryCreation");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryCreation(somSelf,
                                                          fdate,
                                                          ftime));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryLastAccess(DbgDataFile *somSelf,
                                               FDATE* fdate,
                                               FTIME* ftime)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryLastAccess");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryLastAccess(somSelf,
                                                            fdate,
                                                            ftime));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryLastWrite(DbgDataFile *somSelf,
                                              FDATE* fdate, FTIME* ftime)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryLastWrite");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryLastWrite(somSelf,
                                                           fdate,
                                                           ftime));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryFileSize(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryFileSize");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryFileSize(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryEASize(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryEASize");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryEASize(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpSetDateInfo:
 *
 */

SOM_Scope ULONG  SOMLINK ddf_wpSetDateInfo(DbgDataFile *somSelf,
                                           FILEFINDBUF4* pstFileFindBuf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetDateInfo");

    rc = (DbgDataFile_parent_WPDataFile_wpSetDateInfo(somSelf,
                                                        pstFileFindBuf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpSetFileSizeInfo:
 *
 */

SOM_Scope ULONG  SOMLINK ddf_wpSetFileSizeInfo(DbgDataFile *somSelf,
                                               ULONG cbFileSize,
                                               ULONG cbEASize)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetFileSizeInfo");

    rc = (DbgDataFile_parent_WPDataFile_wpSetFileSizeInfo(somSelf,
                                                            cbFileSize,
                                                            cbEASize));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpRefresh:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpRefresh(DbgDataFile *somSelf, ULONG ulView,
                                      PVOID pReserved)
{
    BOOL rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpRefresh");

    rc = (DbgDataFile_parent_WPDataFile_wpRefresh(somSelf,
                                                    ulView, pReserved));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpQueryRefreshFlags:
 *
 */

SOM_Scope ULONG  SOMLINK ddf_wpQueryRefreshFlags(DbgDataFile *somSelf)
{
    ULONG rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryRefreshFlags");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryRefreshFlags(somSelf));

    if (_fDebugThis)
        _Pmpf(("            refresh flags: 0x%lX", rc));

    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpSetRefreshFlags:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetRefreshFlags(DbgDataFile *somSelf,
                                              ULONG ulRefreshFlags)
{
    BOOL rc;
    DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetRefreshFlags");

    if (_fDebugThis)
        _Pmpf(("            new refresh flags: 0x%lX", ulRefreshFlags));
    rc = (DbgDataFile_parent_WPDataFile_wpSetRefreshFlags(somSelf,
                                                            ulRefreshFlags));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpSetTitleAndRenameFile:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpSetTitleAndRenameFile(DbgDataFile *somSelf,
                                                    PSZ pszNewTitle,
                                                    ULONG fConfirmations)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetTitleAndRenameFile");

    rc = (DbgDataFile_parent_WPDataFile_wpSetTitleAndRenameFile(somSelf,
                                                                  pszNewTitle,
                                                                  fConfirmations));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpConfirmRenameFileWithExt:
 *
 */

SOM_Scope ULONG  SOMLINK ddf_wpConfirmRenameFileWithExt(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpConfirmRenameFileWithExt");

    rc = (DbgDataFile_parent_WPDataFile_wpConfirmRenameFileWithExt(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *     wpQueryEASupport: override;
 */

/*
 *@@ wpVerifyUpdateAccess:
 *
 */

SOM_Scope ULONG  SOMLINK ddf_wpVerifyUpdateAccess(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpVerifyUpdateAccess");

    rc = (DbgDataFile_parent_WPDataFile_wpVerifyUpdateAccess(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpAddUserItemsToPopupMenu:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpAddUserItemsToPopupMenu(DbgDataFile *somSelf,
                                                      HWND hwndMenu,
                                                      HWND hwndCnr,
                                                      ULONG iPosition)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpAddUserItemsToPopupMenu");

    rc = (DbgDataFile_parent_WPDataFile_wpAddUserItemsToPopupMenu(somSelf,
                                                                    hwndMenu,
                                                                    hwndCnr,
                                                                    iPosition));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpIsDiskSwapped:
 *
 */

SOM_Scope BOOL  SOMLINK ddf_wpIsDiskSwapped(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpIsDiskSwapped");

    rc = (DbgDataFile_parent_WPDataFile_wpIsDiskSwapped(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope BOOL  SOMLINK ddf_wpQueryRealName(DbgDataFile *somSelf,
                                            PSZ pszFilename,
                                            PULONG pcb, BOOL fQualified)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryRealName");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryRealName(somSelf,
                                                          pszFilename,
                                                          pcb,
                                                          fQualified));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope PSZ  SOMLINK ddf_wpQueryFilename(DbgDataFile *somSelf,
                                           PSZ pszFilename, BOOL fQualified)
{
    PSZ rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryFilename");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryFilename(somSelf,
                                                          pszFilename,
                                                          fQualified));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *@@ wpQueryDisk:
 *
 */

SOM_Scope WPFileSystem*  SOMLINK ddf_wpQueryDisk(DbgDataFile *somSelf)
{
    WPFileSystem *rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryDisk");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryDisk(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

SOM_Scope ULONG  SOMLINK ddf_wpQueryDateInfo(DbgDataFile *somSelf,
                                             FILEFINDBUF4* pstFileFindBuf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryDateInfo");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryDateInfo(somSelf,
                                                          pstFileFindBuf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 *    wpSetTitleNoRenameFile: override;
 *    wpSetNewRealName: override;
 *    wpAdoptNewRealName: override;
 *    wpQueryDriveData: override;
 *    wpRefreshFSInfo: override;
 *    wpAddUserMenuItem: override;
 *    wpRemoveFileAttrs: override;
 *    wpSetEASupport: override;
 *    wpResetHandle: override;
 *
 *     * WPDataFile methods overridden by DbgDataFile:
 *
 */

/*
 *
 *     * WPDataFile methods overridden by DbgDataFile:
 *
 */

SOM_Scope ULONG  SOMLINK ddf_wpConfirmKeepAssoc(DbgDataFile *somSelf)
{
    ULONG rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpConfirmKeepAssoc");

    rc = (DbgDataFile_parent_WPDataFile_wpConfirmKeepAssoc(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryAssociatedFileIcon:
 */

SOM_Scope HPOINTER  SOMLINK ddf_wpQueryAssociatedFileIcon(DbgDataFile *somSelf)
{
    HPOINTER rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryAssociatedFileIcon");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryAssociatedFileIcon(somSelf));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpQueryAssociatedProgram:
 */

SOM_Scope WPObject*  SOMLINK ddf_wpQueryAssociatedProgram(DbgDataFile *somSelf,
                                                          ULONG ulView,
                                                          PULONG pulHowMatched,
                                                          PSZ pszMatchString,
                                                          ULONG cbMatchString,
                                                          PSZ pszDefaultType)
{
    WPObject *rc;
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpQueryAssociatedProgram");

    rc = (DbgDataFile_parent_WPDataFile_wpQueryAssociatedProgram(somSelf,
                                                                   ulView,
                                                                   pulHowMatched,
                                                                   pszMatchString,
                                                                   cbMatchString,
                                                                   pszDefaultType));
    EndInstanceMethodDebug();
    return (rc);
}

/*
 * wpSetAssociatedFileIcon:
 */

SOM_Scope void  SOMLINK ddf_wpSetAssociatedFileIcon(DbgDataFile *somSelf)
{
    // DbgDataFileData *somThis = DbgDataFileGetData(somSelf);
    DbgDataFileMethodDebug("DbgDataFile","ddf_wpSetAssociatedFileIcon");

    DbgDataFile_parent_WPDataFile_wpSetAssociatedFileIcon(somSelf);
    EndInstanceMethodDebug();
}


/* ******************************************************************
 *
 *   here come the DbgDataFile class methods
 *
 ********************************************************************/

SOM_Scope SOMObject*  SOMLINK ddfM_somNew(M_DbgDataFile *somSelf)
{
    SOMObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somNew");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somNew"));
    }

    rc = (M_DbgDataFile_parent_M_WPDataFile_somNew(somSelf));

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somNew; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK ddfM_somNewNoInit(M_DbgDataFile *somSelf)
{
    SOMObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somNewNoInit");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somNewNoInit"));
    }

    rc =  (M_DbgDataFile_parent_M_WPDataFile_somNewNoInit(somSelf));

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somNewNoInit; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK ddfM_somRenew(M_DbgDataFile *somSelf,
                                            void* obj)
{
    SOMObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somRenew");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somRenew for obj 0x%lX", obj ));
    }

    rc =  (M_DbgDataFile_parent_M_WPDataFile_somRenew(somSelf,
                                                       obj));
    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somRenew; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK ddfM_somRenewNoInit(M_DbgDataFile *somSelf,
                                                  void* obj)
{
    SOMObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somRenewNoInit");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somRenewNoInit for obj 0x%lX", obj ));
    }

    rc =  (M_DbgDataFile_parent_M_WPDataFile_somRenewNoInit(somSelf,
                                                             obj));
    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somRenewNoInit; returning obj 0x%lX", rc ));
    }

    return (rc);
}

SOM_Scope SOMObject*  SOMLINK ddfM_somRenewNoInitNoZero(M_DbgDataFile *somSelf,
                                                        void* obj)
{
    SOMObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somRenewNoInitNoZero");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somRenewNoInitNoZero for obj 0x%lX", obj ));
    }

    rc =  (M_DbgDataFile_parent_M_WPDataFile_somRenewNoInitNoZero(somSelf,
                                                                   obj));
    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somRenewNoInitNoZero; returning obj 0x%lX",
                rc));
    }

    return (rc);
}

/*
 *
 *     * M_WPObject methods overridden by M_DbgDataFile:
 *
 */

SOM_Scope SOMObject*  SOMLINK ddfM_somRenewNoZero(M_DbgDataFile *somSelf,
                                                  void* obj)
{
    SOMObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somRenewNoZero");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somRenewNoZero"));
    }

    rc =  (M_DbgDataFile_parent_M_WPDataFile_somRenewNoZero(somSelf,
                                                             obj));
    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somRenewNoZero; returning obj 0x%lX", rc ));
    }

    return (rc);
}

/*
 *@@ somGetInstancePartSize:
 *
 */

SOM_Scope long  SOMLINK ddfM_somGetInstancePartSize(M_DbgDataFile *somSelf)
{
    long rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somGetInstancePartSize");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somGetInstancePartSize"));
    }

    rc  = (M_DbgDataFile_parent_M_WPDataFile_somGetInstancePartSize(somSelf));

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somGetInstancePartSize; returning 0x%lX", rc ));
    }
    return (rc);
}

/*
 *
 *     * M_WPObject methods overridden by M_DbgDataFile:
 *
 */

/*
 *@@ somGetInstanceSize:
 *
 */

SOM_Scope long  SOMLINK ddfM_somGetInstanceSize(M_DbgDataFile *somSelf)
{
    long rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_somGetInstanceSize");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering somGetInstanceSize"));
    }

    rc = (M_DbgDataFile_parent_M_WPDataFile_somGetInstanceSize(somSelf));

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of somGetInstanceSize; returning 0x%lX", rc ));
    }
    return (rc);
}

/*
 * wpclsInitData:
 */

SOM_Scope void  SOMLINK ddfM_wpclsInitData(M_DbgDataFile *somSelf)
{
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_wpclsInitData");

    M_DbgDataFile_parent_M_WPDataFile_wpclsInitData(somSelf);
}


SOM_Scope WPObject*  SOMLINK ddfM_wpclsMakeAwake(M_DbgDataFile *somSelf,
                                                 PSZ pszTitle,
                                                 ULONG ulStyle,
                                                 HPOINTER hptrIcon,
                                                 POBJDATA pObjData,
                                                 WPFolder* Folder,
                                                 ULONG ulUser)
{
    WPObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_wpclsMakeAwake");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering wpclsMakeAwake"));
        _Pmpf(("        title: %s, ulStyle: 0x%lX, hptrIcon: 0x%lX, pObjData: 0x%lX, folder: 0x%lX (%s), ulUser: 0x%lX",
                    (pszTitle) ? pszTitle : "NULL",
                    ulStyle,
                    hptrIcon,
                    pObjData,
                    Folder,
                    (Folder) ? _wpQueryTitle(Folder) : "NULL",
                    ulUser));
    }

    rc = M_DbgDataFile_parent_M_WPDataFile_wpclsMakeAwake(somSelf,
                                                          pszTitle,
                                                          ulStyle,
                                                          hptrIcon,
                                                          pObjData,
                                                          Folder,
                                                          ulUser);

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of wpclsMakeAwake; returning obj 0x%lX (%s)", rc, _wpQueryTitle(rc) ));
    }

    return (rc);
}

SOM_Scope WPObject*  SOMLINK ddfM_wpclsNew(M_DbgDataFile *somSelf,
                                           PSZ pszTitle,
                                           PSZ pszSetupEnv,
                                           WPFolder* Folder,
                                           BOOL fLock)
{
    WPObject *rc;
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_wpclsNew");

    if (G_fDebugDataFileInit)
    {
        _Pmpf(("++ Entering wpclsNew"));
        _Pmpf(("        title: %s, setup: %s, folder: 0x%lX (%s), fLock: %d",
                    (pszTitle) ? pszTitle : "NULL",
                    (pszSetupEnv) ? pszSetupEnv : "NULL",
                    Folder,
                    (Folder) ? _wpQueryTitle(Folder) : "NULL",
                    fLock));
    }

    rc = M_DbgDataFile_parent_M_WPDataFile_wpclsNew(somSelf,
                                                       pszTitle,
                                                       pszSetupEnv,
                                                       Folder,
                                                       fLock);
    if (G_fDebugDataFileInit)
    {
        _Pmpf(("-- End of wpclsNew; returned obj 0x%lX (%s)", rc, _wpQueryTitle(rc) ));
    }

    return (rc);
}


SOM_Scope WPObject*  SOMLINK ddfM_wpclsFileSysExists(M_DbgDataFile *somSelf,
                                                     WPFolder* Folder,
                                                     PSZ pszFilename,
                                                     ULONG attrFile)
{
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_wpclsFileSysExists");

    return (M_DbgDataFile_parent_M_WPDataFile_wpclsFileSysExists(somSelf,
                                                                 Folder,
                                                                 pszFilename,
                                                                 attrFile));
}

SOM_Scope WPObject*  SOMLINK ddfM_wpclsQueryAwakeObject(M_DbgDataFile *somSelf,
                                                        PSZ pszInputPath)
{
    /* M_DbgDataFileData *somThis = M_DbgDataFileGetData(somSelf); */
    M_DbgDataFileMethodDebug("M_DbgDataFile","ddfM_wpclsQueryAwakeObject");

    return (M_DbgDataFile_parent_M_WPDataFile_wpclsQueryAwakeObject(somSelf,
                                                                    pszInputPath));
}

