<*+ MAIN *> 
MODULE ackermann;

IMPORT InOut;

VAR p1, p2, count: LONGINT;

PROCEDURE ack (m, n: LONGINT): LONGINT;
BEGIN
  INC (count);
  IF m=0 THEN RETURN n+1 END;
  IF n=0 THEN RETURN ack (m-1, 1) END;
  RETURN ack (m-1, ack (m, n-1));
END ack;

BEGIN
  count := 0;
  InOut.WriteString ("Ackermann Function Calculation"); InOut.WriteLn;
  InOut.WriteString ("------------------------------"); InOut.WriteLn;
  InOut.WriteLn;
  InOut.WriteString ("Enter first  parameter (1..4): "); InOut.ReadInt (p1);
  InOut.WriteString ("Enter second parameter (1..7): "); InOut.ReadInt (p2);
  InOut.WriteLn;
  InOut.WriteString ("Ackermann ("); InOut.WriteInt (p1, 0);
  InOut.WriteString (", "); InOut.WriteInt(p2, 0);
  InOut.WriteString ("): ");
  InOut.WriteInt (ack (p1, p2), 0);
  InOut.WriteString (" ("); InOut.WriteInt (count, 0);
  InOut.WriteString (" recursive calls)");
  InOut.WriteLn;
END ackermann.
