MODULE puredhry;

IMPORT dry1, dry2, InOut;
FROM Storage IMPORT ALLOCATE;

TYPE longint = INTEGER; (* CARDINAL for some compilers *)

(* InOut replacement *)

PROCEDURE wl; BEGIN InOut.WriteLn; END wl;
PROCEDURE wc(c: CHAR); BEGIN InOut.Write(c); END wc;

PROCEDURE ws (s: ARRAY OF CHAR);
VAR i: CARDINAL;
BEGIN
  FOR i := 0 TO HIGH(s) DO
    IF s[i]=0C THEN RETURN; END;
    wc (s[i]);
  END;
END ws;

PROCEDURE wb(b: BOOLEAN);
BEGIN
  IF b THEN InOut.WriteString ("TRUE");
  ELSE      InOut.WriteString ("FALSE");
  END;
END wb;

PROCEDURE we(e: dry2.Enumeration);
BEGIN
  CASE e OF
    |dry2.Ident1: ws ("Ident1");
    |dry2.Ident2: ws ("Ident2");
    |dry2.Ident3: ws ("Ident3");
    |dry2.Ident4: ws ("Ident4");
    |dry2.Ident5: ws ("Ident5");
    |ELSE ws ("Error - unexpected value");
  END;
END we;

PROCEDURE wli (n: longint);
  VAR i: INTEGER;
    buf: ARRAY [0..31] OF CHAR;
BEGIN
  i := 0;
  WHILE n > 0 DO
    buf[i] := CHR(ORD('0') + VAL(CARDINAL,n MOD 10)); INC(i); n := n DIV 10;
  END;
  IF i = 0 THEN buf[0] := '0'; INC(i); END;
  REPEAT DEC(i); wc (buf[i]); UNTIL i=0;
END wli;

PROCEDURE wi (i: dry2.integer);
BEGIN
  wli (VAL(longint, i));
END wi;

PROCEDURE rli (VAR n: longint);
VAR
  c: CHAR;
  t: longint;
BEGIN
  n := 0;
  LOOP
    InOut.Read (c);
    IF (c<'0') OR (c>'9') THEN RETURN END;
    t := VAL (longint, ORD(c) - ORD('0'));
    IF (MAX(longint)-t) DIV 10 < n THEN
      wl; wl; ws ("Error: value is too big"); wl; wl; HALT;
    END;
    n := n*10 + t;
  END;
END rli;

PROCEDURE Proc0;

  (* main program, corresponds to procedures        *)
  (* Main and Proc0 in the Ada version              *)

VAR

  Int1Loc,
  Int2Loc,
  Int3Loc: dry2.integer;
  ChIndex: CHAR;
  EnumLoc: dry2.Enumeration;
  Str1Loc: dry2.Str30;
  Str2Loc: dry2.Str30;
  RunIndex,
  NumberOfRuns,
  n: longint;

BEGIN

  (* Initializations *)

  NEW(dry2.NextPtrGlob);
  NEW(dry2.PtrGlob);

  dry2.PtrGlob^.PtrComp  := dry2.NextPtrGlob;
  dry2.PtrGlob^.Discr    := dry2.Ident1;
  dry2.PtrGlob^.EnumComp := dry2.Ident3;
  dry2.PtrGlob^.IntComp  := 40;
  dry2.PtrGlob^.StrComp  := "DHRYSTONE PROGRAM, SOME STRING";
  Str1Loc                := "DHRYSTONE PROGRAM, 1'ST STRING";

  dry2.Arr2Glob [8][7] := 10;
        (* Was missing in published program. Without this statement,    *)
        (* Arr2Glob [8][7] would have an undefined value.               *)
        (* Warning: With 16-Bit processors and NumberOfRuns > 32000,    *)
        (* overflow may occur for this array element.                   *)

  wl;
  ws ("Dhrystone Benchmark, Version 2.1 (Language: Modula-2)"); wl; wl;

  ws ("Please give the number of runs through the benchmark: ");
  rli (n); wl; NumberOfRuns := n;

  ws ("Execution starts, "); wli (NumberOfRuns);
  ws (" runs through Dhrystone"); wl;

  RunIndex := 0;

  (***************)
  (* Start timer *)
  (***************)

  WHILE RunIndex < NumberOfRuns DO INC (RunIndex);
    dry1.Proc5;
    dry1.Proc4;
      (* Ch1Glob == 'A', Ch2Glob == 'B', BoolGlob == true *)
    Int1Loc := 2;
    Int2Loc := 3;
    Str2Loc := "DHRYSTONE PROGRAM, 2'ND STRING";
    EnumLoc := dry2.Ident2;
    dry2.BoolGlob := NOT dry2.Func2 (Str1Loc, Str2Loc);
      (* BoolGlob == 1 *)

    WHILE Int1Loc < Int2Loc DO  (* loop body executed once *)
      Int3Loc := 5 * Int1Loc - Int2Loc;
        (* Int3Loc == 7 *)
      dry2.Proc7 (Int1Loc, Int2Loc, Int3Loc);
        (* Int3Loc == 7 *)
      INC (Int1Loc);
    END;
      (* Int1Loc == 3, Int2Loc == 3, Int3Loc == 7 *)
    dry2.Proc8 (dry2.Arr1Glob, dry2.Arr2Glob, Int1Loc, Int3Loc);
      (* IntGlob == 5 *)
    dry1.Proc1 (dry2.PtrGlob);
    FOR ChIndex := 'A' TO dry2.Ch2Glob DO
        (* loop body executed twice *)
      IF EnumLoc = dry2.Func1 (ChIndex, 'C') THEN
          (* then, not executed *)
        dry2.Proc6 (dry2.Ident1, EnumLoc);
        Str2Loc := "DHRYSTONE PROGRAM, 3'RD STRING";
        Int2Loc := Int1Loc;
        dry2.IntGlob := Int1Loc;
       END;
    END;
      (* Int1Loc == 3, Int2Loc == 3, Int3Loc == 7 *)
    Int2Loc := Int2Loc * Int1Loc;
    Int1Loc := Int2Loc DIV Int3Loc;
    Int2Loc := 7 * (Int2Loc - Int3Loc) - Int1Loc;
      (* Int1Loc == 1, Int2Loc == 13, Int3Loc == 7 *)
    dry1.Proc2 (Int1Loc);
      (* Int1Loc == 5 *)
  END; (* loop "for RunIndex" *)

  (**************)
  (* Stop timer *)
  (**************)

  ws ("Execution ends"); wl; wl;
  ws ("Final values of the variables used in the benchmark:"); wl; wl;
  ws ("IntGlob:           "); wi(dry2.IntGlob); wl;
  ws ("        should be: 5"); wl;
  ws ("BoolGlob:          "); wb (dry2.BoolGlob); wl;
  ws ("        should be: TRUE"); wl;
  ws ("Ch1Glob:           "); wc (dry2.Ch1Glob); wl;
  ws ("        should be: A"); wl;
  ws ("Ch2Glob:           "); wc (dry2.Ch2Glob); wl;
  ws ("        should be: B"); wl;
  ws ("Arr1Glob[8]:       "); wi (dry2.Arr1Glob[8]); wl;
  ws ("        should be: 7"); wl;
  ws ("Arr2Glob[8][7]:    "); wi (dry2.Arr2Glob[8][7]); wl;
  ws ("        should be: NumberOfRuns + 10"); wl;

  ws ("PtrGlob^.PtrComp must be equal to dry2.NextPtrGlob^.PtrComp -- ");
  IF dry2.PtrGlob^.PtrComp=dry2.NextPtrGlob^.PtrComp THEN ws ("OK");
  ELSE ws ("error!");
  END;
  wl;

  ws ("PtrGlob"); wl;
  ws ("  Discr:           "); we (dry2.PtrGlob^.Discr); wl;
  ws ("        should be: Ident1"); wl;
  ws ("  EnumComp:        "); we (dry2.PtrGlob^.EnumComp); wl;
  ws ("        should be: Ident3"); wl;
  ws ("  IntComp:         "); wi (dry2.PtrGlob^.IntComp); wl;
  ws ("        should be: 17"); wl;
  ws ("  StrComp:         "); ws (dry2.PtrGlob^.StrComp); wl;
  ws ("        should be: DHRYSTONE PROGRAM, SOME STRING"); wl;
  ws ("NextPtrGlob"); wl;
  ws ("  Discr:           "); we (dry2.NextPtrGlob^.Discr); wl;
  ws ("        should be: Ident1"); wl;
  ws ("  EnumComp:        "); we (dry2.NextPtrGlob^.EnumComp); wl;
  ws ("        should be: Ident2"); wl;
  ws ("  IntComp:         "); wi (dry2.NextPtrGlob^.IntComp); wl;
  ws ("        should be: 18"); wl;
  ws ("  StrComp:         "); ws (dry2.NextPtrGlob^.StrComp); wl;
  ws ("        should be: DHRYSTONE PROGRAM, SOME STRING"); wl;
  ws ("Int1Loc:           "); wi (Int1Loc); wl;
  ws ("        should be: 5"); wl;
  ws ("Int2Loc:           "); wi (Int2Loc); wl;
  ws ("        should be: 13"); wl;
  ws ("Int3Loc:           "); wi (Int3Loc); wl;
  ws ("        should be: 7"); wl;
  ws ("EnumLoc:           "); we (EnumLoc); wl;
  ws ("        should be: Ident2"); wl;
  ws ("Str1Loc:           "); ws (Str1Loc); wl;
  ws ("        should be: DHRYSTONE PROGRAM, 1'ST STRING"); wl;
  ws ("Str2Loc:           "); ws (Str2Loc); wl;
  ws ("        should be: DHRYSTONE PROGRAM, 2'ND STRING"); wl;
  wl;
END Proc0;


BEGIN
  Proc0;
END puredhry.
